/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.application;

import CH.ifa.draw.figures.GroupCommand;
import CH.ifa.draw.figures.UngroupCommand;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.AlignCommand;
import CH.ifa.draw.standard.BringToFrontCommand;
import CH.ifa.draw.standard.BufferedUpdateStrategy;
import CH.ifa.draw.standard.ChangeAttributeCommand;
import CH.ifa.draw.standard.CopyCommand;
import CH.ifa.draw.standard.CutCommand;
import CH.ifa.draw.standard.DeleteCommand;
import CH.ifa.draw.standard.DuplicateCommand;
import CH.ifa.draw.standard.PasteCommand;
import CH.ifa.draw.standard.SelectionTool;
import CH.ifa.draw.standard.SendToBackCommand;
import CH.ifa.draw.standard.SimpleUpdateStrategy;
import CH.ifa.draw.standard.StandardDrawing;
import CH.ifa.draw.standard.StandardDrawingView;
import CH.ifa.draw.standard.ToggleGridCommand;
import CH.ifa.draw.standard.ToolButton;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.Iconkit;
import CH.ifa.draw.util.PaletteButton;
import CH.ifa.draw.util.PaletteListener;
import CH.ifa.draw.util.SerializationStorageFormat;
import CH.ifa.draw.util.StandardStorageFormat;
import CH.ifa.draw.util.StorageFormat;
import CH.ifa.draw.util.StorageFormatManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class DrawApplication
extends JFrame
implements DrawingEditor,
PaletteListener {
    private Drawing fDrawing;
    private Tool fTool;
    private Iconkit fIconkit;
    private JTextField fStatusLine;
    private StandardDrawingView fView;
    private ToolButton fDefaultToolButton;
    private ToolButton fSelectedToolButton;
    private String fApplicationName;
    private String fDrawingFilename;
    private StorageFormatManager fStorageFormatManager;
    static String fgUntitled = "untitled";
    private static final String fgDrawPath = "/CH/ifa/draw/";
    public static final String IMAGES = "/CH/ifa/draw/images/";
    public static final int FILE_MENU = 0;
    public static final int EDIT_MENU = 1;
    public static final int ALIGNMENT_MENU = 2;
    public static final int ATTRIBUTES_MENU = 3;

    public DrawApplication() {
        super("JHotDraw");
    }

    public DrawApplication(String title) {
        super(title);
        this.setApplicationName(title);
    }

    protected DrawApplication createApplication() {
        return new DrawApplication();
    }

    public void newView() {
        DrawApplication window = this.createApplication();
        window.setDefaultCloseOperation(2);
        window.open();
        window.setDrawing(this.drawing());
        window.setDrawingTitle(this.getDrawingTitle() + " (View)");
    }

    public void newWindow() {
        DrawApplication window = this.createApplication();
        window.open();
    }

    public void open() {
        this.fIconkit = new Iconkit(this);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel fullPanel = new JPanel();
        fullPanel.setLayout(new BoxLayout(fullPanel, 0));
        this.fView = this.createDrawingView();
        JComponent contents = this.createContents((StandardDrawingView)this.view());
        contents.setAlignmentX(0.0f);
        JToolBar tools = this.createToolPalette();
        this.createTools(tools);
        JPanel activePanel = new JPanel();
        activePanel.setAlignmentX(0.0f);
        activePanel.setAlignmentY(0.0f);
        activePanel.setLayout(new BorderLayout());
        activePanel.add((Component)tools, "North");
        activePanel.add((Component)contents, "Center");
        fullPanel.add(activePanel);
        this.fStatusLine = this.createStatusLine();
        this.getContentPane().add((Component)fullPanel, "Center");
        this.getContentPane().add((Component)this.fStatusLine, "South");
        JMenuBar mb = new JMenuBar();
        this.createMenus(mb);
        this.setJMenuBar(mb);
        this.initDrawing();
        Dimension d = this.defaultSize();
        if (d.width > mb.getPreferredSize().width) {
            this.setSize(d.width, d.height);
        } else {
            this.setSize(mb.getPreferredSize().width, d.height);
        }
        this.addListeners();
        this.setVisible(true);
        this.fStorageFormatManager = this.createStorageFormatManager();
    }

    protected void addListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                DrawApplication.this.exit();
            }
        });
    }

    protected void initDrawing() {
        this.setDrawing(this.createDrawing());
        this.setDrawingTitle(fgUntitled);
        this.view().setDrawing(this.drawing());
        this.toolDone();
    }

    protected void createMenus(JMenuBar mb) {
        mb.add(this.createFileMenu());
        mb.add(this.createEditMenu());
        mb.add(this.createAlignmentMenu());
        mb.add(this.createAttributesMenu());
        mb.add(this.createDebugMenu());
    }

    protected JMenu createFileMenu() {
        JMenu menu = new JMenu("File");
        JMenuItem mi = new JMenuItem("New", new MenuShortcut(110).getKey());
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DrawApplication.this.promptNew();
            }
        });
        menu.add(mi);
        mi = new JMenuItem("Open...", new MenuShortcut(111).getKey());
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DrawApplication.this.promptOpen();
            }
        });
        menu.add(mi);
        mi = new JMenuItem("Save As...", new MenuShortcut(115).getKey());
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DrawApplication.this.promptSaveAs();
            }
        });
        menu.add(mi);
        menu.addSeparator();
        mi = new JMenuItem("Print...", new MenuShortcut(112).getKey());
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DrawApplication.this.print();
            }
        });
        menu.add(mi);
        menu.addSeparator();
        mi = new JMenuItem("Exit");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DrawApplication.this.exit();
            }
        });
        menu.add(mi);
        return menu;
    }

    protected JMenu createEditMenu() {
        CommandMenu menu = new CommandMenu("Edit");
        menu.add(new CutCommand("Cut", this.view()), new MenuShortcut(120));
        menu.add(new CopyCommand("Copy", this.view()), new MenuShortcut(99));
        menu.add(new PasteCommand("Paste", this.view()), new MenuShortcut(118));
        menu.addSeparator();
        menu.add(new DuplicateCommand("Duplicate", this.view()), new MenuShortcut(100));
        menu.add(new DeleteCommand("Delete", this.view()));
        menu.addSeparator();
        menu.add(new GroupCommand("Group", this.view()));
        menu.add(new UngroupCommand("Ungroup", this.view()));
        menu.addSeparator();
        menu.add(new SendToBackCommand("Send to Back", this.view()));
        menu.add(new BringToFrontCommand("Bring to Front", this.view()));
        return menu;
    }

    protected JMenu createAlignmentMenu() {
        CommandMenu menu = new CommandMenu("Align");
        menu.add(new ToggleGridCommand("Toggle Snap to Grid", this.view(), new Point(4, 4)));
        menu.addSeparator();
        menu.add(new AlignCommand("Lefts", this.view(), 0));
        menu.add(new AlignCommand("Centers", this.view(), 1));
        menu.add(new AlignCommand("Rights", this.view(), 2));
        menu.addSeparator();
        menu.add(new AlignCommand("Tops", this.view(), 3));
        menu.add(new AlignCommand("Middles", this.view(), 4));
        menu.add(new AlignCommand("Bottoms", this.view(), 5));
        return menu;
    }

    protected JMenu createDebugMenu() {
        JMenu menu = new JMenu("Debug");
        JMenuItem mi = new JMenuItem("Simple Update");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DrawApplication.this.view().setDisplayUpdate(new SimpleUpdateStrategy());
            }
        });
        menu.add(mi);
        mi = new JMenuItem("Buffered Update");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DrawApplication.this.view().setDisplayUpdate(new BufferedUpdateStrategy());
            }
        });
        menu.add(mi);
        return menu;
    }

    protected JMenu createAttributesMenu() {
        JMenu menu = new JMenu("Attributes");
        menu.add(this.createColorMenu("Fill Color", "FillColor"));
        menu.add(this.createColorMenu("Pen Color", "FrameColor"));
        menu.add(this.createArrowMenu());
        menu.addSeparator();
        menu.add(this.createFontMenu());
        menu.add(this.createFontSizeMenu());
        menu.add(this.createFontStyleMenu());
        menu.add(this.createColorMenu("Text Color", "TextColor"));
        return menu;
    }

    protected JMenu createColorMenu(String title, String attribute) {
        CommandMenu menu = new CommandMenu(title);
        for (int i = 0; i < ColorMap.size(); ++i) {
            menu.add(new ChangeAttributeCommand(ColorMap.name(i), attribute, ColorMap.color(i), this.view()));
        }
        return menu;
    }

    protected JMenu createArrowMenu() {
        CommandMenu menu = new CommandMenu("Arrow");
        menu.add(new ChangeAttributeCommand("none", "ArrowMode", new Integer(0), this.view()));
        menu.add(new ChangeAttributeCommand("at Start", "ArrowMode", new Integer(1), this.view()));
        menu.add(new ChangeAttributeCommand("at End", "ArrowMode", new Integer(2), this.view()));
        menu.add(new ChangeAttributeCommand("at Both", "ArrowMode", new Integer(3), this.view()));
        return menu;
    }

    protected JMenu createFontMenu() {
        CommandMenu menu = new CommandMenu("Font");
        String[] fonts = Toolkit.getDefaultToolkit().getFontList();
        for (int i = 0; i < fonts.length; ++i) {
            menu.add(new ChangeAttributeCommand(fonts[i], "FontName", fonts[i], this.view()));
        }
        return menu;
    }

    protected JMenu createFontStyleMenu() {
        CommandMenu menu = new CommandMenu("Font Style");
        menu.add(new ChangeAttributeCommand("Plain", "FontStyle", new Integer(0), this.view()));
        menu.add(new ChangeAttributeCommand("Italic", "FontStyle", new Integer(2), this.view()));
        menu.add(new ChangeAttributeCommand("Bold", "FontStyle", new Integer(1), this.view()));
        return menu;
    }

    protected JMenu createFontSizeMenu() {
        CommandMenu menu = new CommandMenu("Font Size");
        int[] sizes = new int[]{9, 10, 12, 14, 18, 24, 36, 48, 72};
        for (int i = 0; i < sizes.length; ++i) {
            menu.add(new ChangeAttributeCommand(Integer.toString(sizes[i]), "FontSize", new Integer(sizes[i]), this.view()));
        }
        return menu;
    }

    public JMenu createLookAndFeelMenu() {
        JMenu menu = new JMenu("Look'n'Feel");
        UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
        JMenuItem mi = null;
        for (int i = 0; i < lafs.length; ++i) {
            mi = new JMenuItem(lafs[i].getName());
            final String lnfClassName = lafs[i].getClassName();
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DrawApplication.this.newLookAndFeel(lnfClassName);
                }
            });
            menu.add(mi);
        }
        return menu;
    }

    protected JToolBar createToolPalette() {
        JToolBar palette = new JToolBar();
        palette.setBackground(Color.lightGray);
        return palette;
    }

    protected void createTools(JToolBar palette) {
        Tool tool = this.createSelectionTool();
        this.fDefaultToolButton = this.createToolButton("/CH/ifa/draw/images/SEL", "Selection Tool", tool);
        palette.add(this.fDefaultToolButton);
    }

    protected Tool createSelectionTool() {
        return new SelectionTool(this.view());
    }

    protected ToolButton createToolButton(String iconName, String toolName, Tool tool) {
        return new ToolButton(this, iconName, toolName, tool);
    }

    protected StandardDrawingView createDrawingView() {
        Dimension d = this.getDrawingViewSize();
        return new StandardDrawingView(this, d.width, d.height);
    }

    protected Dimension getDrawingViewSize() {
        return new Dimension(800, 800);
    }

    protected Drawing createDrawing() {
        return new StandardDrawing();
    }

    protected JComponent createContents(StandardDrawingView view) {
        JScrollPane sp = new JScrollPane(view);
        sp.setVerticalScrollBarPolicy(22);
        sp.setHorizontalScrollBarPolicy(32);
        return sp;
    }

    public StorageFormatManager createStorageFormatManager() {
        StorageFormatManager storageFormatManager = new StorageFormatManager();
        storageFormatManager.setDefaultStorageFormat(new StandardStorageFormat());
        storageFormatManager.addStorageFormat(storageFormatManager.getDefaultStorageFormat());
        storageFormatManager.addStorageFormat(new SerializationStorageFormat());
        return storageFormatManager;
    }

    private void setStorageFormatManager(StorageFormatManager storageFormatManager) {
        this.fStorageFormatManager = storageFormatManager;
    }

    public StorageFormatManager getStorageFormatManager() {
        return this.fStorageFormatManager;
    }

    public void setDrawing(Drawing drawing) {
        this.view().setDrawing(drawing);
        this.fDrawing = drawing;
    }

    protected Dimension defaultSize() {
        return new Dimension(600, 450);
    }

    protected JTextField createStatusLine() {
        JTextField field = new JTextField("No Tool", 40);
        field.setBackground(Color.white);
        field.setEditable(false);
        return field;
    }

    @Override
    public void paletteUserSelected(PaletteButton button) {
        ToolButton toolButton = (ToolButton)button;
        this.setTool(toolButton.tool(), toolButton.name());
        this.setSelected(toolButton);
    }

    @Override
    public void paletteUserOver(PaletteButton button, boolean inside) {
        ToolButton toolButton = (ToolButton)button;
        if (inside) {
            this.showStatus(toolButton.name());
        } else {
            this.showStatus(this.fSelectedToolButton.name());
        }
    }

    @Override
    public Drawing drawing() {
        return this.fDrawing;
    }

    @Override
    public Tool tool() {
        return this.fTool;
    }

    @Override
    public DrawingView view() {
        return this.fView;
    }

    @Override
    public void toolDone() {
        if (this.fDefaultToolButton != null) {
            this.setTool(this.fDefaultToolButton.tool(), this.fDefaultToolButton.name());
            this.setSelected(this.fDefaultToolButton);
        }
    }

    @Override
    public void selectionChanged(DrawingView view) {
        JMenuBar mb = this.getJMenuBar();
        CommandMenu editMenu = (CommandMenu)mb.getMenu(1);
        editMenu.checkEnabled();
        CommandMenu alignmentMenu = (CommandMenu)mb.getMenu(2);
        alignmentMenu.checkEnabled();
    }

    @Override
    public void showStatus(String string) {
        this.fStatusLine.setText(string);
    }

    private void setTool(Tool t, String name) {
        if (this.tool() != null) {
            this.tool().deactivate();
        }
        this.fTool = t;
        if (this.tool() != null) {
            this.fStatusLine.setText(name);
            this.tool().activate();
        }
    }

    private void setSelected(ToolButton button) {
        if (this.fSelectedToolButton != null) {
            this.fSelectedToolButton.reset();
        }
        this.fSelectedToolButton = button;
        if (this.fSelectedToolButton != null) {
            this.fSelectedToolButton.select();
        }
    }

    public void exit() {
        this.destroy();
        this.setVisible(false);
        this.dispose();
    }

    protected void destroy() {
    }

    public void promptNew() {
        this.initDrawing();
    }

    public void promptOpen() {
        this.toolDone();
        JFileChooser openDialog = this.createOpenFileChooser();
        this.getStorageFormatManager().registerFileFilters(openDialog);
        if (openDialog.showOpenDialog(this) == 0) {
            StorageFormat foundFormat = this.getStorageFormatManager().findStorageFormat(openDialog.getFileFilter());
            if (foundFormat != null) {
                this.loadDrawing(foundFormat, openDialog.getSelectedFile().getAbsolutePath());
            } else {
                this.showStatus("Not a valid file format: " + openDialog.getFileFilter().getDescription());
            }
        }
    }

    public void promptSaveAs() {
        this.toolDone();
        JFileChooser saveDialog = this.createSaveFileChooser();
        this.getStorageFormatManager().registerFileFilters(saveDialog);
        if (saveDialog.showSaveDialog(this) == 0) {
            StorageFormat foundFormat = this.getStorageFormatManager().findStorageFormat(saveDialog.getFileFilter());
            if (foundFormat != null) {
                this.saveDrawing(foundFormat, saveDialog.getSelectedFile().getAbsolutePath());
            } else {
                this.showStatus("Not a valid file format: " + saveDialog.getFileFilter().getDescription());
            }
        }
    }

    protected JFileChooser createOpenFileChooser() {
        JFileChooser openDialog = new JFileChooser();
        openDialog.setDialogTitle("Open File...");
        return openDialog;
    }

    protected JFileChooser createSaveFileChooser() {
        JFileChooser saveDialog = new JFileChooser();
        saveDialog.setDialogTitle("Save File...");
        return saveDialog;
    }

    public void print() {
        this.tool().deactivate();
        PrintJob printJob = this.getToolkit().getPrintJob(this, "Print Drawing", null);
        if (printJob != null) {
            Graphics pg = printJob.getGraphics();
            if (pg != null) {
                ((StandardDrawingView)this.view()).printAll(pg);
                pg.dispose();
            }
            printJob.end();
        }
        this.tool().activate();
    }

    protected void saveDrawing(StorageFormat storeFormat, String file) {
        try {
            this.setDrawingTitle(storeFormat.store(file, this.drawing()));
        }
        catch (IOException e) {
            this.showStatus(e.toString());
        }
    }

    protected void loadDrawing(StorageFormat restoreFormat, String file) {
        try {
            Drawing restoredDrawing = restoreFormat.restore(file);
            if (restoredDrawing != null) {
                this.newWindow();
                this.setDrawing(restoredDrawing);
                this.setDrawingTitle(file);
            } else {
                this.showStatus("Unknown file type: could not open file '" + file + "'");
            }
        }
        catch (IOException e) {
            this.showStatus("Error: " + e);
        }
    }

    private void newLookAndFeel(String landf) {
        try {
            UIManager.setLookAndFeel(landf);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    protected void setDrawingTitle(String drawingTitle) {
        this.fDrawingFilename = drawingTitle;
        if (fgUntitled.equals(drawingTitle)) {
            this.setTitle(this.getApplicationName());
        } else {
            this.setTitle(this.getApplicationName() + " - " + drawingTitle);
        }
    }

    protected String getDrawingTitle() {
        return this.fDrawingFilename;
    }

    public void setApplicationName(String applicationName) {
        this.fApplicationName = applicationName;
    }

    public String getApplicationName() {
        return this.fApplicationName;
    }
}

