/*
 * Decompiled with CFR 0.152.
 */
package jsci.util;

import jsci.maths.Complex;
import jsci.maths.matrices.AbstractComplexMatrix;
import jsci.maths.matrices.AbstractDoubleMatrix;
import jsci.maths.matrices.ComplexDiagonalMatrix;
import jsci.maths.matrices.ComplexSquareMatrix;
import jsci.maths.matrices.ComplexTridiagonalMatrix;
import jsci.maths.matrices.DoubleDiagonalMatrix;
import jsci.maths.matrices.DoubleSquareMatrix;
import jsci.maths.matrices.DoubleTridiagonalMatrix;
import jsci.util.RandomMap;

public final class MatrixToolkit {
    private MatrixToolkit() {
    }

    public static DoubleSquareMatrix randomSquareMatrix(int size) {
        return (DoubleSquareMatrix)new DoubleSquareMatrix(size).mapElements(RandomMap.MAP);
    }

    public static DoubleTridiagonalMatrix randomTridiagonalMatrix(int size) {
        return new DoubleTridiagonalMatrix(MatrixToolkit.toArray(MatrixToolkit.randomSquareMatrix(size)));
    }

    public static DoubleDiagonalMatrix randomDiagonalMatrix(int size) {
        return new DoubleDiagonalMatrix(MatrixToolkit.toArray(MatrixToolkit.randomSquareMatrix(size)));
    }

    public static ComplexSquareMatrix randomComplexSquareMatrix(int size) {
        return (ComplexSquareMatrix)new ComplexSquareMatrix(size).mapElements(RandomMap.MAP);
    }

    public static ComplexTridiagonalMatrix randomComplexTridiagonalMatrix(int size) {
        return new ComplexTridiagonalMatrix(MatrixToolkit.toArray(MatrixToolkit.randomComplexSquareMatrix(size)));
    }

    public static ComplexDiagonalMatrix randomComplexDiagonalMatrix(int size) {
        return new ComplexDiagonalMatrix(MatrixToolkit.toArray(MatrixToolkit.randomComplexSquareMatrix(size)));
    }

    public static double[][] toArray(AbstractDoubleMatrix v) {
        double[][] array = new double[v.rows()][v.columns()];
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[0].length; ++j) {
                array[i][j] = v.getElement(i, j);
            }
        }
        return array;
    }

    public static Complex[][] toArray(AbstractComplexMatrix v) {
        Complex[][] array = new Complex[v.rows()][v.columns()];
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[0].length; ++j) {
                array[i][j] = v.getElement(i, j);
            }
        }
        return array;
    }
}

