/*
 * Decompiled with CFR 0.152.
 */
package jsci.physics.relativity;

import jsci.GlobalSettings;
import jsci.maths.DimensionException;
import jsci.physics.relativity.Rank1Tensor;
import jsci.physics.relativity.Rank4Tensor;
import jsci.physics.relativity.Tensor;

public class Rank3Tensor
extends Tensor {
    protected double[][][] rank3 = new double[4][4][4];

    public boolean equals(Object a) {
        if (a instanceof Rank3Tensor) {
            Rank3Tensor v = (Rank3Tensor)a;
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    if (!(Math.abs(this.rank3[i][j][0] - v.rank3[i][j][0]) > GlobalSettings.ZERO_TOL || Math.abs(this.rank3[i][j][1] - v.rank3[i][j][1]) > GlobalSettings.ZERO_TOL || Math.abs(this.rank3[i][j][2] - v.rank3[i][j][2]) > GlobalSettings.ZERO_TOL) && !(Math.abs(this.rank3[i][j][3] - v.rank3[i][j][3]) > GlobalSettings.ZERO_TOL)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public double getComponent(int i, int j, int k) {
        if (i >= 0 && i < 4 && j >= 0 && j < 4 && k >= 0 && k < 4) {
            return this.rank3[i][j][k];
        }
        throw new DimensionException("Invalid component.");
    }

    public void setComponent(int i, int j, int k, double x) {
        if (i < 0 || i >= 4 || j < 0 || j >= 4 || k < 0 || k >= 4) {
            throw new DimensionException("Invalid component.");
        }
        this.rank3[i][j][k] = x;
    }

    public Rank3Tensor add(Rank3Tensor t) {
        Rank3Tensor ans = new Rank3Tensor();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                ans.setComponent(i, j, 0, this.rank3[i][j][0] + t.rank3[i][j][0]);
                ans.setComponent(i, j, 1, this.rank3[i][j][1] + t.rank3[i][j][1]);
                ans.setComponent(i, j, 2, this.rank3[i][j][2] + t.rank3[i][j][2]);
                ans.setComponent(i, j, 3, this.rank3[i][j][3] + t.rank3[i][j][3]);
            }
        }
        return ans;
    }

    public Rank3Tensor subtract(Rank3Tensor t) {
        Rank3Tensor ans = new Rank3Tensor();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                ans.setComponent(i, j, 0, this.rank3[i][j][0] - t.rank3[i][j][0]);
                ans.setComponent(i, j, 1, this.rank3[i][j][1] - t.rank3[i][j][1]);
                ans.setComponent(i, j, 2, this.rank3[i][j][2] - t.rank3[i][j][2]);
                ans.setComponent(i, j, 3, this.rank3[i][j][3] - t.rank3[i][j][3]);
            }
        }
        return ans;
    }

    public Rank4Tensor tensorProduct(Rank1Tensor t) {
        Rank4Tensor ans = new Rank4Tensor();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    ans.setComponent(i, j, k, 0, this.rank3[i][j][k] * t.getComponent(0));
                    ans.setComponent(i, j, k, 1, this.rank3[i][j][k] * t.getComponent(1));
                    ans.setComponent(i, j, k, 2, this.rank3[i][j][k] * t.getComponent(2));
                    ans.setComponent(i, j, k, 3, this.rank3[i][j][k] * t.getComponent(3));
                }
            }
        }
        return ans;
    }
}

