/*
 * Decompiled with CFR 0.152.
 */
package jsci.physics.quantum;

import jsci.maths.Complex;
import jsci.maths.DimensionException;
import jsci.maths.MaximumIterationsExceededException;
import jsci.maths.Member;
import jsci.maths.matrices.AbstractComplexSquareMatrix;
import jsci.maths.vectors.AbstractComplexVector;
import jsci.maths.vectors.ComplexVector;
import jsci.physics.quantum.KetVector;

public class Operator
implements Member {
    protected AbstractComplexSquareMatrix representation;

    public Operator(AbstractComplexSquareMatrix rep) {
        this.representation = rep;
    }

    public boolean equals(Object a) {
        return this.representation.equals(((Operator)a).representation);
    }

    public String toString() {
        return this.representation.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.trace().mod());
    }

    public AbstractComplexSquareMatrix getRepresentation() {
        return this.representation;
    }

    public boolean isSelfAdjoint() {
        return this.representation.isHermitian();
    }

    public boolean isUnitary() {
        return this.representation.isUnitary();
    }

    public Complex trace() {
        return this.representation.trace();
    }

    public double norm() {
        try {
            return this.representation.operatorNorm();
        }
        catch (MaximumIterationsExceededException e) {
            return -1.0;
        }
    }

    public int dimension() {
        return this.representation.columns();
    }

    @Override
    public Object getSet() {
        return this.representation.getSet();
    }

    public Operator add(Operator op) {
        return new Operator(this.representation.add(op.representation));
    }

    public Operator subtract(Operator op) {
        return new Operator(this.representation.subtract(op.representation));
    }

    public Operator multiply(Operator op) {
        return new Operator(this.representation.multiply(op.representation));
    }

    public KetVector multiply(KetVector ket) {
        int opDim = this.dimension();
        if (opDim == ket.dimension()) {
            AbstractComplexVector ketRep = ket.getRepresentation();
            Complex[] array = new Complex[opDim];
            for (int i = 0; i < opDim; ++i) {
                Complex tmp = this.representation.getElement(i, 0).multiply(ketRep.getComponent(0));
                for (int j = 1; j < opDim; ++j) {
                    tmp = tmp.add(this.representation.getElement(i, j).multiply(ketRep.getComponent(j)));
                }
                array[i] = tmp;
            }
            return new KetVector(new ComplexVector(array));
        }
        throw new DimensionException("Operator and vector have different dimensions.");
    }
}

