/*
 * Decompiled with CFR 0.152.
 */
package jsci.physics.particles;

import jsci.physics.particles.AntiLepton;
import jsci.physics.particles.AntiMuon;
import jsci.physics.particles.MuonNeutrino;
import jsci.physics.particles.WMinus;
import jsci.physics.particles.WPlus;
import jsci.physics.particles.ZZero;
import jsci.physics.quantum.QuantumParticle;

public final class AntiMuonNeutrino
extends AntiLepton {
    @Override
    public double restMass() {
        return 0.0;
    }

    @Override
    public int charge() {
        return 0;
    }

    @Override
    public int eLeptonQN() {
        return 0;
    }

    @Override
    public int muLeptonQN() {
        return -1;
    }

    @Override
    public int tauLeptonQN() {
        return 0;
    }

    @Override
    public QuantumParticle anti() {
        return new MuonNeutrino();
    }

    @Override
    public boolean isAnti(QuantumParticle qp) {
        return qp != null && qp instanceof MuonNeutrino;
    }

    public String toString() {
        return new String("Antimuon neutrino");
    }

    public AntiMuon emit(WMinus w) {
        AntiMuon e = new AntiMuon();
        e.momentum = this.momentum.subtract(w.momentum);
        return e;
    }

    public AntiMuon absorb(WPlus w) {
        AntiMuon e = new AntiMuon();
        e.momentum = this.momentum.add(w.momentum);
        return e;
    }

    public AntiMuonNeutrino emit(ZZero z) {
        this.momentum = this.momentum.subtract(z.momentum);
        return this;
    }

    public AntiMuonNeutrino absorb(ZZero z) {
        this.momentum = this.momentum.add(z.momentum);
        return this;
    }
}

