/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.wavelet.daubechies3;

import jsci.maths.ArrayMath;
import jsci.maths.NumericalConstants;
import jsci.maths.WaveletMath;
import jsci.maths.wavelet.Cascades;
import jsci.maths.wavelet.Filter;
import jsci.maths.wavelet.IllegalScalingException;
import jsci.maths.wavelet.Multiresolution;
import jsci.maths.wavelet.MultiscaleFunction;
import jsci.maths.wavelet.daubechies3.Scaling3;
import jsci.maths.wavelet.daubechies3.Wavelet3;

public final class Daubechies3
extends Multiresolution
implements Filter,
NumericalConstants {
    protected static final int filtretype = 4;
    protected static final int minlength = 8;
    static final double[] vgtemp = new double[]{0.33267055295, 0.806891509311, 0.459877502118, -0.13501102001, -0.085441273882, 0.035226291882};
    static final double[] v0temp = new double[]{0.689047760315, 0.724715933318};
    static final double[] v1temp = new double[]{0.0306457241755, -0.0291374408035, -0.986047279405, 0.161005005859};
    static final double[] v2temp = new double[]{0.0172802631418, -0.0164297845102, 0.00443452721664, 0.0208960300827, -0.924034270866, 0.380966943247};
    static final double[] v3temp = new double[]{0.027026368393, -0.0256962180001, 0.0639688879804, 0.381971870809, 0.176750229211, 0.404677356783, -0.747429432607, 0.308155135811};
    static final double[] vd0temp = new double[]{0.889500699418, 0.456933808921};
    static final double[] vd1temp = new double[]{-0.198411021088, 0.386241373662, 0.832668382346, 0.343677222149};
    static final double[] vd2temp = new double[]{0.0390630495665, -0.0760429831027, -0.143921176769, 0.456707890812, 0.807766275151, 0.33303120718};
    static final double[] vd3temp = new double[]{-2.76799784313E-4, 5.38838660959E-4, 0.0349752642807, -0.085504178774, -0.134969198046, 0.459895243878, 0.806892290508, 0.332670875027};
    static final double[] vg = ArrayMath.scalarMultiply(1.4142135623730951, vgtemp);
    static final double[] vd0 = ArrayMath.scalarMultiply(1.4142135623730951, ArrayMath.invert(vd0temp));
    static final double[] vd1 = ArrayMath.scalarMultiply(1.4142135623730951, ArrayMath.invert(vd1temp));
    static final double[] vd2 = ArrayMath.scalarMultiply(1.4142135623730951, ArrayMath.invert(vd2temp));
    static final double[] vd3 = ArrayMath.scalarMultiply(1.4142135623730951, ArrayMath.invert(vd3temp));
    static final double[] v0 = ArrayMath.scalarMultiply(1.4142135623730951, v0temp);
    static final double[] v1 = ArrayMath.scalarMultiply(1.4142135623730951, v1temp);
    static final double[] v2 = ArrayMath.scalarMultiply(1.4142135623730951, v2temp);
    static final double[] v3 = ArrayMath.scalarMultiply(1.4142135623730951, v3temp);
    static final double[] phvg = WaveletMath.lowToHigh(vgtemp);
    static final double[] phv0 = new double[]{0.720522830617, -0.685061028561, 0.0259917491699, -0.101939535681, 0.0200641216304, -0.00827216838973};
    static final double[] phv1 = new double[]{0.0639675079235, -0.0608192341872, 0.151405112504, 0.904072212264, -0.0510574707719, -0.18071490589, 0.315790060572, -0.130196008824};
    static final double[] phvd0temp = new double[]{-0.409742284317, 0.797634233593, -0.419058128916, -0.117669342504, 0.0741631890253, 0.0305764886814};
    static final double[] phvd0 = ArrayMath.invert(phvd0temp);
    static final double[] phvd1temp = new double[]{-0.00261427398522, 0.00508913652903, 0.330328738376, -0.807556085169, 0.460310974517, 0.13519444871, -0.0854338960798, -0.0352232501168};
    static final double[] phvd1 = ArrayMath.invert(phvd1temp);

    @Override
    public int getFilterType() {
        return 4;
    }

    @Override
    public MultiscaleFunction primaryScaling(int n0, int k) {
        return new Scaling3(n0, k);
    }

    @Override
    public MultiscaleFunction dualScaling(int n0, int k) {
        return new Scaling3(n0, k);
    }

    @Override
    public MultiscaleFunction primaryWavelet(int n0, int k) {
        return new Wavelet3(n0, k);
    }

    @Override
    public MultiscaleFunction dualWavelet(int n0, int k) {
        return new Wavelet3(n0, k);
    }

    @Override
    public int previousDimension(int k) {
        return Cascades.previousDimension(4, k);
    }

    @Override
    public double[] lowpass(double[] v, double[] param) {
        return this.lowpass(v);
    }

    @Override
    public double[] highpass(double[] v, double[] param) {
        return this.highpass(v);
    }

    @Override
    public double[] lowpass(double[] gete) {
        if (gete.length < 8) {
            throw new IllegalScalingException("The array is not long enough : " + gete.length + " < " + 8);
        }
        double[] sortie = new double[2 * gete.length - 4];
        int dl0 = gete.length - 1;
        for (int k = 4; k <= dl0 - 4; ++k) {
            for (int L = -3; L < 3; ++L) {
                int n = 2 * k + L - 1;
                sortie[n] = sortie[n] + vg[L + 3] * gete[k];
            }
        }
        sortie = ArrayMath.add(sortie, gete[0], v0, 0);
        sortie = ArrayMath.add(sortie, gete[1], v1, 0);
        sortie = ArrayMath.add(sortie, gete[2], v2, 0);
        sortie = ArrayMath.add(sortie, gete[3], v3, 0);
        int p0 = sortie.length - vd0.length;
        int p1 = sortie.length - vd1.length;
        int p2 = sortie.length - vd2.length;
        int p3 = sortie.length - vd3.length;
        sortie = ArrayMath.add(sortie, gete[dl0], vd0, p0);
        sortie = ArrayMath.add(sortie, gete[dl0 - 1], vd1, p1);
        sortie = ArrayMath.add(sortie, gete[dl0 - 2], vd2, p2);
        sortie = ArrayMath.add(sortie, gete[dl0 - 3], vd3, p3);
        return sortie;
    }

    @Override
    public double[] highpass(double[] gete) {
        double[] sortie = new double[2 * gete.length + 4];
        int dl0 = gete.length - 1;
        for (int k = 2; k <= dl0 - 2; ++k) {
            for (int L = -3; L < 3; ++L) {
                int n = 2 * k + L + 3;
                sortie[n] = sortie[n] + phvg[L + 3] * gete[k];
            }
        }
        sortie = ArrayMath.add(sortie, gete[0], phv0, 0);
        int p0 = sortie.length - phvd0.length;
        sortie = ArrayMath.add(sortie, gete[dl0], phvd0, p0);
        sortie = ArrayMath.add(sortie, gete[1], phv1, 0);
        int p1 = sortie.length - phvd1.length;
        sortie = ArrayMath.add(sortie, gete[dl0 - 1], phvd1, p1);
        return sortie;
    }

    public double[] evalScaling(int n0, int k, int j1) {
        return Cascades.evalScaling(this, n0, j1, k);
    }

    public double[] evalWavelet(int n0, int k, int j1) {
        return Cascades.evalWavelet(this, 4, n0, j1, k);
    }
}

