/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.wavelet.cdf3_5;

import jsci.maths.ArrayMath;
import jsci.maths.wavelet.Cascades;
import jsci.maths.wavelet.Filter;
import jsci.maths.wavelet.IllegalScalingException;
import jsci.maths.wavelet.Multiresolution;
import jsci.maths.wavelet.MultiscaleFunction;
import jsci.maths.wavelet.cdf3_5.DualScaling3_5;
import jsci.maths.wavelet.cdf3_5.DualWavelet3_5;
import jsci.maths.wavelet.cdf3_5.MultiSpline3_5;

public final class CDF3_5
extends Multiresolution
implements Filter {
    protected static final int filtretype = 2;
    protected static final int minlength = 12;
    static final double[] v0 = new double[]{1.6998046875, 2.9005859375, -2.928515625, -1.616015625, 1.837109375, 2.265234375, -3.2373046875, 1.0791015625};
    static final double[] v1 = new double[]{-0.1919921875, 0.5759765625, 1.944140625, 0.631640625, -0.946484375, -0.999609375, 1.4794921875, -0.4931640625};
    static final double[] v2 = new double[]{0.05658203125, -0.16974609375, -0.1508984375, 0.9053515625, 1.5183723958333333, 0.8797265625, -1.53955078125, 0.4611002604166667, 0.05859375, -0.01953125};
    static final double[] v3 = new double[]{-0.01541015625, 0.04623046875, 0.0207421875, -0.1855078125, -0.0339453125, 0.6376171875, 2.16259765625, -0.36669921875, -0.37890625, 0.07421875, 0.05859375, -0.01953125};
    static final double[] v4 = new double[]{0.0021875, -0.0065625, -0.001875, 0.023125, -0.001875, -0.061875, -0.4296875, 1.4765625, 1.3671875, -0.1015625, -0.37890625, 0.07421875, 0.05859375, -0.01953125};
    static final double[] v5 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1328125, -0.3984375, -0.1015625, 1.3671875, 1.3671875, -0.1015625, -0.37890625, 0.07421875, 0.05859375, -0.01953125};
    static final double[] vg = new double[]{-0.01953125, 0.05859375, 0.07421875, -0.37890625, -0.1015625, 1.3671875, 1.3671875, -0.1015625, -0.37890625, 0.07421875, 0.05859375, -0.01953125};
    static final double[] vd0 = ArrayMath.invert(v0);
    static final double[] vd1 = ArrayMath.invert(v1);
    static final double[] vd2 = ArrayMath.invert(v2);
    static final double[] vd3 = ArrayMath.invert(v3);
    static final double[] vd4 = ArrayMath.invert(v4);
    static final double[] vd5 = ArrayMath.invert(v5);
    static final double[] phvg = new double[]{-0.5, 1.5, -1.5, 0.5};

    @Override
    public int getFilterType() {
        return 2;
    }

    @Override
    public MultiscaleFunction primaryScaling(int n0, int k) {
        return MultiSpline3_5.scaling(n0, k);
    }

    @Override
    public MultiscaleFunction dualScaling(int n0, int k) {
        return new DualScaling3_5(n0, k);
    }

    @Override
    public MultiscaleFunction primaryWavelet(int n0, int k) {
        return MultiSpline3_5.wavelet(n0, k);
    }

    @Override
    public MultiscaleFunction dualWavelet(int n0, int k) {
        return new DualWavelet3_5(n0, k);
    }

    @Override
    public int previousDimension(int k) {
        return Cascades.previousDimension(2, k);
    }

    @Override
    public double[] lowpass(double[] v, double[] param) {
        return this.lowpass(v);
    }

    @Override
    public double[] highpass(double[] v, double[] param) {
        return this.highpass(v);
    }

    @Override
    public double[] lowpass(double[] gete) {
        if (gete.length < 12) {
            throw new IllegalScalingException("The array is not long enough : " + gete.length + " < 12");
        }
        double[] sortie = new double[2 * gete.length - 2];
        int dl0 = gete.length - 1;
        for (int k = 6; k <= dl0 - 6; ++k) {
            for (int L = -6; L <= 5; ++L) {
                int n = 2 * k + L;
                sortie[n] = sortie[n] + vg[L + 6] * gete[k];
            }
        }
        sortie = ArrayMath.add(sortie, gete[0], v0, 0);
        sortie = ArrayMath.add(sortie, gete[1], v1, 0);
        sortie = ArrayMath.add(sortie, gete[2], v2, 0);
        sortie = ArrayMath.add(sortie, gete[3], v3, 0);
        sortie = ArrayMath.add(sortie, gete[4], v4, 0);
        sortie = ArrayMath.add(sortie, gete[5], v5, 0);
        int p0 = sortie.length - vd0.length;
        int p1 = sortie.length - vd1.length;
        int p2 = sortie.length - vd2.length;
        int p3 = sortie.length - vd3.length;
        int p4 = sortie.length - vd4.length;
        int p5 = sortie.length - vd5.length;
        sortie = ArrayMath.add(sortie, gete[dl0], vd0, p0);
        sortie = ArrayMath.add(sortie, gete[dl0 - 1], vd1, p1);
        sortie = ArrayMath.add(sortie, gete[dl0 - 2], vd2, p2);
        sortie = ArrayMath.add(sortie, gete[dl0 - 3], vd3, p3);
        sortie = ArrayMath.add(sortie, gete[dl0 - 4], vd4, p4);
        sortie = ArrayMath.add(sortie, gete[dl0 - 5], vd5, p5);
        return sortie;
    }

    @Override
    public double[] highpass(double[] v) {
        if (v.length < 4) {
            throw new IllegalScalingException("The array is not long enough : " + v.length + " < 4");
        }
        double[] ans = new double[2 * v.length + 2];
        for (int k = 0; k < v.length; ++k) {
            int n = 2 * k;
            ans[n] = ans[n] + v[k] * phvg[0];
            int n2 = 2 * k + 1;
            ans[n2] = ans[n2] + v[k] * phvg[1];
            int n3 = 2 * k + 2;
            ans[n3] = ans[n3] + v[k] * phvg[2];
            int n4 = 2 * k + 3;
            ans[n4] = ans[n4] + v[k] * phvg[3];
        }
        return ans;
    }

    public double[] evalScaling(int n0, int k, int j1) {
        return Cascades.evalScaling(this, n0, j1, k);
    }

    public double[] evalWavelet(int n0, int k, int j1) {
        return Cascades.evalWaveletQuadratic(this, n0, j1, k);
    }
}

