/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.wavelet;

import jsci.maths.vectors.AbstractDoubleVector;
import jsci.maths.vectors.DoubleVector;
import jsci.maths.wavelet.MultiscaleFunction;
import jsci.util.VectorToolkit;

public class DiscreteFunction
extends MultiscaleFunction
implements Cloneable {
    protected AbstractDoubleVector data;

    public DiscreteFunction(double[] v) {
        this.setData(v);
    }

    public void setData(double[] v) {
        this.data = new DoubleVector(v);
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    public final void normalize() {
        this.data = this.data.normalize();
    }

    public final double[] evaluate() {
        return VectorToolkit.toArray(this.data);
    }

    @Override
    public final boolean equals(Object a) {
        if (a != null && a instanceof DiscreteFunction) {
            DiscreteFunction iv = (DiscreteFunction)a;
            return this.data.equals(iv.data);
        }
        return false;
    }

    @Override
    public double[] evaluate(int j) {
        return this.evaluate();
    }

    @Override
    public double mass(double a, double b, int jfin) {
        return this.data.mass() / (double)(this.data.dimension() - 1) * Math.abs(b - a);
    }

    public final double norm() {
        return this.data.norm();
    }

    public double norm(int j) {
        return this.data.norm();
    }

    @Override
    public Object clone() {
        DiscreteFunction df = (DiscreteFunction)super.clone();
        df.setData(VectorToolkit.toArray(this.data));
        return df;
    }

    @Override
    public int dimension(int jfin) {
        return this.data.dimension();
    }

    @Override
    public final int dimension() {
        return this.data.dimension();
    }

    @Override
    public int getFilterType() {
        return this.data.dimension();
    }
}

