/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.vectors;

import jsci.maths.Complex;
import jsci.maths.ComplexMapping;
import jsci.maths.MathDouble;
import jsci.maths.MathInteger;
import jsci.maths.algebras.HilbertSpace;
import jsci.maths.algebras.Module;
import jsci.maths.algebras.VectorSpace;
import jsci.maths.fields.Field;
import jsci.maths.fields.Ring;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.vectors.AbstractComplexVector;
import jsci.maths.vectors.AbstractDoubleVector;
import jsci.maths.vectors.AbstractIntegerVector;
import jsci.maths.vectors.Double2Vector;
import jsci.maths.vectors.VectorDimensionException;

public final class Complex2Vector
extends AbstractComplexVector {
    protected double xre;
    protected double xim;
    protected double yre;
    protected double yim;

    public Complex2Vector() {
        super(2);
    }

    public Complex2Vector(Complex x, Complex y) {
        this();
        this.xre = x.real();
        this.xim = x.imag();
        this.yre = y.real();
        this.yim = y.imag();
    }

    public Complex2Vector(double xRe, double xIm, double yRe, double yIm) {
        this();
        this.xre = xRe;
        this.xim = xIm;
        this.yre = yRe;
        this.yim = yIm;
    }

    @Override
    public boolean equals(Object obj, double tol) {
        if (obj != null && obj instanceof Complex2Vector) {
            Complex2Vector vec = (Complex2Vector)obj;
            double dxRe = this.xre - vec.xre;
            double dxIm = this.xim - vec.xim;
            double dyRe = this.yre - vec.yre;
            double dyIm = this.yim - vec.yim;
            return dxRe * dxRe + dxIm * dxIm + dyRe * dyRe + dyIm * dyIm <= tol * tol;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(15);
        buf.append(Complex.toString(this.xre, this.xim)).append(',').append(Complex.toString(this.yre, this.yim));
        return buf.toString();
    }

    @Override
    public AbstractDoubleVector real() {
        return new Double2Vector(this.xre, this.yre);
    }

    @Override
    public AbstractDoubleVector imag() {
        return new Double2Vector(this.xim, this.yim);
    }

    @Override
    public Complex getComponent(int n) {
        switch (n) {
            case 0: {
                return new Complex(this.xre, this.xim);
            }
            case 1: {
                return new Complex(this.yre, this.yim);
            }
        }
        throw new VectorDimensionException("Invalid component.");
    }

    @Override
    public double getRealComponent(int n) {
        switch (n) {
            case 0: {
                return this.xre;
            }
            case 1: {
                return this.yre;
            }
        }
        throw new VectorDimensionException("Invalid component.");
    }

    @Override
    public double getImagComponent(int n) {
        switch (n) {
            case 0: {
                return this.xim;
            }
            case 1: {
                return this.yim;
            }
        }
        throw new VectorDimensionException("Invalid component.");
    }

    @Override
    public void setComponent(int n, Complex z) {
        switch (n) {
            case 0: {
                this.xre = z.real();
                this.xim = z.imag();
                break;
            }
            case 1: {
                this.yre = z.real();
                this.yim = z.imag();
                break;
            }
            default: {
                throw new VectorDimensionException("Invalid component.");
            }
        }
    }

    @Override
    public void setComponent(int n, double x, double y) {
        switch (n) {
            case 0: {
                this.xre = x;
                this.xim = y;
                break;
            }
            case 1: {
                this.yre = x;
                this.yim = y;
                break;
            }
            default: {
                throw new VectorDimensionException("Invalid component.");
            }
        }
    }

    @Override
    public double norm() {
        return Math.sqrt(this.xre * this.xre + this.xim * this.xim + this.yre * this.yre + this.yim * this.yim);
    }

    @Override
    public double infNorm() {
        double modSq = this.xre * this.xre + this.xim * this.xim;
        double infNormSq = 0.0;
        if (modSq > infNormSq) {
            infNormSq = modSq;
        }
        if ((modSq = this.yre * this.yre + this.yim * this.yim) > infNormSq) {
            infNormSq = modSq;
        }
        return Math.sqrt(infNormSq);
    }

    @Override
    public AbelianGroup.Member negate() {
        return new Complex2Vector(-this.xre, -this.xim, -this.yre, -this.yim);
    }

    @Override
    public AbstractComplexVector conjugate() {
        return new Complex2Vector(this.xre, -this.xim, this.yre, -this.yim);
    }

    @Override
    public AbelianGroup.Member add(AbelianGroup.Member vec) {
        if (vec instanceof AbstractComplexVector) {
            return this.add((AbstractComplexVector)vec);
        }
        if (vec instanceof AbstractDoubleVector) {
            return this.add((AbstractDoubleVector)vec);
        }
        if (vec instanceof AbstractIntegerVector) {
            return this.add((AbstractIntegerVector)vec);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbstractComplexVector add(AbstractComplexVector vec) {
        if (vec.N == 2) {
            return new Complex2Vector(this.xre + vec.getComponent(0).real(), this.xim + vec.getComponent(0).imag(), this.yre + vec.getComponent(1).real(), this.yim + vec.getComponent(1).imag());
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbstractComplexVector add(AbstractDoubleVector vec) {
        if (vec.N == 2) {
            return new Complex2Vector(this.xre + vec.getComponent(0), this.xim, this.yre + vec.getComponent(1), this.yim);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbstractComplexVector add(AbstractIntegerVector vec) {
        if (vec.N == 2) {
            return new Complex2Vector(this.xre + (double)vec.getComponent(0), this.xim, this.yre + (double)vec.getComponent(1), this.yim);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    @Override
    public AbelianGroup.Member subtract(AbelianGroup.Member vec) {
        if (vec instanceof AbstractComplexVector) {
            return this.subtract((AbstractComplexVector)vec);
        }
        if (vec instanceof AbstractDoubleVector) {
            return this.subtract((AbstractDoubleVector)vec);
        }
        if (vec instanceof AbstractIntegerVector) {
            return this.subtract((AbstractIntegerVector)vec);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbstractComplexVector subtract(AbstractComplexVector vec) {
        if (vec.N == 2) {
            return new Complex2Vector(this.xre - vec.getComponent(0).real(), this.xim - vec.getComponent(0).imag(), this.yre - vec.getComponent(1).real(), this.yim - vec.getComponent(1).imag());
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbstractComplexVector subtract(AbstractDoubleVector vec) {
        if (vec.N == 2) {
            return new Complex2Vector(this.xre - vec.getComponent(0), this.xim, this.yre - vec.getComponent(1), this.yim);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbstractComplexVector subtract(AbstractIntegerVector vec) {
        if (vec.N == 2) {
            return new Complex2Vector(this.xre - (double)vec.getComponent(0), this.xim, this.yre - (double)vec.getComponent(1), this.yim);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    @Override
    public Module.Member scalarMultiply(Ring.Member x) {
        if (x instanceof Complex) {
            return this.scalarMultiply((Complex)x);
        }
        if (x instanceof MathDouble) {
            return this.scalarMultiply(((MathDouble)x).value());
        }
        if (x instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)x).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbstractComplexVector scalarMultiply(Complex z) {
        double real = z.real();
        double imag = z.imag();
        return new Complex2Vector(this.xre * real - this.xim * imag, this.xre * imag + this.xim * real, this.yre * real - this.yim * imag, this.yre * imag + this.yim * real);
    }

    @Override
    public AbstractComplexVector scalarMultiply(double k) {
        return new Complex2Vector(k * this.xre, k * this.xim, k * this.yre, k * this.yim);
    }

    @Override
    public VectorSpace.Member scalarDivide(Field.Member x) {
        if (x instanceof Complex) {
            return this.scalarDivide((Complex)x);
        }
        if (x instanceof MathDouble) {
            return this.scalarDivide(((MathDouble)x).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbstractComplexVector scalarDivide(Complex z) {
        double real = z.real();
        double imag = z.imag();
        if (Math.abs(real) < Math.abs(imag)) {
            double a = real / imag;
            double denom = real * a + imag;
            return new Complex2Vector((this.xre * a + this.xim) / denom, (this.xim * a - this.xre) / denom, (this.yre * a + this.yim) / denom, (this.yim * a - this.yre) / denom);
        }
        double a = imag / real;
        double denom = real + imag * a;
        return new Complex2Vector((this.xre + this.xim * a) / denom, (this.xim - this.xre * a) / denom, (this.yre + this.yim * a) / denom, (this.yim - this.yre * a) / denom);
    }

    @Override
    public AbstractComplexVector scalarDivide(double k) {
        return new Complex2Vector(this.xre / k, this.xim / k, this.yre / k, this.yim / k);
    }

    @Override
    public Complex scalarProduct(HilbertSpace.Member vec) {
        if (vec instanceof AbstractComplexVector) {
            return this.scalarProduct((AbstractComplexVector)vec);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public Complex scalarProduct(AbstractComplexVector vec) {
        if (vec instanceof Complex2Vector) {
            return this.scalarProduct((Complex2Vector)vec);
        }
        if (vec.N == 2) {
            return new Complex(this.xre * vec.getComponent(0).real() + this.xim * vec.getComponent(0).imag() + this.yre * vec.getComponent(1).real() + this.yim * vec.getComponent(1).imag(), this.xim * vec.getComponent(0).real() - this.xre * vec.getComponent(0).imag() + this.yim * vec.getComponent(1).real() - this.yre * vec.getComponent(1).imag());
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public Complex scalarProduct(Complex2Vector vec) {
        return new Complex(this.xre * vec.xre + this.xim * vec.xim + this.yre * vec.yre + this.yim * vec.yim, this.xim * vec.xre - this.xre * vec.xim + this.yim * vec.yre - this.yre * vec.yim);
    }

    @Override
    public AbstractComplexVector mapComponents(ComplexMapping mapping) {
        return new Complex2Vector(mapping.map(this.xre, this.xim), mapping.map(this.yre, this.yim));
    }
}

