/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.symbolic;

import jsci.maths.MathDouble;
import jsci.maths.fields.Field;
import jsci.maths.fields.Ring;
import jsci.maths.symbolic.Constant;
import jsci.maths.symbolic.Expression;
import jsci.maths.symbolic.Product;
import jsci.maths.symbolic.Variable;

class Power
extends Expression {
    private final Expression base;
    private final int exponent;

    public Power(Expression b, int e) {
        this.base = b;
        this.exponent = e;
    }

    public Expression getBase() {
        return this.base;
    }

    public int getExponent() {
        return this.exponent;
    }

    public String toString() {
        String r = "";
        r = this.base.getPriority() < this.getPriority() ? r + "(" + this.base + ")" : r + "" + this.base;
        r = r + "^";
        int ep = this.exponent >= 0 ? 20 : 0;
        r = ep < this.getPriority() ? r + "(" + this.exponent + ")" : r + "" + this.exponent;
        return r;
    }

    @Override
    public Expression differentiate(Variable x) {
        return new Product(new Expression[]{new Constant(new MathDouble(this.exponent)), new Power(this.base, this.exponent - 1), this.base.differentiate(x)});
    }

    @Override
    public Expression evaluate() {
        Expression b = this.base.evaluate();
        if (b instanceof Constant) {
            Field.Member p = (Field.Member)((Ring)((Constant)b).getValue().getSet()).one();
            if (this.exponent >= 0) {
                Ring.Member c = (Ring.Member)((Constant)b).getValue();
                for (int j = 0; j < this.exponent; ++j) {
                    p = (Field.Member)p.multiply((Field.Member)c);
                }
            } else {
                Field.Member c = (Field.Member)((Constant)b).getValue();
                c = c.inverse();
                for (int j = 0; j < -this.exponent; ++j) {
                    p = (Field.Member)p.multiply(c);
                }
            }
            return new Constant(p);
        }
        if (this.exponent == 0) {
            return new Constant(((Ring)this.base.getSet()).one());
        }
        if (this.exponent == 1) {
            return this.base;
        }
        return new Power(b, this.exponent);
    }

    @Override
    protected int getPriority() {
        return 15;
    }

    @Override
    public Object getSet() {
        return this.base.getSet();
    }
}

