/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.polynomials;

import jsci.GlobalSettings;
import jsci.maths.MathDouble;
import jsci.maths.analysis.RealFunction;
import jsci.maths.fields.Field;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.polynomials.Polynomial;
import jsci.maths.polynomials.PolynomialMath;
import jsci.maths.polynomials.RealPolynomialRing;

public class RealPolynomial
extends RealFunction
implements Polynomial {
    private double[] _coeff;

    public RealPolynomial(double[] coeff) {
        if (coeff == null) {
            throw new NullPointerException("Coefficients cannot be null");
        }
        this._coeff = RealPolynomial.normalise(coeff);
    }

    private static double[] normalise(double[] c) {
        int i;
        for (i = c.length - 1; i >= 0 && Math.abs(c[i]) <= GlobalSettings.ZERO_TOL; --i) {
        }
        if (i < 0) {
            return new double[]{0.0};
        }
        if (i < c.length - 1) {
            double[] arr = new double[i + 1];
            System.arraycopy(c, 0, arr, 0, arr.length);
            return arr;
        }
        return c;
    }

    public RealPolynomial(Field.Member[] f) {
        if (f == null) {
            throw new NullPointerException("Coefficients cannot be null");
        }
        this._coeff = RealPolynomial.normalise(RealPolynomial.toDoubleArray(f));
    }

    private static double[] toDoubleArray(Field.Member[] f) {
        double[] arr = new double[f.length];
        for (int i = 0; i < arr.length; ++i) {
            if (!(f[i] instanceof MathDouble)) {
                throw new IllegalArgumentException("Different fields. Argument was " + f[i].getClass());
            }
            arr[i] = ((MathDouble)f[i]).value();
        }
        return arr;
    }

    @Override
    public Field.Member getCoefficient(int k) {
        return new MathDouble(this.getCoefficientAsDouble(k));
    }

    public double getCoefficientAsDouble(int k) {
        if (k >= this._coeff.length) {
            return 0.0;
        }
        return this._coeff[k];
    }

    @Override
    public Field.Member[] getCoefficients() {
        return RealPolynomialRing.toMathDouble(this.getCoefficientsAsDoubles());
    }

    public double[] getCoefficientsAsDoubles() {
        return this._coeff;
    }

    @Override
    public double map(double x) {
        return PolynomialMath.evalPolynomial(this, x);
    }

    @Override
    public int degree() {
        return this._coeff.length - 1;
    }

    @Override
    public Object getSet() {
        return RealPolynomialRing.getInstance();
    }

    public boolean isZero() {
        for (int k = 0; k < this._coeff.length; ++k) {
            if (!(Math.abs(this._coeff[k]) > GlobalSettings.ZERO_TOL)) continue;
            return false;
        }
        return true;
    }

    public boolean isOne() {
        if (Math.abs(this._coeff[0] - 1.0) > GlobalSettings.ZERO_TOL) {
            return false;
        }
        for (int k = 1; k < this._coeff.length; ++k) {
            if (!(Math.abs(this._coeff[k]) > GlobalSettings.ZERO_TOL)) continue;
            return false;
        }
        return true;
    }

    @Override
    public RealFunction add(RealFunction g) {
        if (g instanceof RealPolynomial) {
            RealPolynomial p = (RealPolynomial)g;
            int maxgrade = PolynomialMath.maxDegree(this, p);
            double[] c = new double[maxgrade + 1];
            for (int k = 0; k < c.length; ++k) {
                c[k] = this.getCoefficientAsDouble(k) + p.getCoefficientAsDouble(k);
            }
            return new RealPolynomial(c);
        }
        return super.add(g);
    }

    @Override
    public RealFunction differentiate() {
        if (this.degree() == 0) {
            return (RealPolynomial)RealPolynomialRing.getInstance().zero();
        }
        double[] dn = new double[this.degree()];
        for (int k = 0; k < dn.length; ++k) {
            dn[k] = this.getCoefficientAsDouble(k + 1) * (double)(k + 1);
        }
        return new RealPolynomial(dn);
    }

    @Override
    public Polynomial scalarDivide(Field.Member f) {
        if (f instanceof Number) {
            double a = ((Number)((Object)f)).doubleValue();
            return this.scalarDivide(a);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RealPolynomial scalarDivide(double a) {
        double[] c = new double[this._coeff.length];
        for (int k = 0; k < c.length; ++k) {
            c[k] = this._coeff[k] / a;
        }
        return new RealPolynomial(c);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RealPolynomial) {
            RealPolynomial p = (RealPolynomial)o;
            return ((RealPolynomial)this.subtract(p)).isZero();
        }
        return false;
    }

    public int hashCode() {
        int res = 0;
        for (int k = 0; k < this._coeff.length; ++k) {
            res += (int)(this._coeff[k] * 10.0);
        }
        return res;
    }

    public RealPolynomial integrate() {
        double[] dn = new double[this._coeff.length + 1];
        for (int k = 1; k < dn.length; ++k) {
            dn[k] = this.getCoefficientAsDouble(k - 1) / (double)k;
        }
        return new RealPolynomial(dn);
    }

    @Override
    public Polynomial scalarMultiply(Field.Member f) {
        if (f instanceof Number) {
            double a = ((Number)((Object)f)).doubleValue();
            return this.scalarMultiply(a);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RealPolynomial scalarMultiply(double a) {
        double[] c = new double[this._coeff.length];
        for (int k = 0; k < c.length; ++k) {
            c[k] = this._coeff[k] * a;
        }
        return new RealPolynomial(c);
    }

    @Override
    public RealFunction multiply(RealFunction r) {
        if (r instanceof RealPolynomial) {
            RealPolynomial p = (RealPolynomial)r;
            int maxgrade = PolynomialMath.maxDegree(this, p);
            int mingrade = PolynomialMath.minDegree(this, p);
            int destgrade = maxgrade + mingrade;
            double[] n = new double[destgrade + 1];
            for (int k = 0; k < this._coeff.length; ++k) {
                for (int j = 0; j < p._coeff.length; ++j) {
                    int n2 = k + j;
                    n[n2] = n[n2] + this._coeff[k] * p._coeff[j];
                }
            }
            return new RealPolynomial(n);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    @Override
    public AbelianGroup.Member negate() {
        double[] c = new double[this._coeff.length];
        for (int k = 0; k < c.length; ++k) {
            c[k] = -this._coeff[k];
        }
        return new RealPolynomial(c);
    }

    @Override
    public RealFunction subtract(RealFunction g) {
        if (g instanceof RealPolynomial) {
            RealPolynomial p = (RealPolynomial)g;
            int maxgrade = PolynomialMath.maxDegree(this, p);
            double[] c = new double[maxgrade + 1];
            for (int k = 0; k < c.length; ++k) {
                c[k] = this.getCoefficientAsDouble(k) - p.getCoefficientAsDouble(k);
            }
            return new RealPolynomial(c);
        }
        return super.subtract(g);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("P(x) = ");
        if (this._coeff[this.degree()] < 0.0) {
            sb.append("-");
        } else {
            sb.append(" ");
        }
        for (int k = this.degree(); k > 0; --k) {
            sb.append(Math.abs(this._coeff[k])).append("x^").append(k).append(this._coeff[k - 1] >= 0.0 ? " + " : " - ");
        }
        sb.append(Math.abs(this._coeff[0]));
        return sb.toString();
    }
}

