/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.polynomials;

import jsci.maths.fields.Field;
import jsci.maths.polynomials.Polynomial;
import jsci.maths.polynomials.PolynomialBasis;
import jsci.maths.polynomials.RealPolynomial;
import jsci.maths.polynomials.RealPolynomialRing;

public class RealMonomialBasis
implements PolynomialBasis {
    private RealPolynomial[] _basis;
    private int _dim;

    public RealMonomialBasis(int dim) {
        this._dim = dim;
        this._basis = new RealPolynomial[dim];
    }

    @Override
    public Polynomial getBasisVector(int k) {
        if (k >= this._dim) {
            throw new ArrayIndexOutOfBoundsException();
        }
        double[] db = new double[this._dim];
        db[k] = 1.0;
        this._basis[k] = new RealPolynomial(db);
        return this._basis[k];
    }

    @Override
    public int dimension() {
        return this._dim;
    }

    @Override
    public Field.Member[] getSamplingPoints() {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public Polynomial superposition(Field.Member[] coeff) {
        return this.superposition(RealPolynomialRing.toDouble(coeff));
    }

    public RealPolynomial superposition(double[] d) {
        if (d == null) {
            throw new NullPointerException();
        }
        if (d.length != this._dim) {
            throw new IllegalArgumentException("Dimension of basis is " + this._dim + ". Got " + d.length + " coefficients");
        }
        return new RealPolynomial(d);
    }
}

