/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.polynomials;

import jsci.maths.fields.Field;
import jsci.maths.polynomials.Polynomial;
import jsci.maths.polynomials.PolynomialBasis;
import jsci.maths.polynomials.RealPolynomial;
import jsci.maths.polynomials.RealPolynomialRing;

public class RealLagrangeBasis
implements PolynomialBasis {
    protected double[] _samplingsX;
    protected int _dim;
    private RealPolynomial[] _basis;
    private Field.Member[] _samplings;

    public RealLagrangeBasis(Field.Member[] samplings) {
        if (samplings == null) {
            throw new NullPointerException();
        }
        this._dim = samplings.length;
        this._samplings = samplings;
        this._samplingsX = RealPolynomialRing.toDouble(this._samplings);
        this.buildBasis();
    }

    public RealLagrangeBasis(double[] samplings) {
        if (samplings == null) {
            throw new NullPointerException();
        }
        this._dim = samplings.length;
        this._samplingsX = samplings;
        this.buildBasis();
    }

    protected RealLagrangeBasis() {
    }

    @Override
    public Polynomial getBasisVector(int k) {
        return this._basis[k];
    }

    @Override
    public int dimension() {
        return this._dim;
    }

    @Override
    public Field.Member[] getSamplingPoints() {
        if (this._samplings == null) {
            this._samplings = RealPolynomialRing.toMathDouble(this._samplingsX);
        }
        return this._samplings;
    }

    @Override
    public Polynomial superposition(Field.Member[] coeff) {
        if (coeff == null) {
            throw new NullPointerException();
        }
        if (coeff.length != this._dim) {
            throw new IllegalArgumentException("Dimensions do not match");
        }
        double[] d = RealPolynomialRing.toDouble(coeff);
        return this.superposition(d);
    }

    public RealPolynomial superposition(double[] c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c.length != this._dim) {
            throw new IllegalArgumentException("Dimension of basis is " + this._dim + ". Got " + c.length + " coefficients");
        }
        RealPolynomial rp = (RealPolynomial)RealPolynomialRing.getInstance().zero();
        for (int k = 0; k < this._dim; ++k) {
            RealPolynomial b = (RealPolynomial)this.getBasisVector(k);
            RealPolynomial ba = b.scalarMultiply(c[k]);
            rp = (RealPolynomial)rp.add(ba);
        }
        return rp;
    }

    protected void buildBasis() {
        this._basis = new RealPolynomial[this._dim];
        for (int k = 0; k < this._dim; ++k) {
            this._basis[k] = (RealPolynomial)RealPolynomialRing.getInstance().one();
            double fac = 1.0;
            for (int j = 0; j < this._dim; ++j) {
                if (j == k) continue;
                RealPolynomial n = new RealPolynomial(new double[]{-this._samplingsX[j], 1.0});
                this._basis[k] = (RealPolynomial)this._basis[k].multiply(n);
                fac *= this._samplingsX[k] - this._samplingsX[j];
            }
            this._basis[k] = this._basis[k].scalarDivide(fac);
        }
    }
}

