/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.matrices;

import jsci.maths.ArrayMath;
import jsci.maths.Complex;
import jsci.maths.ComplexMapping;
import jsci.maths.LinearMath;
import jsci.maths.MaximumIterationsExceededException;
import jsci.maths.algebras.CStarAlgebra;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.matrices.AbstractComplexMatrix;
import jsci.maths.matrices.AbstractDoubleMatrix;
import jsci.maths.matrices.ComplexDiagonalMatrix;
import jsci.maths.matrices.ComplexSquareMatrix;
import jsci.maths.matrices.DoubleSquareMatrix;
import jsci.maths.matrices.Matrix;
import jsci.maths.matrices.MatrixDimensionException;
import jsci.maths.matrices.SquareMatrix;
import jsci.maths.vectors.AbstractComplexVector;

public abstract class AbstractComplexSquareMatrix
extends AbstractComplexMatrix
implements CStarAlgebra.Member,
SquareMatrix {
    protected transient AbstractComplexSquareMatrix[] LU;
    protected transient int[] LUpivot;

    protected AbstractComplexSquareMatrix(int size) {
        super(size, size);
    }

    @Override
    public AbstractDoubleMatrix real() {
        double[][] ans = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                ans[i][j] = this.getElement(i, j).real();
            }
        }
        return new DoubleSquareMatrix(ans);
    }

    @Override
    public AbstractDoubleMatrix imag() {
        double[][] ans = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                ans[i][j] = this.getElement(i, j).imag();
            }
        }
        return new DoubleSquareMatrix(ans);
    }

    public boolean isHermitian() {
        return this.equals(this.hermitianAdjoint());
    }

    public boolean isUnitary() {
        return this.multiply(this.hermitianAdjoint()).equals(ComplexDiagonalMatrix.identity(this.numRows));
    }

    public Complex det() {
        if (this.numRows == 2) {
            return new Complex(this.getRealElement(0, 0) * this.getRealElement(1, 1) - this.getImagElement(0, 0) * this.getImagElement(1, 1) - this.getRealElement(0, 1) * this.getRealElement(1, 0) + this.getImagElement(0, 1) * this.getImagElement(1, 0), this.getRealElement(0, 0) * this.getImagElement(1, 1) + this.getImagElement(0, 0) * this.getRealElement(1, 1) - this.getRealElement(0, 1) * this.getImagElement(1, 0) - this.getImagElement(0, 1) * this.getRealElement(1, 0));
        }
        AbstractComplexSquareMatrix[] lu = this.luDecompose(null);
        double detRe = lu[1].getRealElement(0, 0);
        double detIm = lu[1].getImagElement(0, 0);
        for (int i = 1; i < this.numRows; ++i) {
            double tmp = detRe * lu[1].getRealElement(i, i) - detIm * lu[1].getImagElement(i, i);
            detIm = detRe * lu[1].getImagElement(i, i) + detIm * lu[1].getRealElement(i, i);
            detRe = tmp;
        }
        return new Complex(detRe * (double)this.LUpivot[this.numRows], detIm * (double)this.LUpivot[this.numRows]);
    }

    public Complex trace() {
        double trRe = this.getRealElement(0, 0);
        double trIm = this.getImagElement(0, 0);
        for (int i = 1; i < this.numRows; ++i) {
            trRe += this.getRealElement(i, i);
            trIm += this.getImagElement(i, i);
        }
        return new Complex(trRe, trIm);
    }

    @Override
    public double norm() {
        try {
            return this.operatorNorm();
        }
        catch (MaximumIterationsExceededException e) {
            throw new RuntimeException(e);
        }
    }

    public double operatorNorm() throws MaximumIterationsExceededException {
        return Math.sqrt(ArrayMath.max(LinearMath.eigenvalueSolveHermitian((AbstractComplexSquareMatrix)this.hermitianAdjoint().multiply(this))));
    }

    @Override
    public AbelianGroup.Member negate() {
        double[][] arrayRe = new double[this.numRows][this.numCols];
        double[][] arrayIm = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            arrayRe[i][0] = -this.getRealElement(i, 0);
            arrayIm[i][0] = -this.getImagElement(i, 0);
            for (int j = 1; j < this.numCols; ++j) {
                arrayRe[i][j] = -this.getRealElement(i, j);
                arrayIm[i][j] = -this.getImagElement(i, j);
            }
        }
        return new ComplexSquareMatrix(arrayRe, arrayIm);
    }

    @Override
    public final AbstractComplexMatrix add(AbstractComplexMatrix m) {
        if (m instanceof AbstractComplexSquareMatrix) {
            return this.add((AbstractComplexSquareMatrix)m);
        }
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            return this.add(new SquareMatrixAdaptor(m));
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractComplexSquareMatrix add(AbstractComplexSquareMatrix m) {
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            double[][] arrayRe = new double[this.numRows][this.numCols];
            double[][] arrayIm = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                arrayRe[i][0] = this.getRealElement(i, 0) + m.getRealElement(i, 0);
                arrayIm[i][0] = this.getImagElement(i, 0) + m.getImagElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    arrayRe[i][j] = this.getRealElement(i, j) + m.getRealElement(i, j);
                    arrayIm[i][j] = this.getImagElement(i, j) + m.getImagElement(i, j);
                }
            }
            return new ComplexSquareMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public final AbstractComplexMatrix subtract(AbstractComplexMatrix m) {
        if (m instanceof AbstractComplexSquareMatrix) {
            return this.subtract((AbstractComplexSquareMatrix)m);
        }
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            return this.subtract(new SquareMatrixAdaptor(m));
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractComplexSquareMatrix subtract(AbstractComplexSquareMatrix m) {
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            double[][] arrayRe = new double[this.numRows][this.numCols];
            double[][] arrayIm = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                arrayRe[i][0] = this.getRealElement(i, 0) - m.getRealElement(i, 0);
                arrayIm[i][0] = this.getImagElement(i, 0) - m.getImagElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    arrayRe[i][j] = this.getRealElement(i, j) - m.getRealElement(i, j);
                    arrayIm[i][j] = this.getImagElement(i, j) - m.getImagElement(i, j);
                }
            }
            return new ComplexSquareMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public AbstractComplexMatrix scalarMultiply(Complex z) {
        double real = z.real();
        double imag = z.imag();
        double[][] arrayRe = new double[this.numRows][this.numCols];
        double[][] arrayIm = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            arrayRe[i][0] = real * this.getRealElement(i, 0) - imag * this.getImagElement(i, 0);
            arrayIm[i][0] = imag * this.getRealElement(i, 0) + real * this.getImagElement(i, 0);
            for (int j = 1; j < this.numCols; ++j) {
                arrayRe[i][j] = real * this.getRealElement(i, j) - imag * this.getImagElement(i, j);
                arrayIm[i][j] = imag * this.getRealElement(i, j) + real * this.getImagElement(i, j);
            }
        }
        return new ComplexSquareMatrix(arrayRe, arrayIm);
    }

    @Override
    public AbstractComplexMatrix scalarMultiply(double x) {
        double[][] arrayRe = new double[this.numRows][this.numCols];
        double[][] arrayIm = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            arrayRe[i][0] = x * this.getRealElement(i, 0);
            arrayIm[i][0] = x * this.getImagElement(i, 0);
            for (int j = 1; j < this.numCols; ++j) {
                arrayRe[i][j] = x * this.getRealElement(i, j);
                arrayIm[i][j] = x * this.getImagElement(i, j);
            }
        }
        return new ComplexSquareMatrix(arrayRe, arrayIm);
    }

    @Override
    public AbstractComplexMatrix scalarDivide(Complex z) {
        Complex[][] array = new Complex[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            array[i][0] = this.getElement(i, 0).divide(z);
            for (int j = 1; j < this.numCols; ++j) {
                array[i][j] = this.getElement(i, j).divide(z);
            }
        }
        return new ComplexSquareMatrix(array);
    }

    @Override
    public AbstractComplexMatrix scalarDivide(double x) {
        double[][] arrayRe = new double[this.numRows][this.numCols];
        double[][] arrayIm = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            arrayRe[i][0] = this.getRealElement(i, 0) / x;
            arrayIm[i][0] = this.getImagElement(i, 0) / x;
            for (int j = 1; j < this.numCols; ++j) {
                arrayRe[i][j] = this.getRealElement(i, j) / x;
                arrayIm[i][j] = this.getImagElement(i, j) / x;
            }
        }
        return new ComplexSquareMatrix(arrayRe, arrayIm);
    }

    @Override
    public final Complex scalarProduct(AbstractComplexMatrix m) {
        if (m instanceof AbstractComplexSquareMatrix) {
            return this.scalarProduct((AbstractComplexSquareMatrix)m);
        }
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            return this.scalarProduct(new SquareMatrixAdaptor(m));
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public Complex scalarProduct(AbstractComplexSquareMatrix m) {
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            double real = 0.0;
            double imag = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                real += this.getRealElement(i, 0) * m.getRealElement(i, 0) + this.getImagElement(i, 0) * m.getImagElement(i, 0);
                imag += this.getImagElement(i, 0) * m.getRealElement(i, 0) - this.getRealElement(i, 0) * m.getImagElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    real += this.getRealElement(i, j) * m.getRealElement(i, j) + this.getImagElement(i, j) * m.getImagElement(i, j);
                    imag += this.getImagElement(i, j) * m.getRealElement(i, j) - this.getRealElement(i, j) * m.getImagElement(i, j);
                }
            }
            return new Complex(real, imag);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractComplexSquareMatrix multiply(AbstractComplexSquareMatrix m) {
        if (this.numCols == m.rows()) {
            double[][] arrayRe = new double[this.numRows][m.columns()];
            double[][] arrayIm = new double[this.numRows][m.columns()];
            for (int j = 0; j < this.numRows; ++j) {
                for (int k = 0; k < m.columns(); ++k) {
                    Complex tmp = this.getElement(j, 0).multiply(m.getElement(0, k));
                    arrayRe[j][k] = tmp.real();
                    arrayIm[j][k] = tmp.imag();
                    for (int n = 1; n < this.numCols; ++n) {
                        tmp = this.getElement(j, n).multiply(m.getElement(n, k));
                        double[] dArray = arrayRe[j];
                        int n2 = k;
                        dArray[n2] = dArray[n2] + tmp.real();
                        double[] dArray2 = arrayIm[j];
                        int n3 = k;
                        dArray2[n3] = dArray2[n3] + tmp.imag();
                    }
                }
            }
            return new ComplexSquareMatrix(arrayRe, arrayIm);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public AbstractComplexSquareMatrix directSum(AbstractComplexSquareMatrix m) {
        int j;
        int i;
        double[][] arrayRe = new double[this.numRows + m.numRows][this.numCols + m.numCols];
        double[][] arrayIm = new double[this.numRows + m.numRows][this.numCols + m.numCols];
        for (i = 0; i < this.numRows; ++i) {
            for (j = 0; j < this.numCols; ++j) {
                arrayRe[i][j] = this.getRealElement(i, j);
                arrayIm[i][j] = this.getImagElement(i, j);
            }
        }
        for (i = 0; i < m.numRows; ++i) {
            for (j = 0; j < m.numCols; ++j) {
                arrayRe[i + this.numRows][j + this.numCols] = m.getRealElement(i, j);
                arrayIm[i + this.numRows][j + this.numCols] = m.getImagElement(i, j);
            }
        }
        return new ComplexSquareMatrix(arrayRe, arrayIm);
    }

    public AbstractComplexSquareMatrix tensor(AbstractComplexSquareMatrix m) {
        double[][] arrayRe = new double[this.numRows * m.numRows][this.numCols * m.numCols];
        double[][] arrayIm = new double[this.numRows * m.numRows][this.numCols * m.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                int k = 0;
                while (k < m.numRows) {
                    for (int l = 0; l < m.numCols; ++l) {
                        Complex tmp = this.getElement(i, j).multiply(m.getElement(k, l));
                        arrayRe[i * m.numRows + k][j * m.numCols + l] = tmp.real();
                        arrayIm[i * m.numRows + k][j * m.numCols + l] = tmp.imag();
                    }
                    ++j;
                }
            }
        }
        return new ComplexSquareMatrix(arrayRe, arrayIm);
    }

    @Override
    public final CStarAlgebra.Member involution() {
        return (CStarAlgebra.Member)((Object)this.hermitianAdjoint());
    }

    @Override
    public AbstractComplexMatrix hermitianAdjoint() {
        double[][] arrayRe = new double[this.numCols][this.numRows];
        double[][] arrayIm = new double[this.numCols][this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            arrayRe[0][i] = this.getRealElement(i, 0);
            arrayIm[0][i] = -this.getImagElement(i, 0);
            for (int j = 1; j < this.numCols; ++j) {
                arrayRe[j][i] = this.getRealElement(i, j);
                arrayIm[j][i] = -this.getImagElement(i, j);
            }
        }
        return new ComplexSquareMatrix(arrayRe, arrayIm);
    }

    @Override
    public AbstractComplexMatrix conjugate() {
        double[][] arrayRe = new double[this.numCols][this.numRows];
        double[][] arrayIm = new double[this.numCols][this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            arrayRe[i][0] = this.getRealElement(i, 0);
            arrayIm[i][0] = -this.getImagElement(i, 0);
            for (int j = 1; j < this.numCols; ++j) {
                arrayRe[i][j] = this.getRealElement(i, j);
                arrayIm[i][j] = -this.getImagElement(i, j);
            }
        }
        return new ComplexSquareMatrix(arrayRe, arrayIm);
    }

    @Override
    public Matrix transpose() {
        double[][] arrayRe = new double[this.numCols][this.numRows];
        double[][] arrayIm = new double[this.numCols][this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            arrayRe[0][i] = this.getRealElement(i, 0);
            arrayIm[0][i] = this.getImagElement(i, 0);
            for (int j = 1; j < this.numCols; ++j) {
                arrayRe[j][i] = this.getRealElement(i, j);
                arrayIm[j][i] = this.getImagElement(i, j);
            }
        }
        return new ComplexSquareMatrix(arrayRe, arrayIm);
    }

    public AbstractComplexSquareMatrix inverse() {
        int i;
        int N = this.numRows;
        double[][] arrayLRe = new double[N][N];
        double[][] arrayLIm = new double[N][N];
        double[][] arrayURe = new double[N][N];
        double[][] arrayUIm = new double[N][N];
        AbstractComplexSquareMatrix[] lu = this.luDecompose(null);
        double denom = lu[0].getRealElement(0, 0) * lu[0].getRealElement(0, 0) + lu[0].getImagElement(0, 0) * lu[0].getImagElement(0, 0);
        arrayLRe[0][0] = lu[0].getRealElement(0, 0) / denom;
        arrayLIm[0][0] = -lu[0].getImagElement(0, 0) / denom;
        denom = lu[1].getRealElement(0, 0) * lu[1].getRealElement(0, 0) + lu[1].getImagElement(0, 0) * lu[1].getImagElement(0, 0);
        arrayURe[0][0] = lu[1].getRealElement(0, 0) / denom;
        arrayUIm[0][0] = -lu[1].getImagElement(0, 0) / denom;
        for (i = 1; i < N; ++i) {
            denom = lu[0].getRealElement(i, i) * lu[0].getRealElement(i, i) + lu[0].getImagElement(i, i) * lu[0].getImagElement(i, i);
            arrayLRe[i][i] = lu[0].getRealElement(i, i) / denom;
            arrayLIm[i][i] = -lu[0].getImagElement(i, i) / denom;
            denom = lu[1].getRealElement(i, i) * lu[1].getRealElement(i, i) + lu[1].getImagElement(i, i) * lu[1].getImagElement(i, i);
            arrayURe[i][i] = lu[1].getRealElement(i, i) / denom;
            arrayUIm[i][i] = -lu[1].getImagElement(i, i) / denom;
        }
        for (i = 0; i < N - 1; ++i) {
            for (int j = i + 1; j < N; ++j) {
                double tmpLRe = 0.0;
                double tmpLIm = 0.0;
                double tmpURe = 0.0;
                double tmpUIm = 0.0;
                for (int k = i; k < j; ++k) {
                    tmpLRe -= lu[0].getRealElement(j, k) * arrayLRe[k][i] - lu[0].getImagElement(j, k) * arrayLIm[k][i];
                    tmpLIm -= lu[0].getImagElement(j, k) * arrayLRe[k][i] + lu[0].getRealElement(j, k) * arrayLIm[k][i];
                    tmpURe -= arrayURe[i][k] * lu[1].getRealElement(k, j) - arrayUIm[i][k] * lu[1].getImagElement(k, j);
                    tmpUIm -= arrayUIm[i][k] * lu[1].getRealElement(k, j) + arrayURe[i][k] * lu[1].getImagElement(k, j);
                }
                denom = lu[0].getRealElement(j, j) * lu[0].getRealElement(j, j) + lu[0].getImagElement(j, j) * lu[0].getImagElement(j, j);
                arrayLRe[j][i] = (tmpLRe * lu[0].getRealElement(j, j) + tmpLIm * lu[0].getImagElement(j, j)) / denom;
                arrayLIm[j][i] = (tmpLIm * lu[0].getRealElement(j, j) - tmpLRe * lu[0].getImagElement(j, j)) / denom;
                denom = lu[1].getRealElement(j, j) * lu[1].getRealElement(j, j) + lu[1].getImagElement(j, j) * lu[1].getImagElement(j, j);
                arrayURe[i][j] = (tmpURe * lu[1].getRealElement(j, j) + tmpUIm * lu[1].getImagElement(j, j)) / denom;
                arrayUIm[i][j] = (tmpUIm * lu[1].getRealElement(j, j) - tmpURe * lu[1].getImagElement(j, j)) / denom;
            }
        }
        double[][] invRe = new double[N][N];
        double[][] invIm = new double[N][N];
        for (int i2 = 0; i2 < N; ++i2) {
            int k;
            int j;
            for (j = 0; j < i2; ++j) {
                for (k = i2; k < N; ++k) {
                    double[] dArray = invRe[i2];
                    int n = this.LUpivot[j];
                    dArray[n] = dArray[n] + (arrayURe[i2][k] * arrayLRe[k][j] - arrayUIm[i2][k] * arrayLIm[k][j]);
                    double[] dArray2 = invIm[i2];
                    int n2 = this.LUpivot[j];
                    dArray2[n2] = dArray2[n2] + (arrayUIm[i2][k] * arrayLRe[k][j] + arrayURe[i2][k] * arrayLIm[k][j]);
                }
            }
            for (j = i2; j < N; ++j) {
                for (k = j; k < N; ++k) {
                    double[] dArray = invRe[i2];
                    int n = this.LUpivot[j];
                    dArray[n] = dArray[n] + (arrayURe[i2][k] * arrayLRe[k][j] - arrayUIm[i2][k] * arrayLIm[k][j]);
                    double[] dArray3 = invIm[i2];
                    int n3 = this.LUpivot[j];
                    dArray3[n3] = dArray3[n3] + (arrayUIm[i2][k] * arrayLRe[k][j] + arrayURe[i2][k] * arrayLIm[k][j]);
                }
            }
        }
        return new ComplexSquareMatrix(invRe, invIm);
    }

    public AbstractComplexSquareMatrix[] luDecompose(int[] pivot) {
        int j;
        if (this.LU != null) {
            if (pivot != null) {
                System.arraycopy(this.LUpivot, 0, pivot, 0, pivot.length);
            }
            return this.LU;
        }
        int N = this.numRows;
        double[][] arrayLRe = new double[N][N];
        double[][] arrayLIm = new double[N][N];
        double[][] arrayURe = new double[N][N];
        double[][] arrayUIm = new double[N][N];
        if (pivot == null) {
            pivot = new int[N + 1];
        }
        for (int i = 0; i < N; ++i) {
            pivot[i] = i;
        }
        pivot[N] = 1;
        for (j = 0; j < N; ++j) {
            double tmp;
            int i;
            double denom;
            double a;
            for (int i2 = 0; i2 < j; ++i2) {
                double tmpRe = this.getRealElement(pivot[i2], j);
                double tmpIm = this.getImagElement(pivot[i2], j);
                for (int k = 0; k < i2; ++k) {
                    tmpRe -= arrayURe[i2][k] * arrayURe[k][j] - arrayUIm[i2][k] * arrayUIm[k][j];
                    tmpIm -= arrayUIm[i2][k] * arrayURe[k][j] + arrayURe[i2][k] * arrayUIm[k][j];
                }
                arrayURe[i2][j] = tmpRe;
                arrayUIm[i2][j] = tmpIm;
            }
            double max = 0.0;
            int pivotrow = j;
            for (int i3 = j; i3 < N; ++i3) {
                double tmpRe = this.getRealElement(pivot[i3], j);
                double tmpIm = this.getImagElement(pivot[i3], j);
                for (int k = 0; k < j; ++k) {
                    tmpRe -= arrayURe[i3][k] * arrayURe[k][j] - arrayUIm[i3][k] * arrayUIm[k][j];
                    tmpIm -= arrayUIm[i3][k] * arrayURe[k][j] + arrayURe[i3][k] * arrayUIm[k][j];
                }
                arrayURe[i3][j] = tmpRe;
                arrayUIm[i3][j] = tmpIm;
                double tmp2 = tmpRe * tmpRe + tmpIm * tmpIm;
                if (!(tmp2 > max)) continue;
                max = tmp2;
                pivotrow = i3;
            }
            if (pivotrow != j) {
                double[] tmprow = arrayURe[j];
                arrayURe[j] = arrayURe[pivotrow];
                arrayURe[pivotrow] = tmprow;
                tmprow = arrayUIm[j];
                arrayUIm[j] = arrayUIm[pivotrow];
                arrayUIm[pivotrow] = tmprow;
                int k = pivot[j];
                pivot[j] = pivot[pivotrow];
                pivot[pivotrow] = k;
                pivot[N] = -pivot[N];
            }
            double tmpRe = arrayURe[j][j];
            double tmpIm = arrayUIm[j][j];
            if (Math.abs(tmpRe) < Math.abs(tmpIm)) {
                a = tmpRe / tmpIm;
                denom = tmpRe * a + tmpIm;
                for (i = j + 1; i < N; ++i) {
                    tmp = (arrayURe[i][j] * a + arrayUIm[i][j]) / denom;
                    arrayUIm[i][j] = (arrayUIm[i][j] * a - arrayURe[i][j]) / denom;
                    arrayURe[i][j] = tmp;
                }
                continue;
            }
            a = tmpIm / tmpRe;
            denom = tmpRe + tmpIm * a;
            for (i = j + 1; i < N; ++i) {
                tmp = (arrayURe[i][j] + arrayUIm[i][j] * a) / denom;
                arrayUIm[i][j] = (arrayUIm[i][j] - arrayURe[i][j] * a) / denom;
                arrayURe[i][j] = tmp;
            }
        }
        for (j = 0; j < N; ++j) {
            arrayLRe[j][j] = 1.0;
            for (int i = j + 1; i < N; ++i) {
                arrayLRe[i][j] = arrayURe[i][j];
                arrayLIm[i][j] = arrayUIm[i][j];
                arrayURe[i][j] = 0.0;
                arrayUIm[i][j] = 0.0;
            }
        }
        this.LU = new AbstractComplexSquareMatrix[2];
        this.LU[0] = new ComplexSquareMatrix(arrayLRe, arrayLIm);
        this.LU[1] = new ComplexSquareMatrix(arrayURe, arrayUIm);
        this.LUpivot = new int[pivot.length];
        System.arraycopy(pivot, 0, this.LUpivot, 0, pivot.length);
        return this.LU;
    }

    public AbstractComplexSquareMatrix[] luDecompose() {
        int j;
        int N = this.numRows;
        double[][] arrayLRe = new double[N][N];
        double[][] arrayLIm = new double[N][N];
        double[][] arrayURe = new double[N][N];
        double[][] arrayUIm = new double[N][N];
        for (j = 0; j < N; ++j) {
            double tmp;
            int i;
            double denom;
            double a;
            int k;
            double tmpIm;
            double tmpRe;
            int i2;
            for (i2 = 0; i2 < j; ++i2) {
                tmpRe = this.getRealElement(i2, j);
                tmpIm = this.getImagElement(i2, j);
                for (k = 0; k < i2; ++k) {
                    tmpRe -= arrayURe[i2][k] * arrayURe[k][j] - arrayUIm[i2][k] * arrayUIm[k][j];
                    tmpIm -= arrayUIm[i2][k] * arrayURe[k][j] + arrayURe[i2][k] * arrayUIm[k][j];
                }
                arrayURe[i2][j] = tmpRe;
                arrayUIm[i2][j] = tmpIm;
            }
            for (i2 = j; i2 < N; ++i2) {
                tmpRe = this.getRealElement(i2, j);
                tmpIm = this.getImagElement(i2, j);
                for (k = 0; k < j; ++k) {
                    tmpRe -= arrayURe[i2][k] * arrayURe[k][j] - arrayUIm[i2][k] * arrayUIm[k][j];
                    tmpIm -= arrayUIm[i2][k] * arrayURe[k][j] + arrayURe[i2][k] * arrayUIm[k][j];
                }
                arrayURe[i2][j] = tmpRe;
                arrayUIm[i2][j] = tmpIm;
            }
            double tmpRe2 = arrayURe[j][j];
            double tmpIm2 = arrayUIm[j][j];
            if (Math.abs(tmpRe2) < Math.abs(tmpIm2)) {
                a = tmpRe2 / tmpIm2;
                denom = tmpRe2 * a + tmpIm2;
                for (i = j + 1; i < N; ++i) {
                    tmp = (arrayURe[i][j] * a + arrayUIm[i][j]) / denom;
                    arrayUIm[i][j] = (arrayUIm[i][j] * a - arrayURe[i][j]) / denom;
                    arrayURe[i][j] = tmp;
                }
                continue;
            }
            a = tmpIm2 / tmpRe2;
            denom = tmpRe2 + tmpIm2 * a;
            for (i = j + 1; i < N; ++i) {
                tmp = (arrayURe[i][j] + arrayUIm[i][j] * a) / denom;
                arrayUIm[i][j] = (arrayUIm[i][j] - arrayURe[i][j] * a) / denom;
                arrayURe[i][j] = tmp;
            }
        }
        for (j = 0; j < N; ++j) {
            arrayLRe[j][j] = 1.0;
            for (int i = j + 1; i < N; ++i) {
                arrayLRe[i][j] = arrayURe[i][j];
                arrayLIm[i][j] = arrayUIm[i][j];
                arrayURe[i][j] = 0.0;
                arrayUIm[i][j] = 0.0;
            }
        }
        AbstractComplexSquareMatrix[] lu = new AbstractComplexSquareMatrix[]{new ComplexSquareMatrix(arrayLRe, arrayLIm), new ComplexSquareMatrix(arrayURe, arrayUIm)};
        return lu;
    }

    public AbstractComplexSquareMatrix[] polarDecompose() {
        Complex comp;
        double[] eval;
        int N = this.numRows;
        AbstractComplexVector[] evec = new AbstractComplexVector[N];
        try {
            eval = LinearMath.eigenSolveHermitian(this, evec);
        }
        catch (MaximumIterationsExceededException e) {
            return null;
        }
        double[][] tmpaRe = new double[N][N];
        double[][] tmpaIm = new double[N][N];
        double[][] tmpmRe = new double[N][N];
        double[][] tmpmIm = new double[N][N];
        for (int i = 0; i < N; ++i) {
            double abs = Math.abs(eval[i]);
            comp = evec[i].getComponent(0).conjugate();
            tmpaRe[i][0] = eval[i] * comp.real() / abs;
            tmpaIm[i][0] = eval[i] * comp.imag() / abs;
            tmpmRe[i][0] = abs * comp.real();
            tmpmIm[i][0] = abs * comp.imag();
            for (int j = 1; j < N; ++j) {
                comp = evec[i].getComponent(j).conjugate();
                tmpaRe[i][j] = eval[i] * comp.real() / abs;
                tmpaIm[i][j] = eval[i] * comp.imag() / abs;
                tmpmRe[i][j] = abs * comp.real();
                tmpmIm[i][j] = abs * comp.imag();
            }
        }
        double[][] argRe = new double[N][N];
        double[][] argIm = new double[N][N];
        double[][] modRe = new double[N][N];
        double[][] modIm = new double[N][N];
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                comp = evec[0].getComponent(i);
                argRe[i][j] = tmpaRe[0][j] * comp.real() - tmpaIm[0][j] * comp.imag();
                argIm[i][j] = tmpaIm[0][j] * comp.real() + tmpaRe[0][j] * comp.imag();
                modRe[i][j] = tmpmRe[0][j] * comp.real() - tmpmIm[0][j] * comp.imag();
                modIm[i][j] = tmpmIm[0][j] * comp.real() + tmpmRe[0][j] * comp.imag();
                for (int k = 1; k < N; ++k) {
                    comp = evec[k].getComponent(i);
                    double[] dArray = argRe[i];
                    int n = j;
                    dArray[n] = dArray[n] + (tmpaRe[k][j] * comp.real() - tmpaIm[k][j] * comp.imag());
                    double[] dArray2 = argIm[i];
                    int n2 = j;
                    dArray2[n2] = dArray2[n2] + (tmpaIm[k][j] * comp.real() + tmpaRe[k][j] * comp.imag());
                    double[] dArray3 = modRe[i];
                    int n3 = j;
                    dArray3[n3] = dArray3[n3] + (tmpmRe[k][j] * comp.real() - tmpmIm[k][j] * comp.imag());
                    double[] dArray4 = modIm[i];
                    int n4 = j;
                    dArray4[n4] = dArray4[n4] + (tmpmIm[k][j] * comp.real() + tmpmRe[k][j] * comp.imag());
                }
            }
        }
        AbstractComplexSquareMatrix[] us = new AbstractComplexSquareMatrix[]{new ComplexSquareMatrix(argRe, argIm), new ComplexSquareMatrix(modRe, modIm)};
        return us;
    }

    @Override
    public AbstractComplexMatrix mapElements(ComplexMapping f) {
        Complex[][] array = new Complex[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            array[i][0] = f.map(this.getElement(i, 0));
            for (int j = 1; j < this.numCols; ++j) {
                array[i][j] = f.map(this.getElement(i, j));
            }
        }
        return new ComplexSquareMatrix(array);
    }

    private static class SquareMatrixAdaptor
    extends AbstractComplexSquareMatrix {
        private final AbstractComplexMatrix matrix;

        private SquareMatrixAdaptor(AbstractComplexMatrix m) {
            super(m.rows());
            this.matrix = m;
        }

        @Override
        public Complex getElement(int i, int j) {
            return this.matrix.getElement(i, j);
        }

        @Override
        public double getRealElement(int i, int j) {
            return this.matrix.getRealElement(i, j);
        }

        @Override
        public double getImagElement(int i, int j) {
            return this.matrix.getImagElement(i, j);
        }

        @Override
        public void setElement(int i, int j, Complex z) {
            this.matrix.setElement(i, j, z);
        }

        @Override
        public void setElement(int i, int j, double x, double y) {
            this.matrix.setElement(i, j, x, y);
        }
    }
}

