/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.groups;

import jsci.maths.groups.FiniteGroup;
import jsci.maths.groups.Group;
import jsci.maths.groups.Monoid;
import jsci.maths.groups.Semigroup;

public final class QuaternionGroup
extends FiniteGroup {
    private static final QuaternionGroup _instance = new QuaternionGroup();
    private final Member ONE = new Member(1);
    private static final int[][] multTable = new int[][]{{1, 2, 3, 4}, {2, -1, 4, -3}, {3, -4, -1, 2}, {4, 3, -2, -1}};

    private QuaternionGroup() {
        super(8);
    }

    public static final QuaternionGroup getInstance() {
        return _instance;
    }

    public String toString() {
        return "Q";
    }

    @Override
    public Group.Member[] getElements() {
        return new Group.Member[]{new Member(1), new Member(2), new Member(3), new Member(4), new Member(-1), new Member(-2), new Member(-3), new Member(-4)};
    }

    @Override
    public Monoid.Member identity() {
        return this.ONE;
    }

    @Override
    public boolean isIdentity(Monoid.Member a) {
        return a.equals(this.ONE);
    }

    @Override
    public boolean isInverse(Group.Member a, Group.Member b) {
        return a instanceof Member && b instanceof Member && a.compose(b).equals(this.ONE);
    }

    class Member
    implements Group.Member {
        private final int unit;

        public Member(int e) {
            if (e < -4 || e == 0 || e > 4) {
                throw new IllegalArgumentException();
            }
            this.unit = e;
        }

        public boolean equals(Object o) {
            return o instanceof Member && this.unit == ((Member)o).unit;
        }

        public int hashCode() {
            return this.unit;
        }

        @Override
        public Object getSet() {
            return QuaternionGroup.this;
        }

        @Override
        public Semigroup.Member compose(Semigroup.Member g) {
            int gunit = ((Member)g).unit;
            if (this.unit > 0 && gunit > 0) {
                return new Member(multTable[this.unit][gunit]);
            }
            if (this.unit > 0 && gunit < 0) {
                return new Member(-multTable[this.unit][-gunit]);
            }
            if (this.unit < 0 && gunit > 0) {
                return new Member(-multTable[-this.unit][gunit]);
            }
            return new Member(multTable[-this.unit][-gunit]);
        }

        @Override
        public Group.Member inverse() {
            return new Member(-this.unit);
        }
    }
}

