/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.analysis;

import jsci.maths.DimensionException;
import jsci.maths.analysis.RealFunction;
import jsci.maths.fields.Ring;
import jsci.maths.groups.AbelianGroup;

public abstract class RealFunctionND
implements Ring.Member {
    protected final int dim;

    protected RealFunctionND(int dim) {
        this.dim = dim;
    }

    public abstract double map(double[] var1);

    public final int dimension() {
        return this.dim;
    }

    @Override
    public Object getSet() {
        throw new RuntimeException("Not implemented: file bug");
    }

    @Override
    public AbelianGroup.Member negate() {
        return new Negation(this);
    }

    @Override
    public AbelianGroup.Member add(AbelianGroup.Member f) {
        if (f instanceof RealFunctionND) {
            return this.add((RealFunctionND)f);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RealFunctionND add(RealFunctionND f) {
        if (this.dim != f.dim) {
            throw new DimensionException("Functions have different dimensions.");
        }
        return new Sum(this, f);
    }

    @Override
    public AbelianGroup.Member subtract(AbelianGroup.Member f) {
        if (f instanceof RealFunctionND) {
            return this.subtract((RealFunctionND)f);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RealFunctionND subtract(RealFunctionND f) {
        if (this.dim != f.dim) {
            throw new DimensionException("Functions have different dimensions.");
        }
        return new Difference(this, f);
    }

    @Override
    public Ring.Member multiply(Ring.Member f) {
        if (f instanceof RealFunctionND) {
            return this.multiply((RealFunctionND)f);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RealFunctionND multiply(RealFunctionND f) {
        if (this.dim != f.dim) {
            throw new DimensionException("Functions have different dimensions.");
        }
        return new Product(this, f);
    }

    public Ring.Member inverse() {
        return new Reciprocal(this);
    }

    public Ring.Member divide(Ring.Member f) {
        if (f instanceof RealFunctionND) {
            return this.divide((RealFunctionND)f);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RealFunctionND divide(RealFunctionND f) {
        if (this.dim != f.dim) {
            throw new DimensionException("Functions have different dimensions.");
        }
        return new Quotient(this, f);
    }

    public RealFunctionND tensor(RealFunction f) {
        return new TensorProductN1D(this, f);
    }

    public RealFunctionND tensor(RealFunctionND f) {
        return new TensorProductND(this, f);
    }

    public static RealFunctionND constant(int dim, double k) {
        return new Constant(dim, k);
    }

    private static class Constant
    extends RealFunctionND {
        private final double A;

        public Constant(int dim, double A) {
            super(dim);
            this.A = A;
        }

        @Override
        public double map(double[] x) {
            return this.A;
        }
    }

    private static class TensorProductND
    extends RealFunctionND {
        private final RealFunctionND f1;
        private final RealFunctionND f2;

        public TensorProductND(RealFunctionND f1, RealFunctionND f2) {
            super(f1.dim + f2.dim);
            this.f1 = f1;
            this.f2 = f2;
        }

        @Override
        public double map(double[] x) {
            double[] x1 = new double[this.f1.dim];
            double[] x2 = new double[this.f2.dim];
            System.arraycopy(x, 0, x1, 0, x1.length);
            System.arraycopy(x, x1.length, x2, 0, x2.length);
            return this.f1.map(x1) * this.f2.map(x2);
        }
    }

    private static class TensorProductN1D
    extends RealFunctionND {
        private final RealFunctionND f1;
        private final RealFunction f2;

        public TensorProductN1D(RealFunctionND f1, RealFunction f2) {
            super(f1.dim + 1);
            this.f1 = f1;
            this.f2 = f2;
        }

        @Override
        public double map(double[] x) {
            double[] x1 = new double[this.f1.dim];
            System.arraycopy(x, 0, x1, 0, x1.length);
            double x2 = x[x1.length];
            return this.f1.map(x1) * this.f2.map(x2);
        }
    }

    private static class Quotient
    extends RealFunctionND {
        private final RealFunctionND f1;
        private final RealFunctionND f2;

        public Quotient(RealFunctionND f1, RealFunctionND f2) {
            super(f1.dim);
            this.f1 = f1;
            this.f2 = f2;
        }

        @Override
        public double map(double[] x) {
            return this.f1.map(x) / this.f2.map(x);
        }
    }

    private static class Reciprocal
    extends RealFunctionND {
        private final RealFunctionND f;

        public Reciprocal(RealFunctionND f) {
            super(f.dim);
            this.f = f;
        }

        @Override
        public double map(double[] x) {
            return 1.0 / this.f.map(x);
        }
    }

    private static class Product
    extends RealFunctionND {
        private final RealFunctionND f1;
        private final RealFunctionND f2;

        public Product(RealFunctionND f1, RealFunctionND f2) {
            super(f1.dim);
            this.f1 = f1;
            this.f2 = f2;
        }

        @Override
        public double map(double[] x) {
            return this.f1.map(x) * this.f2.map(x);
        }
    }

    private static class Difference
    extends RealFunctionND {
        private final RealFunctionND f1;
        private final RealFunctionND f2;

        public Difference(RealFunctionND f1, RealFunctionND f2) {
            super(f1.dim);
            this.f1 = f1;
            this.f2 = f2;
        }

        @Override
        public double map(double[] x) {
            return this.f1.map(x) - this.f2.map(x);
        }
    }

    private static class Sum
    extends RealFunctionND {
        private final RealFunctionND f1;
        private final RealFunctionND f2;

        public Sum(RealFunctionND f1, RealFunctionND f2) {
            super(f1.dim);
            this.f1 = f1;
            this.f2 = f2;
        }

        @Override
        public double map(double[] x) {
            return this.f1.map(x) + this.f2.map(x);
        }
    }

    private static class Negation
    extends RealFunctionND {
        private final RealFunctionND f;

        public Negation(RealFunctionND f) {
            super(f.dim);
            this.f = f;
        }

        @Override
        public double map(double[] x) {
            return -this.f.map(x);
        }
    }
}

