/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.analysis;

import jsci.maths.analysis.RealFunction;

public class Power
extends RealFunction {
    private final double A;
    private final double n;
    private final double k;

    public Power() {
        this(1.0, 0.0, 1.0);
    }

    public Power(double A, double n) {
        this(A, 0.0, n);
    }

    public Power(double A, double k, double n) {
        this.A = A;
        this.k = k;
        this.n = n;
    }

    @Override
    public double map(double x) {
        x += this.k;
        if (this.n != 1.0) {
            x = this.n == 2.0 ? (x *= x) : Math.pow(x, this.n);
        }
        return this.A * x;
    }

    @Override
    public RealFunction differentiate() {
        return new Power(this.A * this.n, this.k, this.n - 1.0);
    }
}

