/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.analysis;

import jsci.maths.Complex;
import jsci.maths.ComplexMapping;
import jsci.maths.fields.Ring;
import jsci.maths.groups.AbelianGroup;

public abstract class ComplexFunction
implements ComplexMapping,
Ring.Member {
    private static final ComplexFunction ZERO = ComplexFunction.constant(Complex.ZERO);

    public final int dimension() {
        return 1;
    }

    @Override
    public Object getSet() {
        throw new RuntimeException("Not implemented: please file bug report");
    }

    public ComplexFunction compose(ComplexFunction f) {
        return new Composition(this, f);
    }

    @Override
    public AbelianGroup.Member negate() {
        return new Negation(this);
    }

    @Override
    public AbelianGroup.Member add(AbelianGroup.Member f) {
        if (f instanceof ComplexFunction) {
            return this.add((ComplexFunction)f);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public ComplexFunction add(ComplexFunction f) {
        return new Sum(this, f);
    }

    @Override
    public AbelianGroup.Member subtract(AbelianGroup.Member f) {
        if (f instanceof ComplexFunction) {
            return this.subtract((ComplexFunction)f);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public ComplexFunction subtract(ComplexFunction f) {
        return new Difference(this, f);
    }

    @Override
    public Ring.Member multiply(Ring.Member f) {
        if (f instanceof ComplexFunction) {
            return this.multiply((ComplexFunction)f);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public ComplexFunction multiply(ComplexFunction f) {
        return new Product(this, f);
    }

    public Ring.Member inverse() {
        return new Reciprocal(this);
    }

    public Ring.Member divide(Ring.Member f) {
        if (f instanceof ComplexFunction) {
            return this.divide((ComplexFunction)f);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public ComplexFunction divide(ComplexFunction f) {
        return new Quotient(this, f);
    }

    public abstract ComplexFunction differentiate();

    public static ComplexFunction constant(Complex k) {
        return new Constant(k);
    }

    private static class Constant
    extends ComplexFunction {
        private final Complex A;

        public Constant(Complex A) {
            this.A = A;
        }

        @Override
        public Complex map(double x, double y) {
            return this.A;
        }

        @Override
        public Complex map(Complex z) {
            return this.A;
        }

        @Override
        public ComplexFunction differentiate() {
            return ZERO;
        }
    }

    private static class Quotient
    extends ComplexFunction {
        private final ComplexFunction f1;
        private final ComplexFunction f2;

        public Quotient(ComplexFunction f1, ComplexFunction f2) {
            this.f1 = f1;
            this.f2 = f2;
        }

        @Override
        public Complex map(double x, double y) {
            return this.f1.map(x, y).divide(this.f2.map(x, y));
        }

        @Override
        public Complex map(Complex z) {
            return this.f1.map(z).divide(this.f2.map(z));
        }

        @Override
        public ComplexFunction differentiate() {
            return new Quotient(new Difference(new Product(this.f1.differentiate(), this.f2), new Product(this.f1, this.f2.differentiate())), new Product(this.f2, this.f2));
        }
    }

    private static class Reciprocal
    extends ComplexFunction {
        private final ComplexFunction f;

        public Reciprocal(ComplexFunction f) {
            this.f = f;
        }

        @Override
        public Complex map(double x, double y) {
            return Complex.ONE.divide(this.f.map(x, y));
        }

        @Override
        public Complex map(Complex z) {
            return Complex.ONE.divide(this.f.map(z));
        }

        @Override
        public ComplexFunction differentiate() {
            return new Quotient(new Negation(this.f.differentiate()), new Product(this.f, this.f));
        }
    }

    private static class Product
    extends ComplexFunction {
        private final ComplexFunction f1;
        private final ComplexFunction f2;

        public Product(ComplexFunction f1, ComplexFunction f2) {
            this.f1 = f1;
            this.f2 = f2;
        }

        @Override
        public Complex map(double x, double y) {
            return this.f1.map(x, y).multiply(this.f2.map(x, y));
        }

        @Override
        public Complex map(Complex z) {
            return this.f1.map(z).multiply(this.f2.map(z));
        }

        @Override
        public ComplexFunction differentiate() {
            return new Sum(new Product(this.f1.differentiate(), this.f2), new Product(this.f1, this.f2.differentiate()));
        }
    }

    private static class Difference
    extends ComplexFunction {
        private final ComplexFunction f1;
        private final ComplexFunction f2;

        public Difference(ComplexFunction f1, ComplexFunction f2) {
            this.f1 = f1;
            this.f2 = f2;
        }

        @Override
        public Complex map(double x, double y) {
            return this.f1.map(x, y).subtract(this.f2.map(x, y));
        }

        @Override
        public Complex map(Complex z) {
            return this.f1.map(z).subtract(this.f2.map(z));
        }

        @Override
        public ComplexFunction differentiate() {
            return new Difference(this.f1.differentiate(), this.f2.differentiate());
        }
    }

    private static class Sum
    extends ComplexFunction {
        private final ComplexFunction f1;
        private final ComplexFunction f2;

        public Sum(ComplexFunction f1, ComplexFunction f2) {
            this.f1 = f1;
            this.f2 = f2;
        }

        @Override
        public Complex map(double x, double y) {
            return this.f1.map(x, y).add(this.f2.map(x, y));
        }

        @Override
        public Complex map(Complex z) {
            return this.f1.map(z).add(this.f2.map(z));
        }

        @Override
        public ComplexFunction differentiate() {
            return new Sum(this.f1.differentiate(), this.f2.differentiate());
        }
    }

    private static class Negation
    extends ComplexFunction {
        private final ComplexFunction f;

        public Negation(ComplexFunction f) {
            this.f = f;
        }

        @Override
        public Complex map(double x, double y) {
            return (Complex)this.f.map(x, y).negate();
        }

        @Override
        public Complex map(Complex z) {
            return (Complex)this.f.map(z).negate();
        }

        @Override
        public ComplexFunction differentiate() {
            return new Negation(this.f.differentiate());
        }
    }

    private static class Composition
    extends ComplexFunction {
        private final ComplexFunction f1;
        private final ComplexFunction f2;

        public Composition(ComplexFunction f1, ComplexFunction f2) {
            this.f1 = f1;
            this.f2 = f2;
        }

        @Override
        public Complex map(double x, double y) {
            return this.f1.map(this.f2.map(x, y));
        }

        @Override
        public Complex map(Complex z) {
            return this.f1.map(this.f2.map(z));
        }

        @Override
        public ComplexFunction differentiate() {
            return new Product(new Composition(this.f1.differentiate(), this.f2), this.f2.differentiate());
        }
    }
}

