/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths;

import jsci.maths.LinearMath;
import jsci.maths.MaximumIterationsExceededException;
import jsci.maths.matrices.DoubleSquareMatrix;
import jsci.maths.vectors.AbstractDoubleVector;
import jsci.maths.vectors.DoubleVector;

public final class KarhunenLoeve {
    double[][] data;

    public KarhunenLoeve(double[][] v) {
        this.setData(v);
    }

    public double[][] getProductMatrix() {
        return KarhunenLoeve.getProductMatrix(this.data);
    }

    private static double[][] vectorToSquare(double[] v) {
        double[][] ans = new double[v.length][v.length];
        for (int k = 0; k < v.length; ++k) {
            for (int l = 0; l < v.length; ++l) {
                ans[l][k] = v[k] * v[l];
            }
        }
        return ans;
    }

    private static void add(double[][] a, double c, double[][] b) {
        for (int k = 0; k < a.length; ++k) {
            for (int l = 0; l < a[k].length; ++l) {
                double[] dArray = a[k];
                int n = l;
                dArray[n] = dArray[n] + b[k][l] * c;
            }
        }
    }

    public static double[][] getProductMatrix(double[][] v) {
        double[][] ans = new double[v[0].length][v[0].length];
        for (int k = 0; k < v.length; ++k) {
            KarhunenLoeve.add(ans, 1.0 / (double)v.length, KarhunenLoeve.vectorToSquare(v[k]));
        }
        return ans;
    }

    public static double[][] getProductMatrix(double[] v) {
        return KarhunenLoeve.vectorToSquare(v);
    }

    public double[][] getData() {
        return this.data;
    }

    public void setData(double[][] v) {
        this.data = v;
    }

    public AbstractDoubleVector[] getEigenvectors() throws MaximumIterationsExceededException {
        double[][] test = KarhunenLoeve.getProductMatrix(this.data);
        DoubleSquareMatrix alpha = new DoubleSquareMatrix(test);
        AbstractDoubleVector[] beta = new DoubleVector[this.data[0].length];
        double[] eigen = LinearMath.eigenSolveSymmetric(alpha, beta);
        KarhunenLoeve.tri(eigen, beta);
        return beta;
    }

    public double[][] getEigenvectorArrays() throws MaximumIterationsExceededException {
        AbstractDoubleVector[] beta = this.getEigenvectors();
        double[][] ans = new double[beta.length][beta[0].dimension()];
        for (int k = 0; k < beta.length; ++k) {
            for (int l = 0; l < beta[k].dimension(); ++l) {
                ans[k][l] = beta[k].getComponent(l);
            }
        }
        return ans;
    }

    private static void tri(double[] v, AbstractDoubleVector[] mat) {
        boolean doitTrier = true;
        while (doitTrier) {
            doitTrier = false;
            for (int k = 0; k < v.length - 1; ++k) {
                if (!(v[k] < v[k + 1])) continue;
                double temp = v[k + 1];
                v[k + 1] = v[k];
                v[k] = temp;
                doitTrier = true;
                AbstractDoubleVector arraytemp = mat[k + 1];
                mat[k + 1] = mat[k];
                mat[k] = arraytemp;
            }
        }
    }
}

