/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.lang.reflect.Method;

public class Trace {
    private static boolean doneReflectionLookup = false;
    private static Method call1Method;
    private static Method call2Method;
    private static Method msgMethod;
    private static Method startMethod;
    private static Method stopMethod;

    public static void main(String[] args) {
        Trace.call1("hello");
        Trace.msg("hello there");
        Trace.call2("hello");
    }

    private static boolean checkReflection() {
        if (!doneReflectionLookup) {
            try {
                Class<?> c = Class.forName("ucar.unidata.util.Trace");
                call1Method = c.getDeclaredMethod("call1", String.class, String.class);
                call2Method = c.getDeclaredMethod("call2", String.class, String.class);
                msgMethod = c.getDeclaredMethod("msg", String.class);
                startMethod = c.getDeclaredMethod("startTrace", new Class[0]);
                stopMethod = c.getDeclaredMethod("stopTrace", new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            doneReflectionLookup = true;
        }
        return msgMethod != null;
    }

    public static void call1(String msg) {
        Trace.call1(msg, "");
    }

    public static void call1(String msg, String extra) {
        if (!Trace.checkReflection()) {
            return;
        }
        try {
            call1Method.invoke(null, msg, extra);
        }
        catch (Exception iae) {
            System.err.println("Trace.call1:" + iae);
        }
    }

    public static void startTrace() {
        if (!Trace.checkReflection()) {
            System.err.println("Could not start tracing");
            return;
        }
        try {
            startMethod.invoke(null, new Object[0]);
        }
        catch (Exception iae) {
            System.err.println("Trace.startTrace:" + iae);
        }
    }

    public static void stopTrace() {
        if (!Trace.checkReflection()) {
            System.err.println("Could not stop tracing");
            return;
        }
        try {
            stopMethod.invoke(null, new Object[0]);
        }
        catch (Exception iae) {
            System.err.println("Trace.stopTrace:" + iae);
        }
    }

    public static void call2(String msg) {
        Trace.call2(msg, "");
    }

    public static void call2(String msg, String extra) {
        if (!Trace.checkReflection()) {
            return;
        }
        try {
            call2Method.invoke(null, msg, extra);
        }
        catch (Exception iae) {
            System.err.println("Trace.call2:" + iae);
        }
    }

    public static void msg(String msg) {
        if (!Trace.checkReflection()) {
            return;
        }
        try {
            msgMethod.invoke(null, msg);
        }
        catch (Exception iae) {
            System.err.println("Trace.msg:" + iae);
        }
    }
}

