/*
 * Decompiled with CFR 0.152.
 */
package visad.java2d;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.lang.reflect.Constructor;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.MouseBehavior;
import visad.MouseHelper;
import visad.VisADError;
import visad.VisADRay;
import visad.java2d.DisplayRendererJ2D;
import visad.java2d.VisADCanvasJ2D;

public class MouseBehaviorJ2D
implements MouseBehavior {
    DisplayRendererJ2D display_renderer;
    DisplayImpl display;
    private MouseHelper helper = null;
    static final double EPS = 1.0E-6;

    public MouseBehaviorJ2D(DisplayRendererJ2D r) {
        this(r, MouseHelper.class);
    }

    public MouseBehaviorJ2D(DisplayRendererJ2D r, Class mhClass) {
        try {
            Class[] param = new Class[]{DisplayRenderer.class, MouseBehavior.class};
            Constructor mhConstructor = mhClass.getConstructor(param);
            this.helper = (MouseHelper)mhConstructor.newInstance(r, this);
        }
        catch (Exception e) {
            throw new VisADError("cannot construct " + mhClass);
        }
        this.display_renderer = r;
        this.display = this.display_renderer.getDisplay();
    }

    @Override
    public MouseHelper getMouseHelper() {
        return this.helper;
    }

    @Override
    public VisADRay findRay(int screen_x, int screen_y) {
        VisADCanvasJ2D canvas = this.display_renderer.getCanvas();
        AffineTransform trans = canvas.getTransform();
        if (trans == null) {
            return null;
        }
        double[] coords = new double[]{screen_x, screen_y};
        double[] newcoords = new double[2];
        try {
            trans.inverseTransform(coords, 0, newcoords, 0, 1);
        }
        catch (NoninvertibleTransformException e) {
            throw new VisADError("MouseBehaviorJ2D.findRay: non-invertable transform");
        }
        VisADRay ray = new VisADRay();
        ray.position[0] = newcoords[0];
        ray.position[1] = newcoords[1];
        ray.position[2] = 0.0;
        ray.vector[0] = 0.0;
        ray.vector[1] = 0.0;
        ray.vector[2] = -1.0;
        return ray;
    }

    @Override
    public VisADRay cursorRay(double[] cursor) {
        VisADRay ray = new VisADRay();
        ray.position[0] = cursor[0];
        ray.position[1] = cursor[1];
        ray.position[2] = 0.0;
        ray.vector[0] = 0.0;
        ray.vector[1] = 0.0;
        ray.vector[2] = -1.0;
        return ray;
    }

    @Override
    public int[] getScreenCoords(double[] position) {
        VisADCanvasJ2D canvas = this.display_renderer.getCanvas();
        AffineTransform trans = canvas.getTransform();
        if (trans == null) {
            return null;
        }
        double[] newcoords = new double[2];
        trans.transform(position, 0, newcoords, 0, 1);
        int[] coords = new int[2];
        for (int i = 0; i < 2; ++i) {
            coords[i] = (int)newcoords[i];
        }
        return coords;
    }

    @Override
    public double[] make_translate(double transx, double transy, double transz) {
        return this.make_matrix(0.0, 0.0, 0.0, 1.0, transx, -transy, transz);
    }

    @Override
    public double[] make_translate(double transx, double transy) {
        return this.make_translate(transx, transy, 0.0);
    }

    @Override
    public double[] multiply_matrix(double[] a, double[] b) {
        AffineTransform ta = new AffineTransform(a);
        AffineTransform tb = new AffineTransform(b);
        ta.concatenate(tb);
        double[] c = new double[6];
        ta.getMatrix(c);
        return c;
    }

    @Override
    public double[] make_matrix(double rotx, double roty, double rotz, double scale, double transx, double transy, double transz) {
        return this.make_matrix(rotx, roty, rotz, scale, scale, scale, transx, transy, transz);
    }

    @Override
    public double[] make_matrix(double rotx, double roty, double rotz, double scalex, double scaley, double scalez, double transx, double transy, double transz) {
        double t;
        int i;
        double deg2rad = 0.017453316741046887;
        double[] matrix = new double[6];
        double[][] mat = new double[4][4];
        double sx = Math.sin(rotx * deg2rad);
        double cx = Math.cos(rotx * deg2rad);
        double sy = Math.sin(roty * deg2rad);
        double cy = Math.cos(roty * deg2rad);
        double sz = Math.sin(rotz * deg2rad);
        double cz = Math.cos(rotz * deg2rad);
        mat[0][0] = 1.0;
        mat[0][1] = 0.0;
        mat[0][2] = 0.0;
        mat[0][3] = 0.0;
        mat[1][0] = 0.0;
        mat[1][1] = 1.0;
        mat[1][2] = 0.0;
        mat[1][3] = 0.0;
        mat[2][0] = 0.0;
        mat[2][1] = 0.0;
        mat[2][2] = 1.0;
        mat[2][3] = 0.0;
        mat[3][0] = 0.0;
        mat[3][1] = 0.0;
        mat[3][2] = 0.0;
        mat[3][3] = 1.0;
        for (i = 0; i < 4; ++i) {
            t = mat[i][0];
            mat[i][0] = t * cz - mat[i][1] * sz;
            mat[i][1] = t * sz + mat[i][1] * cz;
        }
        for (i = 0; i < 4; ++i) {
            t = mat[i][1];
            mat[i][1] = t * cx - mat[i][2] * sx;
            mat[i][2] = t * sx + mat[i][2] * cx;
        }
        for (i = 0; i < 4; ++i) {
            t = mat[i][0];
            mat[i][0] = mat[i][2] * sy + t * cy;
            mat[i][2] = mat[i][2] * cy - t * sy;
        }
        for (i = 0; i < 3; ++i) {
            double[] dArray = mat[i];
            dArray[0] = dArray[0] * scalex;
            double[] dArray2 = mat[i];
            dArray2[1] = dArray2[1] * scaley;
            double[] dArray3 = mat[i];
            dArray3[2] = dArray3[2] * scalez;
        }
        mat[0][3] = transx;
        mat[1][3] = transy;
        mat[2][3] = transz;
        matrix[0] = mat[0][0];
        matrix[1] = mat[1][0];
        matrix[2] = mat[0][1];
        matrix[3] = mat[1][1];
        matrix[4] = mat[0][3];
        matrix[5] = mat[1][3];
        return matrix;
    }

    @Override
    public void instance_unmake_matrix(double[] rot, double[] scale, double[] trans, double[] matrix) {
        double cz;
        double sz;
        double cy;
        double sy;
        double cx;
        double cxb;
        int i;
        double[][] mat = new double[4][4];
        double[][] nat = new double[4][4];
        double[] scaleinv = new double[3];
        if (rot == null || rot.length != 3) {
            return;
        }
        if (scale == null || scale.length == 1 && scale.length == 3) {
            return;
        }
        if (trans == null || trans.length != 3) {
            return;
        }
        if (matrix == null || matrix.length != 6) {
            return;
        }
        mat[0][0] = 1.0;
        mat[0][1] = 0.0;
        mat[0][2] = 0.0;
        mat[0][3] = 0.0;
        mat[1][0] = 0.0;
        mat[1][1] = 1.0;
        mat[1][2] = 0.0;
        mat[1][3] = 0.0;
        mat[2][0] = 0.0;
        mat[2][1] = 0.0;
        mat[2][2] = 1.0;
        mat[2][3] = 0.0;
        mat[3][0] = 0.0;
        mat[3][1] = 0.0;
        mat[3][2] = 0.0;
        mat[3][3] = 1.0;
        mat[0][0] = matrix[0];
        mat[1][0] = matrix[1];
        mat[0][1] = matrix[2];
        mat[1][1] = matrix[3];
        mat[0][3] = matrix[4];
        mat[1][3] = matrix[5];
        trans[0] = mat[0][3];
        trans[1] = mat[1][3];
        trans[2] = mat[2][3];
        double scalez = 0.0;
        double scaley = 0.0;
        double scalex = 0.0;
        for (i = 0; i < 3; ++i) {
            scalex += mat[0][i] * mat[0][i];
            scaley += mat[1][i] * mat[1][i];
            scalez += mat[2][i] * mat[2][i];
        }
        if (Math.abs(scalex - scaley) > 1.0E-6 || Math.abs(scalex - scalez) > 1.0E-6) {
            // empty if block
        }
        if (scale.length == 1) {
            scale[0] = Math.sqrt((scalex + scaley + scalez) / 3.0);
            scaleinv[0] = Math.abs(scale[0]) > 1.0E-6 ? 1.0 / scale[0] : 1000000.0;
            scaleinv[1] = scaleinv[2] = scaleinv[0];
        } else {
            scale[0] = Math.sqrt(scalex);
            scale[1] = Math.sqrt(scaley);
            scale[2] = Math.sqrt(scalez);
            for (i = 0; i < 3; ++i) {
                scaleinv[i] = Math.abs(scale[i]) > 1.0E-6 ? 1.0 / scale[i] : 1000000.0;
            }
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                nat[j][i] = scaleinv[j] * mat[j][i];
            }
        }
        double sx = -nat[2][1];
        double cxa = Math.sqrt(nat[2][0] * nat[2][0] + nat[2][2] * nat[2][2]);
        if (Math.abs(cxa - (cxb = Math.sqrt(nat[0][1] * nat[0][1] + nat[1][1] * nat[1][1]))) > 1.0E-6) {
            // empty if block
        }
        if (Math.abs(cx = (cxa + cxb) / 2.0) > 1.0E-6) {
            double cxinv = 1.0 / cx;
            sy = nat[2][0] * cxinv;
            cy = nat[2][2] * cxinv;
            sz = nat[0][1] * cxinv;
            cz = nat[1][1] * cxinv;
        } else {
            sy = 0.0;
            cy = 1.0;
            sz = nat[0][2];
            cz = nat[1][2];
        }
        rot[0] = 57.2957 * Math.atan2(sx, cx);
        rot[1] = 57.2957 * Math.atan2(sy, cy);
        rot[2] = 57.2957 * Math.atan2(sz, cz);
    }
}

