/*
 * Decompiled with CFR 0.152.
 */
package visad.java2d;

import java.rmi.RemoteException;
import visad.BadDirectManipulationException;
import visad.Data;
import visad.DataDisplayLink;
import visad.Display;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.VisADAppearance;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADGroup;
import visad.VisADLineArray;
import visad.VisADPointArray;
import visad.collab.CollabUtil;
import visad.java2d.DisplayRendererJ2D;
import visad.java2d.RendererJ2D;
import visad.java2d.ShadowTypeJ2D;

public class DirectManipulationRendererJ2D
extends RendererJ2D {
    VisADGroup branch = null;
    VisADGroup extra_branch = null;

    @Override
    public void setLinks(DataDisplayLink[] links, DisplayImpl d) throws VisADException {
        if (links == null || links.length != 1) {
            throw new DisplayException("DirectManipulationRendererJ2D.setLinks: must be exactly one DataDisplayLink");
        }
        super.setLinks(links, d);
    }

    @Override
    public void checkDirect() throws VisADException, RemoteException {
        this.realCheckDirect();
    }

    @Override
    public void addPoint(float[] x) throws VisADException {
        int count = x.length / 3;
        VisADGeometryArray array = null;
        if (count == 1) {
            array = new VisADPointArray();
        } else if (count == 2) {
            array = new VisADLineArray();
        } else {
            return;
        }
        array.coordinates = x;
        array.vertexCount = count;
        VisADAppearance appearance = new VisADAppearance();
        DataDisplayLink[] Links = this.getLinks();
        if (Links == null || Links.length == 0) {
            return;
        }
        DataDisplayLink link = Links[0];
        float[] default_values = link.getDefaultValues();
        DisplayImpl display = this.getDisplay();
        appearance.pointSize = default_values[display.getDisplayScalarIndex(Display.PointSize)];
        appearance.lineWidth = default_values[display.getDisplayScalarIndex(Display.LineWidth)];
        appearance.lineStyle = (int)default_values[display.getDisplayScalarIndex(Display.LineStyle)];
        appearance.red = 1.0f;
        appearance.green = 1.0f;
        appearance.blue = 1.0f;
        appearance.array = array;
        this.extra_branch.addChild(appearance);
    }

    public VisADGroup getExtraBranch() {
        return this.extra_branch;
    }

    @Override
    public synchronized VisADGroup doTransform() throws VisADException, RemoteException {
        Data data;
        this.branch = new VisADGroup();
        this.extra_branch = new VisADGroup();
        DataDisplayLink[] Links = this.getLinks();
        if (Links == null || Links.length == 0) {
            return null;
        }
        DataDisplayLink link = Links[0];
        ShadowTypeJ2D shadow = (ShadowTypeJ2D)link.getShadow();
        if (!this.getIsDirectManipulation()) {
            throw new BadDirectManipulationException(this.getWhyNotDirect() + ": DirectManipulationRendererJ2D.doTransform");
        }
        int valueArrayLength = this.getDisplay().getValueArrayLength();
        float[] valueArray = new float[valueArrayLength];
        for (int i = 0; i < valueArrayLength; ++i) {
            valueArray[i] = Float.NaN;
        }
        try {
            data = link.getData();
        }
        catch (RemoteException re) {
            if (CollabUtil.isDisconnectException(re)) {
                this.getDisplay().connectionFailed(this, link);
                this.removeLink(link);
                return null;
            }
            throw re;
        }
        if (data == null) {
            this.branch = null;
            this.extra_branch = null;
            this.addException(new DisplayException("Data is null: DirectManipulationRendererJ2D.doTransform"));
        } else {
            try {
                shadow.doTransform(this.branch, data, valueArray, link.getDefaultValues(), this);
            }
            catch (RemoteException re) {
                if (CollabUtil.isDisconnectException(re)) {
                    this.getDisplay().connectionFailed(this, link);
                    this.removeLink(link);
                    return null;
                }
                throw re;
            }
        }
        return this.branch;
    }

    @Override
    void addSwitch(DisplayRendererJ2D displayRenderer, VisADGroup branch) throws VisADException {
        displayRenderer.addDirectManipulationSceneGraphComponent(branch, this);
    }

    @Override
    public boolean isLegalTextureMap() {
        return false;
    }

    @Override
    public Object clone() {
        return new DirectManipulationRendererJ2D();
    }
}

