/*
 * Decompiled with CFR 0.152.
 */
package visad.georef;

import java.awt.geom.Rectangle2D;
import visad.Gridded2DSet;
import visad.Linear2DSet;
import visad.Set;
import visad.SetType;
import visad.VisADException;
import visad.georef.MapProjection;

public class LongitudeLatitudeInterpCS
extends MapProjection {
    Linear2DSet domainSet;
    Linear2DSet transSet;
    Gridded2DSet lonlatSet;
    boolean neg180pos180 = true;
    boolean extNeg180pos180 = false;
    int lonIdx = 0;

    public LongitudeLatitudeInterpCS(Linear2DSet domainSet, Gridded2DSet lonlatSet, boolean neg180pos180) throws VisADException {
        super(((SetType)domainSet.getType()).getDomain(), null);
        this.lonlatSet = lonlatSet;
        this.domainSet = domainSet;
        this.neg180pos180 = neg180pos180;
        int[] lengths = domainSet.getLengths();
        int[] gsetLens = lonlatSet.getLengths();
        this.transSet = new Linear2DSet(0.0, gsetLens[0] - 1, lengths[0], 0.0, gsetLens[1] - 1, lengths[1]);
        this.lonIdx = this.getLongitudeIndex();
    }

    public LongitudeLatitudeInterpCS(Linear2DSet domainSet, Gridded2DSet lonlatSet) throws VisADException {
        this(domainSet, lonlatSet, true);
    }

    @Override
    public float[][] toReference(float[][] values) throws VisADException {
        float[][] lonlat;
        block4: {
            float[][] coords = this.domainSet.valueToGrid(values);
            coords = this.transSet.gridToValue(coords);
            lonlat = this.lonlatSet.gridToValue(coords);
            if (this.neg180pos180 && this.extNeg180pos180) break block4;
            if (this.neg180pos180) {
                for (int t = 0; t < lonlat[this.lonIdx].length; ++t) {
                    if (!(lonlat[this.lonIdx][t] > 180.0f)) continue;
                    float[] fArray = lonlat[this.lonIdx];
                    int n = t;
                    fArray[n] = fArray[n] - 360.0f;
                }
            } else {
                for (int t = 0; t < lonlat[this.lonIdx].length; ++t) {
                    if (!(lonlat[this.lonIdx][t] < 180.0f)) continue;
                    float[] fArray = lonlat[this.lonIdx];
                    int n = t;
                    fArray[n] = fArray[n] + 360.0f;
                }
            }
        }
        return lonlat;
    }

    @Override
    public double[][] toReference(double[][] values) throws VisADException {
        return Set.floatToDouble(this.toReference(Set.doubleToFloat(values)));
    }

    @Override
    public float[][] fromReference(float[][] lonlat) throws VisADException {
        if (!this.neg180pos180 || !this.extNeg180pos180) {
            int t;
            if (this.neg180pos180) {
                for (t = 0; t < lonlat[this.lonIdx].length; ++t) {
                    if (!(lonlat[this.lonIdx][t] > 180.0f)) continue;
                    float[] fArray = lonlat[this.lonIdx];
                    int n = t;
                    fArray[n] = fArray[n] - 360.0f;
                }
            } else {
                for (t = 0; t < lonlat[this.lonIdx].length; ++t) {
                    if (!(lonlat[this.lonIdx][t] < 180.0f)) continue;
                    float[] fArray = lonlat[this.lonIdx];
                    int n = t;
                    fArray[n] = fArray[n] + 360.0f;
                }
            }
        }
        float[][] grid_vals = this.lonlatSet.valueToGrid(lonlat);
        float[][] coords = this.transSet.valueToGrid(grid_vals);
        coords = this.domainSet.gridToValue(coords);
        return coords;
    }

    @Override
    public double[][] fromReference(double[][] lonlat) throws VisADException {
        return Set.floatToDouble(this.fromReference(Set.doubleToFloat(lonlat)));
    }

    public void setExternalLongitudeRange(boolean isExtNeg180pos180) {
        this.extNeg180pos180 = isExtNeg180pos180;
    }

    @Override
    public Rectangle2D getDefaultMapArea() {
        float[] lo = this.domainSet.getLow();
        float[] hi = this.domainSet.getHi();
        return new Rectangle2D.Float(lo[0], lo[1], hi[0] - lo[0], hi[1] - lo[1]);
    }

    public Linear2DSet getDomainSet() {
        return this.domainSet;
    }

    public Gridded2DSet getLonLatSet() {
        return this.lonlatSet;
    }

    public boolean getIsNeg180pos180() {
        return this.neg180pos180;
    }

    public void setIsExtNeg180pos180(boolean yesno) {
        this.extNeg180pos180 = yesno;
    }

    public boolean getIsExtNeg180pos180() {
        return this.extNeg180pos180;
    }

    @Override
    public boolean equals(Object cs) {
        if (!(cs instanceof LongitudeLatitudeInterpCS)) {
            return false;
        }
        LongitudeLatitudeInterpCS that = (LongitudeLatitudeInterpCS)cs;
        if (that.getDomainSet().equals(this.domainSet) && that.getLonLatSet().equals(this.lonlatSet)) {
            return true;
        }
        return that.getIsNeg180pos180() == this.neg180pos180 && that.getIsExtNeg180pos180() == this.extNeg180pos180;
    }
}

