/*
 * Decompiled with CFR 0.152.
 */
package visad.data.text;

import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import visad.Data;
import visad.DataImpl;
import visad.UnimplementedException;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.Form;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.data.text.TextAdapter;

public class TextForm
extends Form
implements FormFileInformer {
    public TextForm() {
        super("TextForm");
    }

    @Override
    public boolean isThisType(String name) {
        return name.endsWith(".csv") || name.endsWith(".CSV") || name.endsWith(".tsv") || name.endsWith(".TSV") || name.endsWith(".txt") || name.endsWith(".TXT") || name.endsWith(".bsv") || name.endsWith(".BSV");
    }

    @Override
    public boolean isThisType(byte[] block) {
        return false;
    }

    @Override
    public String[] getDefaultSuffixes() {
        String[] suff = new String[]{"csv", "tsv", "txt", "bsv"};
        return suff;
    }

    @Override
    public synchronized void save(String id, Data data, boolean replace) throws BadFormException, IOException, RemoteException, VisADException {
        throw new UnimplementedException("Can't yet save Text objects");
    }

    @Override
    public synchronized void add(String id, Data data, boolean replace) throws BadFormException {
        throw new RuntimeException("Can't yet add Text objects");
    }

    @Override
    public synchronized DataImpl open(String path) throws BadFormException, RemoteException, VisADException {
        try {
            return (DataImpl)((Object)new TextAdapter(path).getData());
        }
        catch (IOException e) {
            throw new VisADException("IOException: " + e.getMessage());
        }
    }

    @Override
    public synchronized DataImpl open(URL url) throws BadFormException, VisADException, IOException {
        TextAdapter csva = new TextAdapter(url);
        return (DataImpl)((Object)csva.getData());
    }

    @Override
    public synchronized FormNode getForms(Data data) {
        throw new RuntimeException("Can't yet get Text File forms");
    }
}

