/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf.in;

import java.io.IOException;
import java.rmi.RemoteException;
import visad.DataImpl;
import visad.FunctionType;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.SetType;
import visad.VisADException;
import visad.data.netcdf.in.Context;
import visad.data.netcdf.in.DataFactory;
import visad.data.netcdf.in.VirtualData;
import visad.data.netcdf.in.VirtualFlatField;
import visad.data.netcdf.in.VirtualTuple;

public class VirtualField
extends VirtualData {
    private final FunctionType functionType;
    private final SampledSet domainSet;
    private final VirtualTuple rangeTuple;

    protected VirtualField(FunctionType funcType, SampledSet domainSet, VirtualTuple rangeTuple) {
        this.functionType = funcType;
        this.domainSet = domainSet;
        this.rangeTuple = rangeTuple;
    }

    public static VirtualField newVirtualField(SampledSet domainSet, VirtualTuple rangeTuple) throws VisADException {
        return VirtualField.newVirtualField(new FunctionType(((SetType)domainSet.getType()).getDomain(), rangeTuple.getType()), domainSet, rangeTuple);
    }

    public static VirtualField newVirtualField(FunctionType funcType, SampledSet domainSet, VirtualTuple rangeTuple) {
        MathType rangeType = funcType.getRange();
        return rangeType instanceof RealType || rangeType instanceof RealTupleType ? new VirtualFlatField(funcType, domainSet, rangeTuple) : new VirtualField(funcType, domainSet, rangeTuple);
    }

    public FunctionType getFunctionType() {
        return this.functionType;
    }

    @Override
    public MathType getType() {
        return this.getFunctionType();
    }

    public SampledSet getDomainSet() {
        return this.domainSet;
    }

    public VirtualTuple getRangeTuple() {
        return this.rangeTuple;
    }

    @Override
    public DataImpl getData(Context context) throws VisADException, RemoteException, IOException {
        return this.getDataFactory().newData(context, this);
    }

    @Override
    public Object clone() {
        return new VirtualField(this.functionType, this.domainSet, (VirtualTuple)this.rangeTuple.clone());
    }

    @Override
    public void setDataFactory(DataFactory factory) {
        this.rangeTuple.setDataFactory(factory);
    }

    @Override
    public DataFactory getDataFactory() {
        return this.rangeTuple.getDataFactory();
    }
}

