/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf.in;

import java.io.IOException;
import java.rmi.RemoteException;
import visad.Data;
import visad.FlatField;
import visad.FunctionType;
import visad.VisADException;
import visad.data.CacheStrategy;
import visad.data.FileAccessor;
import visad.data.FileFlatField;
import visad.data.netcdf.in.Context;
import visad.data.netcdf.in.DataFactory;
import visad.data.netcdf.in.VirtualField;
import visad.data.netcdf.in.VirtualFlatField;

public class FileDataFactory
extends DataFactory {
    private static FileDataFactory instance;
    private static CacheStrategy cacheStrategy;

    private FileDataFactory() {
    }

    public static DataFactory instance() {
        return instance;
    }

    @Override
    public FlatField newData(Context context, VirtualFlatField virtualField) throws VisADException, RemoteException, IOException {
        return new FileFlatField(new netCDFFlatFieldAccessor(context, virtualField), cacheStrategy);
    }

    static {
        cacheStrategy = new CacheStrategy();
        instance = new FileDataFactory();
    }

    protected class netCDFFlatFieldAccessor
    extends FileAccessor {
        private Context context;
        private VirtualField virtualField;

        public netCDFFlatFieldAccessor(Context context, VirtualField virtualField) {
            this.context = (Context)context.clone();
            this.virtualField = virtualField;
        }

        @Override
        public FlatField getFlatField() throws VisADException, RemoteException {
            try {
                return (FlatField)DataFactory.instance().newData(this.context, this.virtualField);
            }
            catch (RemoteException e) {
                throw e;
            }
            catch (IOException e) {
                throw new RemoteException(e.getMessage());
            }
        }

        @Override
        public FunctionType getFunctionType() {
            return this.virtualField.getFunctionType();
        }

        @Override
        public double[][] readFlatField(FlatField template, int[] fileLocation) {
            return null;
        }

        @Override
        public void writeFile(int[] fileLocation, Data range) {
        }

        @Override
        public void writeFlatField(double[][] values, FlatField template, int[] fileLocation) {
        }
    }
}

