/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import visad.BadMappingException;
import visad.DataDisplayLink;
import visad.DisplayTupleType;
import visad.MathType;
import visad.RealTupleType;
import visad.ShadowRealType;
import visad.ShadowTupleType;
import visad.ShadowType;
import visad.VisADException;

public class ShadowRealTupleType
extends ShadowTupleType {
    private ShadowRealTupleType Reference;
    private boolean allSpatial = true;
    private boolean allSpatialReference = false;
    private DisplayTupleType DisplaySpatialTuple = null;
    private boolean spatialReference = false;
    private int[] permutation;

    public ShadowRealTupleType(MathType t, DataDisplayLink link, ShadowType parent, ShadowType[] tcs, ShadowType adapter) throws VisADException, RemoteException {
        super(t, link, parent, tcs);
        for (int j = 0; j < this.tupleComponents.length; ++j) {
            ShadowRealType real = (ShadowRealType)this.tupleComponents[j];
            this.MappedDisplayScalar |= real.getMappedDisplayScalar();
            DisplayTupleType tuple = real.getDisplaySpatialTuple();
            int[] index = real.getDisplaySpatialTupleIndex();
            if (tuple != null) {
                int k;
                if (this.DisplaySpatialTuple != null) {
                    if (tuple.equals(this.DisplaySpatialTuple)) {
                        for (k = 0; k < 3 && index[k] >= 0; ++k) {
                            if (this.permutation[index[k]] >= 0) {
                                this.allSpatial = false;
                                continue;
                            }
                            this.permutation[index[k]] = j;
                        }
                        continue;
                    }
                    throw new BadMappingException("mapped to multiple spatial DisplayTupleType-s: ShadowRealTupleType");
                }
                this.DisplaySpatialTuple = tuple;
                this.permutation = new int[tuple.getDimension()];
                for (int i = 0; i < tuple.getDimension(); ++i) {
                    this.permutation[i] = -1;
                }
                for (k = 0; k < 3 && index[k] >= 0; ++k) {
                    this.permutation[index[k]] = j;
                }
                continue;
            }
            this.allSpatial = false;
        }
        if (((RealTupleType)this.Type).getCoordinateSystem() != null) {
            RealTupleType ref = ((RealTupleType)this.Type).getCoordinateSystem().getReference();
            this.Reference = (ShadowRealTupleType)ref.buildShadowType(this.Link, adapter).getAdaptedShadowType();
            DisplayTupleType tuple = this.Reference.getDisplaySpatialTuple();
            this.DisplayIndices = ShadowRealTupleType.addIndices(this.DisplayIndices, this.Reference.getDisplayIndices());
            this.ValueIndices = ShadowRealTupleType.addIndices(this.ValueIndices, this.Reference.getValueIndices());
            if (tuple != null) {
                if (this.DisplaySpatialTuple != null) {
                    if (!this.DisplaySpatialTuple.equals(tuple)) {
                        throw new BadMappingException("mapped to multiple spatial DisplayTupleType-s (through CoordinateSystem.Reference): ShadowRealTupleType");
                    }
                    this.allSpatial = false;
                } else {
                    this.DisplaySpatialTuple = tuple;
                    this.spatialReference = true;
                    this.allSpatialReference = this.allSpatial = this.Reference.getAllSpatial();
                    this.permutation = this.Reference.getPermutation();
                }
            }
            this.MultipleDisplayScalar |= this.MappedDisplayScalar && this.Reference.getMappedDisplayScalar() || this.Reference.getMultipleDisplayScalar();
            this.MappedDisplayScalar |= this.Reference.getMappedDisplayScalar();
        } else {
            this.Reference = null;
        }
    }

    public int[] getPermutation() {
        int[] ii = new int[this.permutation.length];
        for (int i = 0; i < this.permutation.length; ++i) {
            ii[i] = this.permutation[i];
        }
        return ii;
    }

    public boolean getAllSpatial() {
        return this.allSpatial;
    }

    public DisplayTupleType getDisplaySpatialTuple() {
        return this.DisplaySpatialTuple;
    }

    @Override
    public boolean getMappedDisplayScalar() {
        return this.MappedDisplayScalar;
    }

    public boolean getSpatialReference() {
        return this.spatialReference;
    }

    public ShadowRealTupleType getReference() {
        return this.Reference;
    }
}

