/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import java.util.Arrays;
import visad.BaseUnit;
import visad.DerivedUnit;
import visad.LogarithmicUnit;
import visad.OffsetUnit;
import visad.PromiscuousUnit;
import visad.Unit;
import visad.UnitException;

public final class ScaledUnit
extends Unit
implements Serializable {
    private static final long serialVersionUID = 1L;
    final double amount;
    final Unit underUnit;

    public ScaledUnit(double amount) {
        this(amount, "");
    }

    public ScaledUnit(double amount, String identifier) {
        super(identifier);
        this.amount = amount;
        this.underUnit = new DerivedUnit();
    }

    public ScaledUnit(double amount, Unit unit) {
        this(amount, unit, null);
    }

    public ScaledUnit(double amount, Unit unit, String identifier) {
        super(identifier != null ? identifier : (amount == 1.0 ? unit.getIdentifier() : null));
        if (unit instanceof ScaledUnit) {
            ScaledUnit that = (ScaledUnit)unit;
            this.amount = amount * that.amount;
            this.underUnit = that.underUnit;
        } else {
            this.amount = amount;
            this.underUnit = unit;
        }
    }

    public ScaledUnit(double amount, BaseUnit unit) {
        this(amount, (Unit)unit);
    }

    public ScaledUnit(double amount, BaseUnit unit, String id) {
        this(amount, (Unit)unit, id);
    }

    public ScaledUnit(double amount, DerivedUnit unit) {
        this(amount, (Unit)unit);
    }

    public ScaledUnit(double amount, DerivedUnit unit, String id) {
        this(amount, (Unit)unit, id);
    }

    public static ScaledUnit create(double amount, Unit unit) throws UnitException {
        return amount == 1.0 && unit instanceof ScaledUnit ? (ScaledUnit)unit : new ScaledUnit(amount, unit);
    }

    static Unit getInstance(double amount, Unit unit) throws UnitException {
        if (amount == 0.0) {
            throw new IllegalArgumentException("Zero amount argument");
        }
        return amount == 1.0 ? unit : new ScaledUnit(amount, unit);
    }

    @Override
    public boolean isDimensionless() {
        return this.underUnit.isDimensionless();
    }

    @Override
    protected Unit protectedClone(String identifier) {
        return new ScaledUnit(this.amount, this.underUnit, identifier);
    }

    @Override
    public Unit scale(double amount) throws UnitException {
        return ScaledUnit.getInstance(amount * this.amount, this.underUnit);
    }

    @Override
    public Unit shift(double offset) throws UnitException {
        return OffsetUnit.getInstance(offset, this);
    }

    @Override
    public Unit log(double base) {
        return LogarithmicUnit.getInstance(base, this);
    }

    @Override
    public Unit pow(int power) throws UnitException {
        return new ScaledUnit(Math.pow(this.amount, power), this.underUnit.pow(power));
    }

    @Override
    public Unit pow(double power) throws IllegalArgumentException, UnitException {
        return new ScaledUnit(Math.pow(this.amount, power), this.underUnit.pow(power));
    }

    @Override
    public Unit root(int root) throws IllegalArgumentException, UnitException {
        return new ScaledUnit(Math.pow(this.amount, 1.0 / (double)root), this.underUnit.root(root));
    }

    @Override
    public String getDefinition() {
        String definition;
        if (this.underUnit == null) {
            definition = "<unconstructed ScaledUnit>";
        } else {
            String derivedString = this.underUnit.toString();
            definition = this.amount == 1.0 ? derivedString : (derivedString.length() == 0 ? Double.toString(this.amount) : Double.toString(this.amount) + " " + derivedString);
        }
        return definition;
    }

    public double getAmount() {
        return this.amount;
    }

    public Unit getUnit() {
        return this.underUnit;
    }

    @Override
    public Unit multiply(Unit that) throws UnitException {
        return ScaledUnit.create(this.amount, this.underUnit.multiply(that));
    }

    @Override
    public Unit divide(Unit that) throws UnitException {
        return ScaledUnit.create(this.amount, this.underUnit.divide(that));
    }

    @Override
    protected Unit divideInto(Unit that) throws UnitException {
        return ScaledUnit.create(1.0 / this.amount, this.underUnit.divideInto(that));
    }

    @Override
    public double[] toThis(double[] values, Unit that) throws UnitException {
        return this.toThis(values, that, true);
    }

    @Override
    public float[] toThis(float[] values, Unit that) throws UnitException {
        return this.toThis(values, that, true);
    }

    @Override
    public double[] toThis(double[] values, Unit that, boolean copy) throws UnitException {
        double[] newValues;
        if (this.equals(that) || that instanceof PromiscuousUnit) {
            newValues = copy ? (double[])values.clone() : values;
        } else {
            newValues = that.toThat(values, this.underUnit, copy);
            for (int i = 0; i < newValues.length; ++i) {
                if (newValues[i] != newValues[i]) continue;
                int n = i;
                newValues[n] = newValues[n] / this.amount;
            }
        }
        return newValues;
    }

    @Override
    public float[] toThis(float[] values, Unit that, boolean copy) throws UnitException {
        float[] newValues;
        if (this.equals(that) || that instanceof PromiscuousUnit) {
            newValues = copy ? (float[])values.clone() : values;
        } else {
            newValues = that.toThat(values, this.underUnit, copy);
            for (int i = 0; i < newValues.length; ++i) {
                if (newValues[i] != newValues[i]) continue;
                int n = i;
                newValues[n] = (float)((double)newValues[n] / this.amount);
            }
        }
        return newValues;
    }

    @Override
    public double[] toThat(double[] values, Unit that) throws UnitException {
        return this.toThat(values, that, true);
    }

    @Override
    public float[] toThat(float[] values, Unit that) throws UnitException {
        return this.toThat(values, that, true);
    }

    @Override
    public double[] toThat(double[] values, Unit that, boolean copy) throws UnitException {
        double[] newValues;
        double[] dArray = newValues = copy ? (double[])values.clone() : values;
        if (!this.equals(that) && !(that instanceof PromiscuousUnit)) {
            int i = 0;
            while (i < newValues.length) {
                int n = i++;
                newValues[n] = newValues[n] * this.amount;
            }
            newValues = that.toThis(newValues, this.underUnit);
        }
        return newValues;
    }

    @Override
    public float[] toThat(float[] values, Unit that, boolean copy) throws UnitException {
        float[] newValues;
        float[] fArray = newValues = copy ? (float[])values.clone() : values;
        if (!this.equals(that) && !(that instanceof PromiscuousUnit)) {
            int i = 0;
            while (i < newValues.length) {
                int n = i++;
                newValues[n] = (float)((double)newValues[n] * this.amount);
            }
            newValues = that.toThis(newValues, this.underUnit);
        }
        return newValues;
    }

    @Override
    public boolean isConvertible(Unit unit) {
        return unit == null ? false : this.underUnit.isConvertible(unit);
    }

    private static void myAssert(boolean assertion) {
        if (!assertion) {
            throw new AssertionError();
        }
    }

    private static void myAssert(Unit have, Unit expect) {
        if (!have.equals(expect)) {
            throw new AssertionError((Object)(have.toString() + " != " + expect));
        }
    }

    private static void myAssert(double have, double expect) {
        if (have != expect) {
            throw new AssertionError((Object)("" + have + " != " + expect));
        }
    }

    private static void myAssert(double[] have, double[] expect) {
        if (!Arrays.equals(have, expect)) {
            throw new AssertionError((Object)("" + have + " != " + expect));
        }
    }

    public static void main(String[] args) throws UnitException {
        BaseUnit meter = BaseUnit.addBaseUnit("Length", "meter");
        BaseUnit second = BaseUnit.addBaseUnit("Time", "second");
        DerivedUnit meterPerSec = new DerivedUnit(new BaseUnit[]{meter, second}, new int[]{1, -1});
        ScaledUnit milePerHour = new ScaledUnit(0.44704, meterPerSec);
        Unit milePerHour2 = ((Unit)milePerHour).pow(2);
        ScaledUnit.myAssert(milePerHour, milePerHour);
        ScaledUnit.myAssert(!((Unit)milePerHour).equals(meterPerSec));
        ScaledUnit.myAssert(((Unit)milePerHour).isConvertible(milePerHour));
        ScaledUnit.myAssert(((Unit)milePerHour).isConvertible(meterPerSec));
        ScaledUnit.myAssert(!((Unit)milePerHour).equals(milePerHour2));
        ScaledUnit.myAssert(!((Unit)milePerHour).isConvertible(milePerHour2));
        ScaledUnit.myAssert(!((Unit)milePerHour).equals(meter));
        ScaledUnit.myAssert(!((Unit)milePerHour).isConvertible(meter));
        ScaledUnit.myAssert(milePerHour2, milePerHour2);
        ScaledUnit.myAssert(milePerHour2.isConvertible(milePerHour2));
        ScaledUnit.myAssert(milePerHour2.sqrt(), milePerHour);
        BaseUnit kg = BaseUnit.addBaseUnit("Mass", "kilogram");
        DerivedUnit kgPerSec = new DerivedUnit(new BaseUnit[]{kg, second}, new int[]{1, -1});
        ScaledUnit poundPerSec = new ScaledUnit(0.453592, kgPerSec);
        ScaledUnit.myAssert(((Unit)milePerHour).multiply(poundPerSec), ((Unit)poundPerSec).multiply(milePerHour));
        ScaledUnit.myAssert(((Unit)milePerHour).divide(poundPerSec), ((Unit)poundPerSec).divide(milePerHour).pow(-1));
        ScaledUnit.myAssert(milePerHour.toThis(1.0, (Unit)meterPerSec) != 1.0);
        ScaledUnit.myAssert(milePerHour.toThat(1.0, (Unit)meterPerSec) != 1.0);
        ScaledUnit.myAssert(milePerHour.toThis(1.0, (Unit)meterPerSec), meterPerSec.toThat(1.0, (Unit)milePerHour));
        ScaledUnit.myAssert(meterPerSec.toThat(milePerHour.toThat(1.0, (Unit)meterPerSec), (Unit)milePerHour), 1.0);
        double[] values = new double[]{1.0, 2.0};
        ScaledUnit.myAssert(((Unit)milePerHour).toThis(values, (Unit)meterPerSec), meterPerSec.toThat(values, (Unit)milePerHour));
        ScaledUnit.myAssert(meterPerSec.toThat(((Unit)milePerHour).toThat(values, (Unit)meterPerSec), (Unit)milePerHour), values);
        System.out.println("Checking exceptions:");
        try {
            milePerHour.toThis(5.0, (Unit)poundPerSec);
            throw new AssertionError();
        }
        catch (UnitException e) {
            System.out.println(e.getMessage());
            System.out.println("Done");
            return;
        }
    }

    @Override
    public boolean equals(Unit unit) {
        if (this == unit) {
            return true;
        }
        if (this.amount == 1.0) {
            return this.underUnit.equals(unit);
        }
        if (!(unit instanceof ScaledUnit)) {
            return false;
        }
        ScaledUnit that = (ScaledUnit)unit;
        return this.amount == that.amount && this.underUnit.equals(that.underUnit);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.amount == 1.0 ? this.underUnit.hashCode() : this.underUnit.hashCode() ^ Double.valueOf(this.amount).hashCode();
        }
        return this.hashCode;
    }

    @Override
    public DerivedUnit getDerivedUnit() {
        return this.underUnit.getDerivedUnit();
    }
}

