/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractDiscreteDistribution;
import cern.jet.random.engine.RandomEngine;

public class PoissonSlow
extends AbstractDiscreteDistribution {
    protected double mean;
    protected double cached_sq;
    protected double cached_alxm;
    protected double cached_g;
    protected static final double MEAN_MAX = 2.147483647E9;
    protected static final double SWITCH_MEAN = 12.0;
    protected static final double[] cof = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
    protected static PoissonSlow shared = new PoissonSlow(0.0, PoissonSlow.makeDefaultGenerator());

    public PoissonSlow(double d, RandomEngine randomEngine) {
        this.setRandomGenerator(randomEngine);
        this.setMean(d);
    }

    public static double logGamma(double d) {
        double d2 = d - 1.0;
        double d3 = d2 + 5.5;
        d3 -= (d2 + 0.5) * Math.log(d3);
        double d4 = 1.000000000190015;
        double[] dArray = cof;
        for (int i = 0; i <= 5; ++i) {
            d4 += dArray[i] / (d2 += 1.0);
        }
        return -d3 + Math.log(2.5066282746310007 * d4);
    }

    @Override
    public int nextInt() {
        return this.nextInt(this.mean);
    }

    private int nextInt(double d) {
        double d2 = d;
        double d3 = this.cached_g;
        if (d2 == -1.0) {
            return 0;
        }
        if (d2 < 12.0) {
            int n = -1;
            double d4 = 1.0;
            do {
                ++n;
            } while ((d4 *= this.randomGenerator.raw()) >= d3);
            return n;
        }
        if (d2 < 2.147483647E9) {
            double d5;
            double d6 = this.cached_sq;
            double d7 = this.cached_alxm;
            RandomEngine randomEngine = this.randomGenerator;
            while (true) {
                double d8;
                if ((d5 = d6 * (d8 = Math.tan(Math.PI * randomEngine.raw())) + d2) < 0.0) {
                    continue;
                }
                d5 = (int)d5;
                double d9 = 0.9 * (1.0 + d8 * d8) * Math.exp(d5 * d7 - PoissonSlow.logGamma(d5 + 1.0) - d3);
                if (!(randomEngine.raw() > d9)) break;
            }
            return (int)d5;
        }
        return (int)d2;
    }

    protected int nextIntSlow() {
        double d = Math.exp(-this.mean);
        int n = 0;
        double d2 = 1.0;
        while (d2 >= d && d2 > 0.0) {
            d2 *= this.randomGenerator.raw();
            ++n;
        }
        if (d2 <= 0.0 && d > 0.0) {
            return (int)Math.round(this.mean);
        }
        return n - 1;
    }

    public void setMean(double d) {
        if (d != this.mean) {
            this.mean = d;
            if (d == -1.0) {
                return;
            }
            if (d < 12.0) {
                this.cached_g = Math.exp(-d);
            } else {
                this.cached_sq = Math.sqrt(2.0 * d);
                this.cached_alxm = Math.log(d);
                this.cached_g = d * this.cached_alxm - PoissonSlow.logGamma(d + 1.0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int staticNextInt(double d) {
        PoissonSlow poissonSlow = shared;
        synchronized (poissonSlow) {
            shared.setMean(d);
            return shared.nextInt();
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.mean + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void xstaticSetRandomGenerator(RandomEngine randomEngine) {
        PoissonSlow poissonSlow = shared;
        synchronized (poissonSlow) {
            shared.setRandomGenerator(randomEngine);
        }
    }
}

