/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.math;

import cern.colt.function.DoubleDoubleFunction;

public final class PlusMult
implements DoubleDoubleFunction {
    public double multiplicator;

    protected PlusMult(double d) {
        this.multiplicator = d;
    }

    @Override
    public final double apply(double d, double d2) {
        return d + d2 * this.multiplicator;
    }

    public static PlusMult minusDiv(double d) {
        return new PlusMult(-1.0 / d);
    }

    public static PlusMult minusMult(double d) {
        return new PlusMult(-d);
    }

    public static PlusMult plusDiv(double d) {
        return new PlusMult(1.0 / d);
    }

    public static PlusMult plusMult(double d) {
        return new PlusMult(d);
    }
}

