/*
 * Decompiled with CFR 0.152.
 */
package cern.hep.aida.ref;

import colt.hep.aida.IAxis;
import java.util.Arrays;

public class VariableAxis
implements IAxis {
    protected double min;
    protected int bins;
    protected double[] edges;

    public VariableAxis(double[] dArray) {
        if (dArray.length < 1) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < dArray.length - 1; ++i) {
            if (!(dArray[i + 1] <= dArray[i])) continue;
            throw new IllegalArgumentException("edges must be sorted ascending and must not contain multiple identical values");
        }
        this.min = dArray[0];
        this.bins = dArray.length - 1;
        this.edges = (double[])dArray.clone();
    }

    @Override
    public double binCentre(int n) {
        return (this.binLowerEdge(n) + this.binUpperEdge(n)) / 2.0;
    }

    @Override
    public double binLowerEdge(int n) {
        if (n == -2) {
            return Double.NEGATIVE_INFINITY;
        }
        if (n == -1) {
            return this.upperEdge();
        }
        return this.edges[n];
    }

    @Override
    public int bins() {
        return this.bins;
    }

    @Override
    public double binUpperEdge(int n) {
        if (n == -2) {
            return this.lowerEdge();
        }
        if (n == -1) {
            return Double.POSITIVE_INFINITY;
        }
        return this.edges[n + 1];
    }

    @Override
    public double binWidth(int n) {
        return this.binUpperEdge(n) - this.binLowerEdge(n);
    }

    @Override
    public int coordToIndex(double d) {
        if (d < this.min) {
            return -2;
        }
        int n = Arrays.binarySearch(this.edges, d);
        if (n < 0) {
            n = -n - 1 - 1;
        }
        if (n >= this.bins) {
            return -1;
        }
        return n;
    }

    @Override
    public double lowerEdge() {
        return this.min;
    }

    protected static String toString(double[] dArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = dArray.length - 1;
        for (int i = 0; i <= n; ++i) {
            stringBuffer.append(dArray[i]);
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    public double upperEdge() {
        return this.edges[this.edges.length - 1];
    }
}

