/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DelegateDoubleMatrix1D;

class WrapperDoubleMatrix2D
extends DoubleMatrix2D {
    protected DoubleMatrix2D content;

    public WrapperDoubleMatrix2D(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D != null) {
            this.setUp(doubleMatrix2D.rows(), doubleMatrix2D.columns());
        }
        this.content = doubleMatrix2D;
    }

    @Override
    protected DoubleMatrix2D getContent() {
        return this.content;
    }

    @Override
    public double getQuick(int n, int n2) {
        return this.content.getQuick(n, n2);
    }

    @Override
    public DoubleMatrix2D like(int n, int n2) {
        return this.content.like(n, n2);
    }

    @Override
    public DoubleMatrix1D like1D(int n) {
        return this.content.like1D(n);
    }

    @Override
    protected DoubleMatrix1D like1D(int n, int n2, int n3) {
        throw new InternalError();
    }

    @Override
    public void setQuick(int n, int n2, double d) {
        this.content.setQuick(n, n2, d);
    }

    @Override
    public DoubleMatrix1D viewColumn(int n) {
        return this.viewDice().viewRow(n);
    }

    @Override
    public DoubleMatrix2D viewColumnFlip() {
        if (this.columns == 0) {
            return this;
        }
        WrapperDoubleMatrix2D wrapperDoubleMatrix2D = new WrapperDoubleMatrix2D(this){

            @Override
            public double getQuick(int n, int n2) {
                return this.content.get(n, this.columns - 1 - n2);
            }

            @Override
            public void setQuick(int n, int n2, double d) {
                this.content.set(n, this.columns - 1 - n2, d);
            }
        };
        return wrapperDoubleMatrix2D;
    }

    @Override
    public DoubleMatrix2D viewDice() {
        WrapperDoubleMatrix2D wrapperDoubleMatrix2D = new WrapperDoubleMatrix2D(this){

            @Override
            public double getQuick(int n, int n2) {
                return this.content.get(n2, n);
            }

            @Override
            public void setQuick(int n, int n2, double d) {
                this.content.set(n2, n, d);
            }
        };
        wrapperDoubleMatrix2D.rows = this.columns;
        wrapperDoubleMatrix2D.columns = this.rows;
        return wrapperDoubleMatrix2D;
    }

    @Override
    public DoubleMatrix2D viewPart(final int n, final int n2, int n3, int n4) {
        this.checkBox(n, n2, n3, n4);
        WrapperDoubleMatrix2D wrapperDoubleMatrix2D = new WrapperDoubleMatrix2D(this){

            @Override
            public double getQuick(int n3, int n22) {
                return this.content.get(n + n3, n2 + n22);
            }

            @Override
            public void setQuick(int n3, int n22, double d) {
                this.content.set(n + n3, n2 + n22, d);
            }
        };
        wrapperDoubleMatrix2D.rows = n3;
        wrapperDoubleMatrix2D.columns = n4;
        return wrapperDoubleMatrix2D;
    }

    @Override
    public DoubleMatrix1D viewRow(int n) {
        this.checkRow(n);
        return new DelegateDoubleMatrix1D(this, n);
    }

    @Override
    public DoubleMatrix2D viewRowFlip() {
        if (this.rows == 0) {
            return this;
        }
        WrapperDoubleMatrix2D wrapperDoubleMatrix2D = new WrapperDoubleMatrix2D(this){

            @Override
            public double getQuick(int n, int n2) {
                return this.content.get(this.rows - 1 - n, n2);
            }

            @Override
            public void setQuick(int n, int n2, double d) {
                this.content.set(this.rows - 1 - n, n2, d);
            }
        };
        return wrapperDoubleMatrix2D;
    }

    @Override
    public DoubleMatrix2D viewSelection(int[] nArray, int[] nArray2) {
        int n;
        if (nArray == null) {
            nArray = new int[this.rows];
            n = this.rows;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.columns];
            n = this.columns;
            while (--n >= 0) {
                nArray2[n] = n;
            }
        }
        this.checkRowIndexes(nArray);
        this.checkColumnIndexes(nArray2);
        final int[] nArray3 = nArray;
        final int[] nArray4 = nArray2;
        WrapperDoubleMatrix2D wrapperDoubleMatrix2D = new WrapperDoubleMatrix2D(this){

            @Override
            public double getQuick(int n, int n2) {
                return this.content.get(nArray3[n], nArray4[n2]);
            }

            @Override
            public void setQuick(int n, int n2, double d) {
                this.content.set(nArray3[n], nArray4[n2], d);
            }
        };
        wrapperDoubleMatrix2D.rows = nArray.length;
        wrapperDoubleMatrix2D.columns = nArray2.length;
        return wrapperDoubleMatrix2D;
    }

    @Override
    protected DoubleMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        throw new InternalError();
    }

    @Override
    public DoubleMatrix2D viewStrides(final int n, final int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IndexOutOfBoundsException("illegal stride");
        }
        WrapperDoubleMatrix2D wrapperDoubleMatrix2D = new WrapperDoubleMatrix2D(this){

            @Override
            public double getQuick(int n3, int n22) {
                return this.content.get(n * n3, n2 * n22);
            }

            @Override
            public void setQuick(int n3, int n22, double d) {
                this.content.set(n * n3, n2 * n22, d);
            }
        };
        wrapperDoubleMatrix2D.rows = this.rows;
        wrapperDoubleMatrix2D.columns = this.columns;
        if (this.rows != 0) {
            wrapperDoubleMatrix2D.rows = (this.rows - 1) / n + 1;
        }
        if (this.columns != 0) {
            wrapperDoubleMatrix2D.columns = (this.columns - 1) / n2 + 1;
        }
        return wrapperDoubleMatrix2D;
    }
}

