/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.function.ObjectFunction;
import cern.colt.function.ObjectObjectFunction;
import cern.colt.matrix.ObjectMatrix1D;
import cern.colt.matrix.ObjectMatrix2D;
import cern.colt.matrix.impl.DenseObjectMatrix1D;
import cern.colt.matrix.impl.SelectedDenseObjectMatrix2D;

public class DenseObjectMatrix2D
extends ObjectMatrix2D {
    protected Object[] elements;

    public DenseObjectMatrix2D(Object[][] objectArray) {
        this(objectArray.length, objectArray.length == 0 ? 0 : objectArray[0].length);
        this.assign(objectArray);
    }

    public DenseObjectMatrix2D(int n, int n2) {
        this.setUp(n, n2);
        this.elements = new Object[n * n2];
    }

    protected DenseObjectMatrix2D(int n, int n2, Object[] objectArray, int n3, int n4, int n5, int n6) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = objectArray;
        this.isNoView = false;
    }

    @Override
    public ObjectMatrix2D assign(Object[][] objectArray) {
        if (this.isNoView) {
            if (objectArray.length != this.rows) {
                throw new IllegalArgumentException("Must have same number of rows: rows=" + objectArray.length + "rows()=" + this.rows());
            }
            int n = this.columns * (this.rows - 1);
            int n2 = this.rows;
            while (--n2 >= 0) {
                Object[] objectArray2 = objectArray[n2];
                if (objectArray2.length != this.columns) {
                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + objectArray2.length + "columns()=" + this.columns());
                }
                System.arraycopy(objectArray2, 0, this.elements, n, this.columns);
                n -= this.columns;
            }
        } else {
            super.assign(objectArray);
        }
        return this;
    }

    @Override
    public ObjectMatrix2D assign(ObjectFunction objectFunction) {
        Object[] objectArray = this.elements;
        if (objectArray == null) {
            throw new InternalError();
        }
        int n = this.index(0, 0);
        int n2 = this.columnStride;
        int n3 = this.rowStride;
        int n4 = this.rows;
        while (--n4 >= 0) {
            int n5 = n;
            int n6 = this.columns;
            while (--n6 >= 0) {
                objectArray[n5] = objectFunction.apply(objectArray[n5]);
                n5 += n2;
            }
            n += n3;
        }
        return this;
    }

    @Override
    public ObjectMatrix2D assign(ObjectMatrix2D objectMatrix2D) {
        Object[] objectArray;
        if (!(objectMatrix2D instanceof DenseObjectMatrix2D)) {
            return super.assign(objectMatrix2D);
        }
        DenseObjectMatrix2D denseObjectMatrix2D = (DenseObjectMatrix2D)objectMatrix2D;
        if (denseObjectMatrix2D == this) {
            return this;
        }
        this.checkShape(denseObjectMatrix2D);
        if (this.isNoView && denseObjectMatrix2D.isNoView) {
            System.arraycopy(denseObjectMatrix2D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(denseObjectMatrix2D)) {
            objectArray = denseObjectMatrix2D.copy();
            if (!(objectArray instanceof DenseObjectMatrix2D)) {
                return super.assign(denseObjectMatrix2D);
            }
            denseObjectMatrix2D = (DenseObjectMatrix2D)objectArray;
        }
        objectArray = this.elements;
        Object[] objectArray2 = denseObjectMatrix2D.elements;
        if (this.elements == null || objectArray2 == null) {
            throw new InternalError();
        }
        int n = this.columnStride;
        int n2 = denseObjectMatrix2D.columnStride;
        int n3 = this.rowStride;
        int n4 = denseObjectMatrix2D.rowStride;
        int n5 = denseObjectMatrix2D.index(0, 0);
        int n6 = this.index(0, 0);
        int n7 = this.rows;
        while (--n7 >= 0) {
            int n8 = n6;
            int n9 = n5;
            int n10 = this.columns;
            while (--n10 >= 0) {
                objectArray[n8] = objectArray2[n9];
                n8 += n;
                n9 += n2;
            }
            n6 += n3;
            n5 += n4;
        }
        return this;
    }

    @Override
    public ObjectMatrix2D assign(ObjectMatrix2D objectMatrix2D, ObjectObjectFunction objectObjectFunction) {
        if (!(objectMatrix2D instanceof DenseObjectMatrix2D)) {
            return super.assign(objectMatrix2D, objectObjectFunction);
        }
        DenseObjectMatrix2D denseObjectMatrix2D = (DenseObjectMatrix2D)objectMatrix2D;
        this.checkShape(objectMatrix2D);
        Object[] objectArray = this.elements;
        Object[] objectArray2 = denseObjectMatrix2D.elements;
        if (objectArray == null || objectArray2 == null) {
            throw new InternalError();
        }
        int n = this.columnStride;
        int n2 = denseObjectMatrix2D.columnStride;
        int n3 = this.rowStride;
        int n4 = denseObjectMatrix2D.rowStride;
        int n5 = denseObjectMatrix2D.index(0, 0);
        int n6 = this.index(0, 0);
        int n7 = this.rows;
        while (--n7 >= 0) {
            int n8 = n6;
            int n9 = n5;
            int n10 = this.columns;
            while (--n10 >= 0) {
                objectArray[n8] = objectObjectFunction.apply(objectArray[n8], objectArray2[n9]);
                n8 += n;
                n9 += n2;
            }
            n6 += n3;
            n5 += n4;
        }
        return this;
    }

    @Override
    public Object getQuick(int n, int n2) {
        return this.elements[this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride];
    }

    @Override
    protected boolean haveSharedCellsRaw(ObjectMatrix2D objectMatrix2D) {
        if (objectMatrix2D instanceof SelectedDenseObjectMatrix2D) {
            SelectedDenseObjectMatrix2D selectedDenseObjectMatrix2D = (SelectedDenseObjectMatrix2D)objectMatrix2D;
            return this.elements == selectedDenseObjectMatrix2D.elements;
        }
        if (objectMatrix2D instanceof DenseObjectMatrix2D) {
            DenseObjectMatrix2D denseObjectMatrix2D = (DenseObjectMatrix2D)objectMatrix2D;
            return this.elements == denseObjectMatrix2D.elements;
        }
        return false;
    }

    @Override
    protected int index(int n, int n2) {
        return this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
    }

    @Override
    public ObjectMatrix2D like(int n, int n2) {
        return new DenseObjectMatrix2D(n, n2);
    }

    @Override
    public ObjectMatrix1D like1D(int n) {
        return new DenseObjectMatrix1D(n);
    }

    @Override
    protected ObjectMatrix1D like1D(int n, int n2, int n3) {
        return new DenseObjectMatrix1D(n, this.elements, n2, n3);
    }

    @Override
    public void setQuick(int n, int n2, Object object) {
        this.elements[this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride] = object;
    }

    @Override
    protected ObjectMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedDenseObjectMatrix2D(this.elements, nArray, nArray2, 0);
    }
}

