/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.function.BooleanProcedure;
import cern.colt.list.AbstractList;
import cern.colt.list.BooleanArrayList;
import cern.jet.random.Uniform;
import cern.jet.random.engine.DRand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public abstract class AbstractBooleanList
extends AbstractList {
    protected int size;

    protected AbstractBooleanList() {
    }

    public void add(boolean bl) {
        this.beforeInsert(this.size, bl);
    }

    public void addAllOfFromTo(AbstractBooleanList abstractBooleanList, int n, int n2) {
        this.beforeInsertAllOfFromTo(this.size, abstractBooleanList, n, n2);
    }

    public void beforeInsert(int n, boolean bl) {
        this.beforeInsertDummies(n, 1);
        this.set(n, bl);
    }

    public void beforeInsertAllOfFromTo(int n, AbstractBooleanList abstractBooleanList, int n2, int n3) {
        int n4 = n3 - n2 + 1;
        this.beforeInsertDummies(n, n4);
        this.replaceFromToWithFrom(n, n + n4 - 1, abstractBooleanList, n2);
    }

    @Override
    protected void beforeInsertDummies(int n, int n2) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        if (n2 > 0) {
            this.ensureCapacity(this.size + n2);
            this.setSizeRaw(this.size + n2);
            this.replaceFromToWithFrom(n + n2, this.size - 1, this, n);
        }
    }

    public int binarySearch(boolean bl) {
        return this.binarySearchFromTo(bl, 0, this.size - 1);
    }

    public int binarySearchFromTo(boolean bl, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        int n5 = AbstractBooleanList.toInt(bl);
        while (n3 <= n4) {
            int n6 = (n3 + n4) / 2;
            boolean bl2 = this.get(n6);
            if (AbstractBooleanList.toInt(bl2) < n5) {
                n3 = n6 + 1;
                continue;
            }
            if (AbstractBooleanList.toInt(bl2) > n5) {
                n4 = n6 - 1;
                continue;
            }
            return n6;
        }
        return -(n3 + 1);
    }

    @Override
    public Object clone() {
        return this.partFromTo(0, this.size - 1);
    }

    public boolean contains(boolean bl) {
        return this.indexOfFromTo(bl, 0, this.size - 1) >= 0;
    }

    public void delete(boolean bl) {
        int n = this.indexOfFromTo(bl, 0, this.size - 1);
        if (n >= 0) {
            this.remove(n);
        }
    }

    public boolean[] elements() {
        boolean[] blArray = new boolean[this.size];
        int n = this.size;
        while (--n >= 0) {
            blArray[n] = this.getQuick(n);
        }
        return blArray;
    }

    public AbstractBooleanList elements(boolean[] blArray) {
        this.clear();
        this.addAllOfFromTo(new BooleanArrayList(blArray), 0, blArray.length - 1);
        return this;
    }

    public abstract void ensureCapacity(int var1);

    public boolean equals(Object object) {
        if (!(object instanceof AbstractBooleanList)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        AbstractBooleanList abstractBooleanList = (AbstractBooleanList)object;
        if (this.size() != abstractBooleanList.size()) {
            return false;
        }
        int n = this.size();
        while (--n >= 0) {
            if (this.getQuick(n) == abstractBooleanList.getQuick(n)) continue;
            return false;
        }
        return true;
    }

    public void fillFromToWith(int n, int n2, boolean bl) {
        AbstractBooleanList.checkRangeFromTo(n, n2, this.size);
        int n3 = n;
        while (n3 <= n2) {
            this.setQuick(n3++, bl);
        }
    }

    public boolean forEach(BooleanProcedure booleanProcedure) {
        int n = 0;
        while (n < this.size) {
            if (booleanProcedure.apply(this.get(n++))) continue;
            return false;
        }
        return true;
    }

    public boolean get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.getQuick(n);
    }

    protected abstract boolean getQuick(int var1);

    public int indexOf(boolean bl) {
        return this.indexOfFromTo(bl, 0, this.size - 1);
    }

    public int indexOfFromTo(boolean bl, int n, int n2) {
        AbstractBooleanList.checkRangeFromTo(n, n2, this.size);
        for (int i = n; i <= n2; ++i) {
            if (bl != this.getQuick(i)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(boolean bl) {
        return this.lastIndexOfFromTo(bl, 0, this.size - 1);
    }

    public int lastIndexOfFromTo(boolean bl, int n, int n2) {
        AbstractBooleanList.checkRangeFromTo(n, n2, this.size());
        for (int i = n2; i >= n; --i) {
            if (bl != this.getQuick(i)) continue;
            return i;
        }
        return -1;
    }

    public AbstractBooleanList partFromTo(int n, int n2) {
        AbstractBooleanList.checkRangeFromTo(n, n2, this.size);
        int n3 = n2 - n + 1;
        BooleanArrayList booleanArrayList = new BooleanArrayList(n3);
        booleanArrayList.addAllOfFromTo(this, n, n2);
        return booleanArrayList;
    }

    public boolean removeAll(AbstractBooleanList abstractBooleanList) {
        int n;
        if (abstractBooleanList.size() == 0) {
            return false;
        }
        int n2 = abstractBooleanList.size() - 1;
        int n3 = 0;
        for (n = 0; n < this.size; ++n) {
            if (abstractBooleanList.indexOfFromTo(this.getQuick(n), 0, n2) >= 0) continue;
            this.setQuick(n3++, this.getQuick(n));
        }
        n = n3 != this.size ? 1 : 0;
        this.setSize(n3);
        return n != 0;
    }

    @Override
    public void removeFromTo(int n, int n2) {
        int n3;
        AbstractBooleanList.checkRangeFromTo(n, n2, this.size);
        int n4 = this.size - n2 - 1;
        if (n4 > 0) {
            this.replaceFromToWithFrom(n, n - 1 + n4, this, n2 + 1);
        }
        if ((n3 = n2 - n + 1) > 0) {
            this.setSizeRaw(this.size - n3);
        }
    }

    public void replaceFromToWithFrom(int n, int n2, AbstractBooleanList abstractBooleanList, int n3) {
        block4: {
            int n4 = n2 - n + 1;
            if (n4 <= 0) break block4;
            AbstractBooleanList.checkRangeFromTo(n, n2, this.size());
            AbstractBooleanList.checkRangeFromTo(n3, n3 + n4 - 1, abstractBooleanList.size());
            if (n <= n3) {
                while (--n4 >= 0) {
                    this.setQuick(n++, abstractBooleanList.getQuick(n3++));
                }
            } else {
                int n5 = n3 + n4 - 1;
                while (--n4 >= 0) {
                    this.setQuick(n2--, abstractBooleanList.getQuick(n5--));
                }
            }
        }
    }

    public void replaceFromToWithFromTo(int n, int n2, AbstractBooleanList abstractBooleanList, int n3, int n4) {
        int n5;
        if (n3 > n4) {
            throw new IndexOutOfBoundsException("otherFrom: " + n3 + ", otherTo: " + n4);
        }
        if (this == abstractBooleanList && n2 - n != n4 - n3) {
            this.replaceFromToWithFromTo(n, n2, this.partFromTo(n3, n4), 0, n4 - n3);
            return;
        }
        int n6 = n5 = n4 - n3 + 1;
        int n7 = n - 1;
        if (n2 >= n) {
            n6 -= n2 - n + 1;
            n7 = n2;
        }
        if (n6 > 0) {
            this.beforeInsertDummies(n7 + 1, n6);
        } else if (n6 < 0) {
            this.removeFromTo(n7 + n6, n7 - 1);
        }
        if (n5 > 0) {
            this.replaceFromToWithFrom(n, n + n5 - 1, abstractBooleanList, n3);
        }
    }

    @Override
    public void replaceFromWith(int n, Collection collection) {
        AbstractBooleanList.checkRange(n, this.size());
        Iterator iterator = collection.iterator();
        int n2 = n;
        int n3 = Math.min(this.size() - n, collection.size());
        for (int i = 0; i < n3; ++i) {
            this.set(n2++, (Boolean)iterator.next());
        }
    }

    public boolean retainAll(AbstractBooleanList abstractBooleanList) {
        int n;
        if (abstractBooleanList.size() == 0) {
            if (this.size == 0) {
                return false;
            }
            this.setSize(0);
            return true;
        }
        int n2 = abstractBooleanList.size() - 1;
        int n3 = 0;
        for (n = 0; n < this.size; ++n) {
            if (abstractBooleanList.indexOfFromTo(this.getQuick(n), 0, n2) < 0) continue;
            this.setQuick(n3++, this.getQuick(n));
        }
        n = n3 != this.size ? 1 : 0;
        this.setSize(n3);
        return n != 0;
    }

    @Override
    public void reverse() {
        int n = this.size() / 2;
        int n2 = this.size() - 1;
        int n3 = 0;
        while (n3 < n) {
            boolean bl = this.getQuick(n3);
            this.setQuick(n3++, this.getQuick(n2));
            this.setQuick(n2--, bl);
        }
    }

    public void set(int n, boolean bl) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.setQuick(n, bl);
    }

    protected abstract void setQuick(int var1, boolean var2);

    protected void setSizeRaw(int n) {
        this.size = n;
    }

    @Override
    public void shuffleFromTo(int n, int n2) {
        AbstractBooleanList.checkRangeFromTo(n, n2, this.size());
        Uniform uniform = new Uniform(new DRand(new Date()));
        for (int i = n; i < n2; ++i) {
            int n3 = uniform.nextIntFromTo(i, n2);
            boolean bl = this.getQuick(n3);
            this.setQuick(n3, this.getQuick(i));
            this.setQuick(i, bl);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    public AbstractBooleanList times(int n) {
        BooleanArrayList booleanArrayList = new BooleanArrayList(n * this.size());
        int n2 = n;
        while (--n2 >= 0) {
            booleanArrayList.addAllOfFromTo(this, 0, this.size() - 1);
        }
        return booleanArrayList;
    }

    protected static int toInt(boolean bl) {
        return bl ? 1 : 0;
    }

    @Override
    public ArrayList toList() {
        int n = this.size();
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new Boolean(this.get(i)));
        }
        return arrayList;
    }

    @Override
    public String toString() {
        return Arrays.toString(this.partFromTo(0, this.size() - 1).elements());
    }
}

