/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.table;

import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeDataTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetIndexOrderCursor;
import org.tmatesoft.sqljet.core.table.ISqlJetTransaction;
import org.tmatesoft.sqljet.core.table.SqlJetDb;
import org.tmatesoft.sqljet.core.table.SqlJetScope;
import org.tmatesoft.sqljet.core.table.engine.ISqlJetEngineSynchronized;
import org.tmatesoft.sqljet.core.table.engine.SqlJetEngine;

public class SqlJetIndexScopeCursor
extends SqlJetIndexOrderCursor {
    private Object[] firstKey;
    private Object[] lastKey;
    private long firstRowId;
    private long lastRowId;
    private boolean firstKeyIncluded;
    private boolean lastKeyIncluded;

    public SqlJetIndexScopeCursor(ISqlJetBtreeDataTable table, SqlJetDb db, String indexName, Object[] firstKey, Object[] lastKey) throws SqlJetException {
        this(table, db, indexName, new SqlJetScope(firstKey, lastKey));
    }

    public SqlJetIndexScopeCursor(ISqlJetBtreeDataTable table, SqlJetDb db, String indexName, SqlJetScope scope) throws SqlJetException {
        super(table, db, indexName);
        this.firstKey = SqlJetUtility.copyArray(scope.getLeftBound() != null ? scope.getLeftBound().getValue() : null);
        this.firstKeyIncluded = scope.getLeftBound() != null ? scope.getLeftBound().isInclusive() : true;
        this.lastKey = SqlJetUtility.copyArray(scope.getRightBound() != null ? scope.getRightBound().getValue() : null);
        boolean bl = this.lastKeyIncluded = scope.getRightBound() != null ? scope.getRightBound().isInclusive() : true;
        if (null == this.indexTable) {
            this.firstRowId = this.getRowIdFromKey(this.firstKey);
            this.lastRowId = this.getRowIdFromKey(this.lastKey);
            if (!this.firstKeyIncluded && this.firstRowId > 0L) {
                ++this.firstRowId;
            }
            if (!this.lastKeyIncluded && this.lastRowId > 0L) {
                --this.lastRowId;
            }
        }
        this.first();
    }

    @Override
    public boolean goTo(final long rowId) throws SqlJetException {
        return (Boolean)this.db.runReadTransaction(new ISqlJetTransaction(){

            @Override
            public Object run(SqlJetDb db) throws SqlJetException {
                SqlJetIndexScopeCursor.super.goTo(rowId);
                return !SqlJetIndexScopeCursor.this.eof();
            }
        });
    }

    @Override
    public boolean first() throws SqlJetException {
        return (Boolean)this.db.runReadTransaction(new ISqlJetTransaction(){

            @Override
            public Object run(SqlJetDb db) throws SqlJetException {
                if (SqlJetIndexScopeCursor.this.firstKey == null) {
                    return SqlJetIndexScopeCursor.super.first();
                }
                if (SqlJetIndexScopeCursor.this.indexTable == null) {
                    if (SqlJetIndexScopeCursor.this.firstRowId == 0L) {
                        return SqlJetIndexScopeCursor.super.first();
                    }
                    return SqlJetIndexScopeCursor.this.firstRowNum(SqlJetIndexScopeCursor.this.goTo(SqlJetIndexScopeCursor.this.firstRowId));
                }
                long lookup = SqlJetIndexScopeCursor.this.indexTable.lookupNear(false, SqlJetIndexScopeCursor.this.firstKey);
                if (!SqlJetIndexScopeCursor.this.firstKeyIncluded && lookup != 0L) {
                    while (SqlJetIndexScopeCursor.this.indexTable.compareKey(SqlJetIndexScopeCursor.this.firstKey) == 0) {
                        if (SqlJetIndexScopeCursor.this.indexTable.next()) {
                            lookup = SqlJetIndexScopeCursor.this.indexTable.getKeyRowId();
                            continue;
                        }
                        lookup = 0L;
                        break;
                    }
                }
                if (lookup != 0L) {
                    return SqlJetIndexScopeCursor.this.firstRowNum(SqlJetIndexScopeCursor.this.goTo(lookup));
                }
                return false;
            }
        });
    }

    @Override
    public boolean next() throws SqlJetException {
        return (Boolean)this.db.runReadTransaction(new ISqlJetTransaction(){

            @Override
            public Object run(SqlJetDb db) throws SqlJetException {
                if (SqlJetIndexScopeCursor.this.lastKey == null) {
                    return SqlJetIndexScopeCursor.super.next();
                }
                if (SqlJetIndexScopeCursor.this.indexTable == null) {
                    SqlJetIndexScopeCursor.super.next();
                    return !SqlJetIndexScopeCursor.this.eof();
                }
                if (SqlJetIndexScopeCursor.this.indexTable.next() && !SqlJetIndexScopeCursor.this.eof()) {
                    return SqlJetIndexScopeCursor.this.nextRowNum(SqlJetIndexScopeCursor.this.goTo(SqlJetIndexScopeCursor.this.indexTable.getKeyRowId()));
                }
                return false;
            }
        });
    }

    @Override
    public boolean previous() throws SqlJetException {
        return (Boolean)this.db.runReadTransaction(new ISqlJetTransaction(){

            @Override
            public Object run(SqlJetDb db) throws SqlJetException {
                if (SqlJetIndexScopeCursor.this.firstKey == null) {
                    return SqlJetIndexScopeCursor.super.previous();
                }
                if (SqlJetIndexScopeCursor.this.indexTable == null) {
                    SqlJetIndexScopeCursor.super.previous();
                    return !SqlJetIndexScopeCursor.this.eof();
                }
                if (SqlJetIndexScopeCursor.this.indexTable.previous() && !SqlJetIndexScopeCursor.this.eof()) {
                    return SqlJetIndexScopeCursor.this.previousRowNum(SqlJetIndexScopeCursor.this.goTo(SqlJetIndexScopeCursor.this.indexTable.getKeyRowId()));
                }
                return false;
            }
        });
    }

    @Override
    public boolean eof() throws SqlJetException {
        return (Boolean)this.db.runReadTransaction(new ISqlJetTransaction(){

            @Override
            public Object run(SqlJetDb db) throws SqlJetException {
                return SqlJetIndexScopeCursor.super.eof() || !SqlJetIndexScopeCursor.this.checkScope();
            }
        });
    }

    private boolean checkScope() throws SqlJetException {
        if (this.indexTable == null) {
            if (this.getBtreeDataTable().eof()) {
                return false;
            }
            long rowId = this.getRowId();
            if (this.firstRowId != 0L && this.firstRowId > rowId) {
                return false;
            }
            if (this.lastRowId != 0L && this.lastRowId < rowId) {
                return false;
            }
        } else {
            int compareResult;
            if (this.firstKey != null) {
                compareResult = this.indexTable.compareKey(this.firstKey);
                if (compareResult < 0) {
                    return false;
                }
                if (!this.firstKeyIncluded && compareResult == 0) {
                    return false;
                }
            }
            if (this.lastKey != null) {
                compareResult = this.indexTable.compareKey(this.lastKey);
                if (compareResult > 0) {
                    return false;
                }
                if (!this.lastKeyIncluded && compareResult == 0) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean last() throws SqlJetException {
        return (Boolean)this.db.runReadTransaction(new ISqlJetTransaction(){

            @Override
            public Object run(SqlJetDb db) throws SqlJetException {
                if (SqlJetIndexScopeCursor.this.lastKey == null) {
                    return SqlJetIndexScopeCursor.super.last();
                }
                if (SqlJetIndexScopeCursor.this.indexTable == null) {
                    if (SqlJetIndexScopeCursor.this.lastRowId == 0L) {
                        return SqlJetIndexScopeCursor.super.last();
                    }
                    return SqlJetIndexScopeCursor.this.lastRowNum(SqlJetIndexScopeCursor.this.goTo(SqlJetIndexScopeCursor.this.lastRowId));
                }
                long lookup = SqlJetIndexScopeCursor.this.indexTable.lookupLastNear(SqlJetIndexScopeCursor.this.lastKey);
                if (lookup != 0L && !SqlJetIndexScopeCursor.this.lastKeyIncluded) {
                    while (SqlJetIndexScopeCursor.this.indexTable.compareKey(SqlJetIndexScopeCursor.this.lastKey) == 0) {
                        if (SqlJetIndexScopeCursor.this.indexTable.previous()) {
                            lookup = SqlJetIndexScopeCursor.this.indexTable.getKeyRowId();
                            continue;
                        }
                        lookup = 0L;
                        break;
                    }
                }
                if (lookup != 0L) {
                    return SqlJetIndexScopeCursor.this.lastRowNum(SqlJetIndexScopeCursor.this.goTo(lookup));
                }
                return false;
            }
        });
    }

    private long getRowIdFromKey(Object[] key) {
        if (key != null && key.length > 0 && key[0] instanceof Long) {
            return (Long)key[0];
        }
        return 0L;
    }

    @Override
    public void delete() throws SqlJetException {
        this.db.runSynchronized(new ISqlJetEngineSynchronized(){

            @Override
            public Object runSynchronized(SqlJetEngine engine) throws SqlJetException {
                SqlJetIndexScopeCursor.super.delete();
                return null;
            }
        });
        this.db.runReadTransaction(new ISqlJetTransaction(){

            @Override
            public Object run(SqlJetDb db) throws SqlJetException {
                if (!SqlJetIndexScopeCursor.this.checkScope()) {
                    SqlJetIndexScopeCursor.this.next();
                }
                return false;
            }
        });
    }

    @Override
    public long getRowId() throws SqlJetException {
        return (Long)this.db.runSynchronized(new ISqlJetEngineSynchronized(){

            @Override
            public Object runSynchronized(SqlJetEngine engine) throws SqlJetException {
                if (SqlJetIndexScopeCursor.this.indexTable != null && !SqlJetIndexScopeCursor.this.indexTable.eof()) {
                    return SqlJetIndexScopeCursor.this.indexTable.getKeyRowId();
                }
                return SqlJetIndexScopeCursor.super.getRowId();
            }
        });
    }
}

