/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetExpression;
import org.tmatesoft.sqljet.core.schema.ISqlJetExpression;
import org.tmatesoft.sqljet.core.schema.ISqlJetInTableExpression;

public class SqlJetInTableExpression
extends SqlJetExpression
implements ISqlJetInTableExpression {
    private final ISqlJetExpression expression;
    private final boolean not;
    private final String tableName;
    private final String databaseName;

    public SqlJetInTableExpression(CommonTree ast) throws SqlJetException {
        CommonTree child;
        assert ("in_table".equalsIgnoreCase(ast.getText()));
        int idx = 0;
        if ("not".equalsIgnoreCase((child = (CommonTree)ast.getChild(idx++)).getText())) {
            this.not = true;
            child = (CommonTree)ast.getChild(idx++);
        } else {
            this.not = false;
        }
        assert ("in".equalsIgnoreCase(child.getText()));
        CommonTree tableNode = (CommonTree)child.getChild(0);
        this.tableName = tableNode.getText();
        this.databaseName = tableNode.getChildCount() > 0 ? tableNode.getChild(0).getText() : null;
        this.expression = SqlJetInTableExpression.create((CommonTree)ast.getChild(idx));
    }

    @Override
    public ISqlJetExpression getExpression() {
        return this.expression;
    }

    @Override
    public boolean isNot() {
        return this.not;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getExpression());
        if (this.isNot()) {
            buffer.append(" NOT");
        }
        buffer.append(" IN ");
        if (this.getDatabaseName() != null) {
            buffer.append(this.getDatabaseName());
            buffer.append('.');
        }
        buffer.append(this.getTableName());
        return buffer.toString();
    }
}

