/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.browser.core.data;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.tmatesoft.sqljet.browser.core.IProgress;
import org.tmatesoft.sqljet.browser.core.data.DataRow;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableDef;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.sqljet.core.table.ISqlJetTable;
import org.tmatesoft.sqljet.core.table.ISqlJetTransaction;
import org.tmatesoft.sqljet.core.table.SqlJetDb;

public class DataTableModel
implements TableModel {
    private List<DataRow> myData;
    private String[] myNames;
    private long myIndex;

    public static TableModel createInstance(final ISqlJetTable table, final long fromID, final int pageSize, final IProgress progress) throws SqlJetException {
        if (table == null) {
            return new DefaultTableModel();
        }
        final ArrayList<DataRow> data = new ArrayList<DataRow>(pageSize);
        ISqlJetTableDef tableDef = table.getDefinition();
        ArrayList<String> names = new ArrayList<String>();
        for (ISqlJetColumnDef column : tableDef.getColumns()) {
            names.add(column.getName());
        }
        final String[] namesArray = names.toArray(new String[names.size()]);
        table.getDataBase().runReadTransaction(new ISqlJetTransaction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run(SqlJetDb db) throws SqlJetException {
                try (ISqlJetCursor cursor = table.open();){
                    for (long i = 0L; i < fromID && !cursor.eof(); ++i) {
                        cursor.next();
                    }
                    for (int count = 0; !cursor.eof() && count < pageSize; ++count) {
                        data.add(DataRow.read(cursor, fromID + (long)count, namesArray));
                        progress.current(count);
                        cursor.next();
                    }
                }
                return null;
            }
        });
        return new DataTableModel(data, namesArray, fromID);
    }

    private DataTableModel(List<DataRow> data, String[] names, long fromIndex) {
        this.myData = data;
        this.myNames = names;
        this.myIndex = fromIndex;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Object.class;
    }

    @Override
    public int getColumnCount() {
        return this.myNames.length + 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "";
        }
        return this.myNames[columnIndex - 1];
    }

    public long getFirstIndex() {
        return this.myIndex;
    }

    @Override
    public int getRowCount() {
        return this.myData.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (--columnIndex < 0) {
            return this.myData.get(rowIndex).getID() + 1L;
        }
        return this.myData.get(rowIndex).getValueAt(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }
}

