/*
 * Decompiled with CFR 0.152.
 */
package jsci.physics.quantum;

import jsci.maths.Complex;
import jsci.maths.algebras.Module;
import jsci.maths.fields.Ring;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.matrices.ComplexSquareMatrix;
import jsci.maths.vectors.AbstractComplexVector;
import jsci.maths.vectors.MathVector;
import jsci.maths.vectors.VectorDimensionException;
import jsci.physics.quantum.BraVector;
import jsci.physics.quantum.Operator;

public final class KetVector
extends MathVector {
    private AbstractComplexVector representation;

    public KetVector(AbstractComplexVector rep) {
        super(rep.dimension());
        this.representation = rep;
    }

    public boolean equals(Object a) {
        return this.representation.equals(((KetVector)a).representation);
    }

    public String toString() {
        return this.representation.toString();
    }

    public int hashCode() {
        return this.representation.hashCode();
    }

    public BraVector toBraVector() {
        return new BraVector(this.representation.conjugate());
    }

    public AbstractComplexVector getRepresentation() {
        return this.representation;
    }

    @Override
    public double norm() {
        return this.representation.norm();
    }

    @Override
    public Object getSet() {
        return this.representation.getSet();
    }

    @Override
    public AbelianGroup.Member negate() {
        return this.representation.negate();
    }

    @Override
    public AbelianGroup.Member add(AbelianGroup.Member v) {
        if (v instanceof KetVector) {
            return this.add((KetVector)v);
        }
        throw new IllegalArgumentException("Vector class not recognised by this method.");
    }

    public KetVector add(KetVector v) {
        return new KetVector(this.representation.add(v.representation));
    }

    @Override
    public AbelianGroup.Member subtract(AbelianGroup.Member v) {
        if (v instanceof KetVector) {
            return this.subtract((KetVector)v);
        }
        throw new IllegalArgumentException("Vector class not recognised by this method.");
    }

    public KetVector subtract(KetVector v) {
        return new KetVector(this.representation.subtract(v.representation));
    }

    @Override
    public Module.Member scalarMultiply(Ring.Member x) {
        return this.representation.scalarMultiply(x);
    }

    public Operator multiply(BraVector bra) {
        int ketDim = this.dimension();
        if (ketDim == bra.dimension()) {
            AbstractComplexVector braRep = bra.getRepresentation();
            Complex[][] array = new Complex[ketDim][ketDim];
            for (int i = 0; i < ketDim; ++i) {
                array[i][0] = this.representation.getComponent(i).multiply(braRep.getComponent(0));
                for (int j = 1; j < ketDim; ++j) {
                    array[i][j] = this.representation.getComponent(i).multiply(braRep.getComponent(j));
                }
            }
            return new Operator(new ComplexSquareMatrix(array));
        }
        throw new VectorDimensionException("Vectors have different dimensions.");
    }
}

