/*
 * Decompiled with CFR 0.152.
 */
package jsci.physics.quantum;

import jsci.maths.matrices.AbstractComplexMatrix;
import jsci.maths.matrices.AbstractComplexSquareMatrix;
import jsci.physics.quantum.KetVector;
import jsci.physics.quantum.Operator;
import jsci.physics.quantum.Projector;

public final class DensityMatrix
extends Operator {
    private static AbstractComplexSquareMatrix constructor(KetVector[] kets, double[] probs) {
        AbstractComplexMatrix rep = new Projector(kets[0]).getRepresentation().scalarMultiply(probs[0]);
        for (int i = 1; i < kets.length; ++i) {
            rep = rep.add(new Projector(kets[i]).getRepresentation().scalarMultiply(probs[i]));
        }
        return (AbstractComplexSquareMatrix)rep;
    }

    private static AbstractComplexSquareMatrix constructor(Projector[] projs, double[] probs) {
        AbstractComplexMatrix rep = projs[0].getRepresentation().scalarMultiply(probs[0]);
        for (int i = 1; i < projs.length; ++i) {
            rep = rep.add(projs[i].getRepresentation().scalarMultiply(probs[i]));
        }
        return (AbstractComplexSquareMatrix)rep;
    }

    public DensityMatrix(KetVector[] kets, double[] probs) {
        super(DensityMatrix.constructor(kets, probs));
    }

    public DensityMatrix(Projector[] projs, double[] probs) {
        super(DensityMatrix.constructor(projs, probs));
    }

    public boolean isPureState() {
        return this.representation.equals(this.representation.multiply(this.representation));
    }
}

