/*
 * Decompiled with CFR 0.152.
 */
package jsci.physics;

import jsci.physics.ClassicalParticle3D;
import jsci.physics.Force3D;

public class GravityField {
    private final ClassicalParticle3D source;

    public GravityField(ClassicalParticle3D p) {
        this.source = p;
    }

    public double energy(ClassicalParticle3D p) {
        double dx = p.x - this.source.x;
        double dy = p.y - this.source.y;
        double dz = p.z - this.source.z;
        double r = Math.sqrt(dx * dx + dy * dy + dz * dz);
        return -6.67259E-11 * this.source.getMass() * p.getMass() / r;
    }

    public Force3D createForce(ClassicalParticle3D p) {
        return new Force(p);
    }

    private class Force
    extends Force3D {
        private final ClassicalParticle3D p;
        private double x;
        private double y;
        private double z;

        public Force(ClassicalParticle3D p) {
            this.p = p;
        }

        private void calculate() {
            double dx = this.p.x - ((GravityField)GravityField.this).source.x;
            double dy = this.p.y - ((GravityField)GravityField.this).source.y;
            double dz = this.p.z - ((GravityField)GravityField.this).source.z;
            double rr = dx * dx + dy * dy + dz * dz;
            double r = Math.sqrt(rr);
            double magnitude = -6.67259E-11 * GravityField.this.source.getMass() * this.p.getMass() / rr;
            this.x = magnitude * dx / r;
            this.y = magnitude * dy / r;
            this.z = magnitude * dz / r;
        }

        @Override
        public double getXComponent(double t) {
            this.calculate();
            return this.x;
        }

        @Override
        public double getYComponent(double t) {
            this.calculate();
            return this.y;
        }

        @Override
        public double getZComponent(double t) {
            this.calculate();
            return this.z;
        }
    }
}

