/*
 * Decompiled with CFR 0.152.
 */
package jsci.physics;

import jsci.maths.vectors.AbstractDoubleVector;
import jsci.maths.vectors.Double2Vector;
import jsci.physics.AbstractClassicalParticle;

public class ClassicalParticle2D
extends AbstractClassicalParticle {
    protected double mass;
    protected double x;
    protected double y;
    protected double vx;
    protected double vy;

    public void setMass(double m) {
        this.mass = m;
    }

    @Override
    public double getMass() {
        return this.mass;
    }

    public void setPosition(double xPos, double yPos) {
        this.x = xPos;
        this.y = yPos;
    }

    @Override
    public AbstractDoubleVector getPosition() {
        return new Double2Vector(this.x, this.y);
    }

    public void setXPosition(double xPos) {
        this.x = xPos;
    }

    public double getXPosition() {
        return this.x;
    }

    public void setYPosition(double yPos) {
        this.y = yPos;
    }

    public double getYPosition() {
        return this.y;
    }

    public void setVelocity(double xVel, double yVel) {
        this.vx = xVel;
        this.vy = yVel;
    }

    @Override
    public AbstractDoubleVector getVelocity() {
        return new Double2Vector(this.vx, this.vy);
    }

    public double getXVelocity() {
        return this.vx;
    }

    public double getYVelocity() {
        return this.vy;
    }

    @Override
    public double speed() {
        return Math.sqrt(this.vx * this.vx + this.vy * this.vy);
    }

    public void setMomentum(double xMom, double yMom) {
        this.vx = xMom / this.mass;
        this.vy = yMom / this.mass;
    }

    @Override
    public AbstractDoubleVector getMomentum() {
        return new Double2Vector(this.mass * this.vx, this.mass * this.vy);
    }

    public double getXMomentum() {
        return this.mass * this.vx;
    }

    public double getYMomentum() {
        return this.mass * this.vy;
    }

    @Override
    public double energy() {
        return this.mass * (this.vx * this.vx + this.vy * this.vy) / 2.0;
    }

    public ClassicalParticle2D move(double dt) {
        return this.translate(dt);
    }

    public ClassicalParticle2D translate(double dt) {
        this.x += this.vx * dt;
        this.y += this.vy * dt;
        return this;
    }

    public ClassicalParticle2D accelerate(double ax, double ay, double dt) {
        this.vx += ax * dt;
        this.vy += ay * dt;
        return this;
    }

    public ClassicalParticle2D applyForce(double Fx, double Fy, double dt) {
        return this.accelerate(Fx / this.mass, Fy / this.mass, dt);
    }

    public ClassicalParticle2D gravitate(ClassicalParticle2D p, double dt) {
        double dx = p.x - this.x;
        double dy = p.y - this.y;
        double rr = dx * dx + dy * dy;
        double r = Math.sqrt(rr);
        double g = p.mass / rr;
        double pg = this.mass / rr;
        this.vx -= g * dx * dt / r;
        this.vy -= g * dy * dt / r;
        p.vx += pg * dx * dt / r;
        p.vy += pg * dy * dt / r;
        return this;
    }

    public ClassicalParticle2D collide(ClassicalParticle2D p, double theta) {
        double totalMass = this.mass + p.mass;
        double deltaVx = p.vx - this.vx;
        double deltaVy = p.vy - this.vy;
        double cos = Math.cos(theta);
        double sin = Math.sin(theta);
        this.vx += p.mass * (deltaVx * cos + deltaVy * sin + deltaVx) / totalMass;
        this.vy += p.mass * (deltaVy * cos - deltaVx * sin + deltaVy) / totalMass;
        p.vx -= this.mass * (deltaVx * cos + deltaVy * sin + deltaVx) / totalMass;
        p.vy -= this.mass * (deltaVy * cos - deltaVx * sin + deltaVy) / totalMass;
        return this;
    }
}

