/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.wavelet.daubechies7;

import jsci.maths.ArrayMath;
import jsci.maths.NumericalConstants;
import jsci.maths.WaveletMath;
import jsci.maths.wavelet.Cascades;
import jsci.maths.wavelet.Filter;
import jsci.maths.wavelet.IllegalScalingException;
import jsci.maths.wavelet.Multiresolution;
import jsci.maths.wavelet.MultiscaleFunction;
import jsci.maths.wavelet.daubechies7.Scaling7;
import jsci.maths.wavelet.daubechies7.Wavelet7;

public final class Daubechies7
extends Multiresolution
implements Filter,
NumericalConstants {
    protected static final int filtretype = 12;
    protected static final int minlength = 24;
    static final double[] vg = new double[]{0.0037926585342, -0.0014812259146, -0.0178704316511, 0.043155452582, 0.0960147679355, -0.070078291222, 0.0246656594886, 0.758162601964, 1.08578270981, 0.408183939725, -0.198056706807, -0.152463871896, 0.00567134268574, 0.014521394762};
    static final double[] v0temp = new double[]{0.7766665156, 0.6299119967};
    static final double[] v1temp = new double[]{-0.1148964921, 0.1416646431, -0.967164158, 0.1769842267};
    static final double[] v2temp = new double[]{-0.03218471381, 0.03968298692, 0.1563278738, 0.8016258409, -0.5564532662, 0.1438984865};
    static final double[] v3temp = new double[]{0.0221131144, -0.0272649443, 0.0424602256, 0.2682115073, 0.2563887092, -0.5363572642, -0.6324950327, 0.4142017603};
    static final double[] v4temp = new double[]{0.011999963, -0.01479566908, -0.05636972038, -0.2884098615, -0.271018864, 0.6266429769, -0.5971809113, 0.25822267, 0.05436350287, 0.144524295};
    static final double[] v5temp = new double[]{0.004175845107, -0.005148717734, -0.007440855354, -0.03382983614, -0.03079310698, 0.07981928189, 0.0572270758, 0.2319141981, -0.9107619432, -0.310429938, 0.03358655707, 0.08599791766};
    static final double[] v6temp = new double[]{-0.1031229858, 0.1271481897, 0.01056363589, -0.1109935195, -0.1694835353, -0.1066751168, 0.03522103457, 0.1052218705, -0.002477521992, -0.09262193855, -0.8918295201, -0.3112729161, 0.03153823148, 0.08075320692};
    static final double[] v7temp = new double[]{-0.1636840253, 0.2018185116, 0.02397992313, -0.1367621625, -0.2287872293, -0.2411625975, 0.1547745353, 0.1738003308, -0.2203021645, 0.7991821052, 0.04097263186, 0.07425536593, -0.2186097493, -0.07664414437, 0.007725319564, 0.01978057424};
    static final double[] v8temp = new double[]{-0.05079391756, 0.06262769271, 0.006693967094, -0.04652396311, -0.07498687931, -0.06670242581, 0.02830429724, 0.03953767158, 0.01915788427, 0.1080996941, -0.09385371148, 0.5278533401, 0.749576166, 0.2923381676, -0.1429933474, -0.1070457309, 0.004143065991, 0.01060826335};
    static final double[] v9temp = new double[]{-0.001495677487, 0.001844134781, 3.796088187E-4, -3.726476076E-4, -0.001313050363, -0.004257093968, 0.004767087176, 0.002983259636, -0.01353810327, 0.03517346347, 0.06457953904, -0.04929701131, 0.01763779822, 0.5365060286, 0.7675636132, 0.2885569171, -0.1400433929, -0.1077912821, 0.004010358474, 0.01026846759};
    static final double[] v10temp = new double[]{-3.03884129E-5, 3.746819061E-5, 1.201067262E-5, 1.591583744E-5, 1.765202958E-5, -5.058087991E-5, -2.976878538E-4, -5.384490113E-4, 0.002571676204, -9.401364213E-4, -0.01271271848, 0.03052112329, 0.0678973393, -0.04954313507, 0.01743713195, 0.5361004301, 0.7677643255, 0.288629956, -0.1400472373, -0.1078082259, 0.004010244932, 0.01026817686};
    static final double[] v11temp = new double[]{-4.587815337E-8, 5.656667234E-8, 1.705493214E-8, 1.813824211E-8, 3.222871934E-8, -2.080479474E-8, -2.019192222E-7, -3.625456178E-7, -1.335197462E-7, 6.674082282E-8, 0.0026817644, -0.001047381271, -0.01263630033, 0.03051551953, 0.0678926908, -0.04955283591, 0.0174412551, 0.5361019173, 0.767764317, 0.2886296318, -0.1400472404, -0.1078082377, 0.004010244872, 0.01026817671};
    static final double[] vd0temp = new double[]{0.7004199839, 0.713730934};
    static final double[] vd1temp = new double[]{0.01053864722, -0.0103421034, 0.6658963651, 0.7458981223};
    static final double[] vd2temp = new double[]{-0.1757138133, 0.1724367832, -0.1665581445, 0.1535673633, -0.4422666014, 0.8321453685};
    static final double[] vd3temp = new double[]{0.1613128649, -0.1583044098, -0.3601719723, 0.317067412, 0.7182714497, 0.3180082506, -0.1351100609, 0.2887289881};
    static final double[] vd4temp = new double[]{0.2626733923, -0.2577745821, 0.05300977359, -0.05460956119, -0.07894206983, 0.08761351181, 0.1138292645, -0.008840156389, 0.1186027472, 0.904296895};
    static final double[] vd5temp = new double[]{-0.0990655253, 0.09721797156, 0.1575818939, -0.1379327181, 0.2550022277, 0.151459528, 0.8750776361, 0.06499770717, 0.2324452664, -0.09349432145, -0.04623379279, 0.1183889785};
    static final double[] vd6temp = new double[]{-0.06250197855, 0.06133632819, 0.007570194334, -0.005024723655, 0.02646032111, -0.009402290802, 0.06149372377, 0.05681683063, 0.02562598477, 0.02756686809, 0.936610373, -0.312065771, -0.03336171928, 0.08542222229};
    static final double[] vd7temp = new double[]{-0.4715917315, 0.4627966328, -0.009443328396, 0.02151032037, 0.04754578984, -0.17607089, -0.1591797424, 0.4829772924, 0.2074893977, 0.2895141132, -0.0405861945, 0.1026407474, 0.3418617349, -0.1182037757, -0.01210726949, 0.03100049663};
    static final double[] vd8temp = new double[]{-0.09439529077, 0.09263483604, -0.07325279539, 0.06801412471, -0.0232521704, -0.07869955176, -0.08937965975, 0.04016014208, 0.132824058, 0.06204454273, 0.1623006055, 0.6626531984, -0.6074912864, 0.2552288166, 0.1574205947, -0.1004613457, -0.004839078318, 0.01239039332};
    static final double[] vd9temp = new double[]{0.1594142646, -0.156441218, 0.007441639637, -0.01106491958, -0.02825478866, 0.05459386943, -0.009775758534, -0.1478196128, -0.1113587794, -0.08536948628, 0.27516054, 0.6421729864, 0.6324608023, -0.01525303792, -0.08448334026, 0.0876265837, 0.03318133734, -0.01602650231, -0.001102323809, 0.002822484916};
    static final double[] vd10temp = new double[]{-0.006037533035, 0.005924934159, 0.001534054302, -0.001202064256, 0.003182693183, -2.822206008E-4, 0.008251845825, 0.006110061754, 0.006347460794, 0.001773857064, -0.1077767325, -0.1373538162, 0.2848100511, 0.7687892964, 0.5372655282, 0.01673410769, -0.04968993169, 0.06802066194, 0.0305211065, -0.01264613714, -0.001047456655, 0.002681998325};
    static final double[] vd11temp = new double[]{-2.814830317E-5, 2.762334252E-5, -2.993814193E-5, 2.750781612E-5, 1.564675966E-5, -1.442059454E-5, 2.143345853E-5, -4.969368764E-5, -5.136649938E-5, 2.578289227E-5, 0.01026729934, 0.004010109626, -0.1078074809, -0.1400480006, 0.2886301179, 0.7677642441, 0.5361017227, 0.01744136474, -0.04955281693, 0.06789267353, 0.03051551282, -0.01263630236, -0.001047384891, 0.002681814574};
    static final double[] v0 = ArrayMath.scalarMultiply(1.4142135623730951, v0temp);
    static final double[] v1 = ArrayMath.scalarMultiply(1.4142135623730951, v1temp);
    static final double[] v2 = ArrayMath.scalarMultiply(1.4142135623730951, v2temp);
    static final double[] v3 = ArrayMath.scalarMultiply(1.4142135623730951, v3temp);
    static final double[] v4 = ArrayMath.scalarMultiply(1.4142135623730951, v4temp);
    static final double[] v5 = ArrayMath.scalarMultiply(1.4142135623730951, v5temp);
    static final double[] v6 = ArrayMath.scalarMultiply(1.4142135623730951, v6temp);
    static final double[] v7 = ArrayMath.scalarMultiply(1.4142135623730951, v7temp);
    static final double[] v8 = ArrayMath.scalarMultiply(1.4142135623730951, v8temp);
    static final double[] v9 = ArrayMath.scalarMultiply(1.4142135623730951, v9temp);
    static final double[] v10 = ArrayMath.scalarMultiply(1.4142135623730951, v10temp);
    static final double[] v11 = ArrayMath.scalarMultiply(1.4142135623730951, v11temp);
    static final double[] vd0 = ArrayMath.invert(ArrayMath.scalarMultiply(1.4142135623730951, vd0temp));
    static final double[] vd1 = ArrayMath.invert(ArrayMath.scalarMultiply(1.4142135623730951, vd1temp));
    static final double[] vd2 = ArrayMath.invert(ArrayMath.scalarMultiply(1.4142135623730951, vd2temp));
    static final double[] vd3 = ArrayMath.invert(ArrayMath.scalarMultiply(1.4142135623730951, vd3temp));
    static final double[] vd4 = ArrayMath.invert(ArrayMath.scalarMultiply(1.4142135623730951, vd4temp));
    static final double[] vd5 = ArrayMath.invert(ArrayMath.scalarMultiply(1.4142135623730951, vd5temp));
    static final double[] vd6 = ArrayMath.invert(ArrayMath.scalarMultiply(1.4142135623730951, vd6temp));
    static final double[] vd7 = ArrayMath.invert(ArrayMath.scalarMultiply(1.4142135623730951, vd7temp));
    static final double[] vd8 = ArrayMath.invert(ArrayMath.scalarMultiply(1.4142135623730951, vd8temp));
    static final double[] vd9 = ArrayMath.invert(ArrayMath.scalarMultiply(1.4142135623730951, vd9temp));
    static final double[] vd10 = ArrayMath.invert(ArrayMath.scalarMultiply(1.4142135623730951, vd10temp));
    static final double[] vd11 = ArrayMath.invert(ArrayMath.scalarMultiply(1.4142135623730951, vd11temp));
    static final double[] vgtemp = ArrayMath.scalarMultiply(0.7071067811865475, vg);
    static final double[] phvg = WaveletMath.lowToHigh(vgtemp);
    static final double[] phv0 = new double[]{0.3969456608, -0.4894245622, -0.1235692328, -0.02582101893, -0.1328855813, -0.01202996209, 0.3801419403, 0.6231415519, 0.190552645, 0.005893964132, 1.561741876E-4, 6.031669262E-6, -4.927938364E-7, -1.261756223E-6};
    static final double[] phv1 = new double[]{-0.323370029, 0.3987075576, 0.1351807407, 0.2096521373, 0.4833387568, 0.372004348, 0.2556921125, 0.4668718999, 0.1373682453, 0.002872512719, -0.001360874965, -0.001949202336, 8.74349099E-4, 3.629247193E-4, -2.999653169E-5, -7.680570657E-5};
    static final double[] phv2 = new double[]{-0.2823703425, 0.3481559189, 0.02903665693, -0.3033125208, -0.4606818655, -0.2824761359, 0.0593631048, 0.2414473445, 0.2265766807, -0.4453082198, 0.315842544, -0.006883194783, -0.03045582749, -0.0403024027, 0.01788874193, 0.007517433396, -6.12239933E-4, -0.001567631908};
    static final double[] phv3 = new double[]{-0.005050738626, 0.006227440642, 0.00118612215, -0.001781771641, -0.005423430571, -0.0151820599, 0.02487591795, 0.02339536126, -0.108843205, 0.1555511237, 0.2777338303, -0.7671513525, 0.536925485, -0.01606926084, -0.05015309817, -0.06812578033, 0.0305271507, 0.01268650625, -0.00104705859, -0.002680979085};
    static final double[] phv4 = new double[]{-1.153350842E-4, 1.422054166E-4, 4.560875753E-5, 6.053691674E-5, 6.687225073E-5, -1.932039563E-4, -0.001135318214, -0.00205358949, 0.00984943806, -0.003601089889, -0.1080997299, 0.140068673, 0.2886474191, -0.7677274911, 0.5360863094, -0.01744690015, -0.04955276912, -0.06789145494, 0.03051552376, 0.01263634496, -0.001047384658, -0.002681813977};
    static final double[] phv5 = new double[]{-1.756594007E-7, 2.165838647E-7, 6.530033661E-8, 6.944811113E-8, 1.233981379E-7, -7.965760361E-8, -7.731119139E-7, -1.388121081E-6, -5.112227575E-7, 2.555383959E-7, 0.01026798462, -0.00401023102, -0.1078082259, 0.1400472648, 0.2886296214, -0.7677643207, 0.5361019171, -0.01744125426, -0.04955283493, -0.06789269348, 0.03051551317, 0.0126363034, -0.001047384889, -0.002681814568};
    static final double[] phvd0temp = new double[]{0.3287269241, -0.3225962277, -0.03486576217, 0.02200880144, -0.401325331, -0.08807413471, 0.07139363748, 0.7005967686, 0.2475030985, -0.2451712749, 0.007181777146, 2.499604984E-5, -8.073680719E-9, -3.908981471E-8};
    static final double[] phvd1temp = new double[]{0.05957737342, -0.05846626641, 0.4582097589, -0.4107166017, 0.2022914839, 0.299717227, -0.3986325494, -0.06261552962, 0.5532851486, -0.1200134025, 0.01616443953, -0.003615532478, -0.001770925212, 0.001363254906, 5.071037744E-5, -1.29843211E-4};
    static final double[] phvd2temp = new double[]{0.01154439687, -0.011329096, -0.3933408112, 0.3508326132, -0.1045297744, -0.1942431291, 0.04053278706, -0.395649821, 0.7001774443, -0.05344583491, -0.006098922304, -0.07677883475, 0.1158196639, -0.0441294716, -0.02089669169, 0.01616290641, 5.971498449E-4, -0.001528993947};
    static final double[] phvd3temp = new double[]{0.03435795707, -0.03371718752, 0.003919592661, -0.004452130171, -0.00272834864, 0.01439788762, 0.01012896303, -0.03223449962, -0.02185300516, -0.02044704093, 0.0684349976, 0.02980333628, 0.04539318191, -0.5452752162, 0.7607344157, -0.2839752561, -0.1395508493, 0.1071639975, 0.00400022229, -0.01024251403};
    static final double[] phvd4temp = new double[]{-0.001619528496, 0.001589324589, 3.554364827E-4, -2.723954613E-4, 8.54957521E-4, -9.551275473E-5, 0.002187750783, 0.001520814609, 0.001580292226, 5.022963426E-4, -0.01263138978, -0.02981485818, 0.06690165825, 0.0498333704, 0.0177556326, -0.5362889286, 0.7677311001, -0.2885962362, -0.1400458666, 0.1078059333, 0.004010225471, -0.01026812703};
    static final double[] phvd5temp = new double[]{-7.351578516E-6, 7.214472934E-6, -7.819175985E-6, 7.184425358E-6, 4.086432729E-6, -3.766364036E-6, 5.597958787E-6, -1.297860916E-5, -1.341567344E-5, 6.733817189E-6, 0.002681585429, 0.001047349568, -0.01263610581, -0.03051571178, 0.06789282065, 0.04955281636, 0.01744120464, -0.5361018885, 0.7677643218, -0.288629637, -0.1400472405, 0.107808238, 0.004010244871, -0.01026817671};
    static final double[] phvd0 = ArrayMath.invert(phvd0temp);
    static final double[] phvd1 = ArrayMath.invert(phvd1temp);
    static final double[] phvd2 = ArrayMath.invert(phvd2temp);
    static final double[] phvd3 = ArrayMath.invert(phvd3temp);
    static final double[] phvd4 = ArrayMath.invert(phvd4temp);
    static final double[] phvd5 = ArrayMath.invert(phvd5temp);

    @Override
    public int getFilterType() {
        return 12;
    }

    @Override
    public MultiscaleFunction primaryScaling(int n0, int k) {
        return new Scaling7(n0, k);
    }

    @Override
    public MultiscaleFunction dualScaling(int n0, int k) {
        return new Scaling7(n0, k);
    }

    @Override
    public MultiscaleFunction primaryWavelet(int n0, int k) {
        return new Wavelet7(n0, k);
    }

    @Override
    public MultiscaleFunction dualWavelet(int n0, int k) {
        return new Wavelet7(n0, k);
    }

    @Override
    public int previousDimension(int k) {
        return Cascades.previousDimension(12, k);
    }

    @Override
    public double[] lowpass(double[] v, double[] param) {
        return this.lowpass(v);
    }

    @Override
    public double[] highpass(double[] v, double[] param) {
        return this.highpass(v);
    }

    @Override
    public double[] lowpass(double[] gete) {
        if (gete.length < 24) {
            throw new IllegalScalingException("The array is not long enough : " + gete.length + " < " + 24);
        }
        double[] sortie = new double[2 * gete.length - 12];
        int dl0 = gete.length - 1;
        for (int k = 12; k <= dl0 - 12; ++k) {
            for (int L = -7; L < 7; ++L) {
                int n = 2 * k + L - 5;
                sortie[n] = sortie[n] + vg[L + 7] * gete[k];
            }
        }
        sortie = ArrayMath.add(sortie, gete[0], v0, 0);
        sortie = ArrayMath.add(sortie, gete[1], v1, 0);
        sortie = ArrayMath.add(sortie, gete[2], v2, 0);
        sortie = ArrayMath.add(sortie, gete[3], v3, 0);
        sortie = ArrayMath.add(sortie, gete[4], v4, 0);
        sortie = ArrayMath.add(sortie, gete[5], v5, 0);
        sortie = ArrayMath.add(sortie, gete[6], v6, 0);
        sortie = ArrayMath.add(sortie, gete[7], v7, 0);
        sortie = ArrayMath.add(sortie, gete[8], v8, 0);
        sortie = ArrayMath.add(sortie, gete[9], v9, 0);
        sortie = ArrayMath.add(sortie, gete[10], v10, 0);
        sortie = ArrayMath.add(sortie, gete[11], v11, 0);
        int p0 = sortie.length - vd0.length;
        int p1 = sortie.length - vd1.length;
        int p2 = sortie.length - vd2.length;
        int p3 = sortie.length - vd3.length;
        int p4 = sortie.length - vd4.length;
        int p5 = sortie.length - vd5.length;
        int p6 = sortie.length - vd6.length;
        int p7 = sortie.length - vd7.length;
        int p8 = sortie.length - vd8.length;
        int p9 = sortie.length - vd9.length;
        int p10 = sortie.length - vd10.length;
        int p11 = sortie.length - vd11.length;
        sortie = ArrayMath.add(sortie, gete[dl0], vd0, p0);
        sortie = ArrayMath.add(sortie, gete[dl0 - 1], vd1, p1);
        sortie = ArrayMath.add(sortie, gete[dl0 - 2], vd2, p2);
        sortie = ArrayMath.add(sortie, gete[dl0 - 3], vd3, p3);
        sortie = ArrayMath.add(sortie, gete[dl0 - 4], vd4, p4);
        sortie = ArrayMath.add(sortie, gete[dl0 - 5], vd5, p5);
        sortie = ArrayMath.add(sortie, gete[dl0 - 6], vd6, p6);
        sortie = ArrayMath.add(sortie, gete[dl0 - 7], vd7, p7);
        sortie = ArrayMath.add(sortie, gete[dl0 - 8], vd8, p8);
        sortie = ArrayMath.add(sortie, gete[dl0 - 9], vd9, p9);
        sortie = ArrayMath.add(sortie, gete[dl0 - 10], vd10, p10);
        sortie = ArrayMath.add(sortie, gete[dl0 - 11], vd11, p11);
        return sortie;
    }

    @Override
    public double[] highpass(double[] gete) {
        if (gete.length < 12) {
            throw new IllegalScalingException("The array is not long enough : " + gete.length + " < " + 12);
        }
        double[] sortie = new double[2 * gete.length + 12];
        int dl0 = gete.length - 1;
        for (int k = 6; k <= dl0 - 6; ++k) {
            for (int L = -7; L < 7; ++L) {
                int n = 2 * k + L + 7;
                sortie[n] = sortie[n] + phvg[L + 7] * gete[k];
            }
        }
        sortie = ArrayMath.add(sortie, gete[0], phv0, 0);
        int p0 = sortie.length - phvd0.length;
        sortie = ArrayMath.add(sortie, gete[dl0], phvd0, p0);
        sortie = ArrayMath.add(sortie, gete[1], phv1, 0);
        int p1 = sortie.length - phvd1.length;
        sortie = ArrayMath.add(sortie, gete[dl0 - 1], phvd1, p1);
        sortie = ArrayMath.add(sortie, gete[2], phv2, 0);
        int p2 = sortie.length - phvd2.length;
        sortie = ArrayMath.add(sortie, gete[dl0 - 2], phvd2, p2);
        sortie = ArrayMath.add(sortie, gete[3], phv3, 0);
        int p3 = sortie.length - phvd3.length;
        sortie = ArrayMath.add(sortie, gete[dl0 - 3], phvd3, p3);
        sortie = ArrayMath.add(sortie, gete[4], phv4, 0);
        int p4 = sortie.length - phvd4.length;
        sortie = ArrayMath.add(sortie, gete[dl0 - 4], phvd4, p4);
        sortie = ArrayMath.add(sortie, gete[5], phv5, 0);
        int p5 = sortie.length - phvd5.length;
        sortie = ArrayMath.add(sortie, gete[dl0 - 5], phvd5, p5);
        return sortie;
    }

    public double[] evalScaling(int n0, int k, int j1) {
        return Cascades.evalScaling(this, n0, j1, k);
    }

    public double[] evalWavelet(int n0, int k, int j1) {
        return Cascades.evalWavelet(this, 12, n0, j1, k);
    }
}

