/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.wavelet.daubechies2;

import jsci.maths.wavelet.FWT;

public final class FastDaubechies2
extends FWT {
    private static final float root3 = (float)Math.sqrt(3.0);
    private static final float normalizer = (float)Math.pow(2.0, -0.5);
    static final float[] scale = new float[]{(1.0f + root3) * normalizer / 4.0f, (3.0f + root3) * normalizer / 4.0f, (3.0f + -1.0f * root3) * normalizer / 4.0f, (1.0f + -1.0f * root3) * normalizer / 4.0f};
    static final float[] wavelet = new float[]{-(1.0f + -1.0f * root3) * normalizer / 4.0f, (3.0f + -1.0f * root3) * normalizer / 4.0f, -(3.0f + root3) * normalizer / 4.0f, (1.0f + root3) * normalizer / 4.0f};

    public static void transform(float[] v, int last) {
        float[] ans = new float[last];
        int half = last / 2;
        try {
            int k = 0;
            while (true) {
                ans[k + half] = v[2 * k + 0] * wavelet[0] + v[2 * k + 1] * wavelet[1] + v[2 * k + 2] * wavelet[2] + v[2 * k + 3] * wavelet[3];
                ans[k] = v[2 * k + 0] * scale[0] + v[2 * k + 1] * scale[1] + v[2 * k + 2] * scale[2] + v[2 * k + 3] * scale[3];
                ++k;
            }
        }
        catch (IndexOutOfBoundsException e) {
            ans[last - 1] = v[last - 2] * wavelet[0] + v[last - 1] * wavelet[1] + v[0] * wavelet[2] + v[1] * wavelet[3];
            ans[half - 1] = v[last - 2] * scale[0] + v[last - 1] * scale[1] + v[0] * scale[2] + v[1] * scale[3];
            System.arraycopy(ans, 0, v, 0, last);
            return;
        }
    }

    @Override
    public void transform(float[] v) {
        int last;
        for (last = v.length; last > 4; last /= 2) {
            FastDaubechies2.transform(v, last);
        }
        if (last != 4) {
            System.err.println("Careful! this should be a power of 2 : " + v.length);
        }
    }

    @Override
    public void invTransform(float[] v) {
        int last = 4;
        while (2 * last <= v.length) {
            FastDaubechies2.invTransform(v, last);
            last *= 2;
        }
        if (last != v.length) {
            System.err.println("Careful! this should be a power of 2 : " + v.length);
        }
    }

    public static void invTransform(float[] v, int last) {
        int ResultingLength = 2 * last;
        float[] ans = new float[ResultingLength];
        try {
            int k = 0;
            while (true) {
                int n = 2 * k + 3;
                ans[n] = ans[n] + (scale[3] * v[k] + wavelet[3] * v[k + last]);
                int n2 = 2 * k + 2;
                ans[n2] = ans[n2] + (scale[2] * v[k] + wavelet[2] * v[k + last]);
                int n3 = 2 * k + 1;
                ans[n3] = ans[n3] + (scale[1] * v[k] + wavelet[1] * v[k + last]);
                int n4 = 2 * k + 0;
                ans[n4] = ans[n4] + (scale[0] * v[k] + wavelet[0] * v[k + last]);
                ++k;
            }
        }
        catch (IndexOutOfBoundsException e) {
            int n = ResultingLength - 2;
            ans[n] = ans[n] + (scale[0] * v[last - 1] + wavelet[0] * v[ResultingLength - 1]);
            int n5 = ResultingLength - 1;
            ans[n5] = ans[n5] + (scale[1] * v[last - 1] + wavelet[1] * v[ResultingLength - 1]);
            ans[0] = ans[0] + (scale[2] * v[last - 1] + wavelet[2] * v[ResultingLength - 1]);
            ans[1] = ans[1] + (scale[3] * v[last - 1] + wavelet[3] * v[ResultingLength - 1]);
            System.arraycopy(ans, 0, v, 0, ans.length);
            return;
        }
    }
}

