/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.wavelet;

import jsci.maths.ArrayMath;
import jsci.maths.NumericalConstants;
import jsci.maths.wavelet.MultiscaleFunction;

public final class Sine
extends MultiscaleFunction
implements NumericalConstants,
Cloneable {
    private int n0;
    private int freq;
    private double normalisation;

    @Override
    public String toString() {
        String ans = new String("[n0=");
        ans.concat(Integer.toString(this.n0));
        ans.concat("][freq=");
        ans.concat(Integer.toString(this.freq));
        ans.concat("]");
        return ans;
    }

    public Sine(int N0, int FREQ) {
        if (N0 < 0) {
            throw new IllegalArgumentException("The length paramenter " + N0 + " must be positive");
        }
        if (FREQ < 0 || FREQ >= N0) {
            throw new IllegalArgumentException("The frequency parameter " + FREQ + " must be between " + 0 + " and " + (N0 - 1));
        }
        this.n0 = N0;
        this.freq = FREQ;
        this.normalisation = Math.sqrt((double)this.n0 / 2.0);
    }

    @Override
    public boolean equals(Object a) {
        if (a != null && a instanceof Sine) {
            Sine iv = (Sine)a;
            return this.dimension(0) == iv.dimension(0) && this.getFrequency() == iv.getFrequency();
        }
        return false;
    }

    public int getFrequency() {
        return this.freq;
    }

    public double[] evaluate() {
        return ArrayMath.scalarMultiply(1.0 / this.normalisation, Sine.evaluate(this.n0, this.freq));
    }

    private static double[] evaluate(int N0, int FREQ) {
        double[] ans = new double[N0];
        for (int k = 0; k < ans.length; ++k) {
            ans[k] = Math.sin(Math.PI * 2 * (double)k * (double)FREQ / (double)N0);
        }
        return ans;
    }

    @Override
    public int dimension(int jfin) {
        return this.n0;
    }

    @Override
    public int dimension() {
        return this.n0;
    }

    @Override
    public Object clone() {
        Sine s = (Sine)super.clone();
        s.n0 = this.n0;
        s.freq = this.freq;
        return s;
    }

    @Override
    public double[] evaluate(int j) {
        return this.evaluate();
    }

    @Override
    public double mass(double a, double b, int jfin) {
        double somme = 0.0;
        double[] values = this.evaluate(jfin);
        for (int k = 0; k < values.length; ++k) {
            somme += values[k];
        }
        somme = somme / (double)(values.length - 1) * Math.abs(b - a);
        return somme;
    }

    @Override
    public int getFilterType() {
        return this.n0;
    }
}

