/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.vectors;

import jsci.GlobalSettings;
import jsci.maths.Complex;
import jsci.maths.ComplexMapping;
import jsci.maths.algebras.HilbertSpace;
import jsci.maths.vectors.AbstractDoubleVector;
import jsci.maths.vectors.MathVector;

public abstract class AbstractComplexVector
extends MathVector
implements HilbertSpace.Member {
    protected AbstractComplexVector(int dim) {
        super(dim);
    }

    public final boolean equals(Object obj) {
        return this.equals(obj, GlobalSettings.ZERO_TOL);
    }

    public boolean equals(Object obj, double tol) {
        if (obj != null && obj instanceof AbstractComplexVector) {
            AbstractComplexVector vec = (AbstractComplexVector)obj;
            return this.dimension() == vec.dimension() && this.subtract(vec).norm() <= tol;
        }
        return false;
    }

    public String toString() {
        int i;
        StringBuffer buf = new StringBuffer(12 * this.N);
        for (i = 0; i < this.N - 1; ++i) {
            buf.append(this.getComponent(i).toString());
            buf.append(',');
        }
        buf.append(this.getComponent(i).toString());
        return buf.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.norm());
    }

    public abstract AbstractDoubleVector real();

    public abstract AbstractDoubleVector imag();

    public abstract Complex getComponent(int var1);

    public abstract double getRealComponent(int var1);

    public abstract double getImagComponent(int var1);

    public abstract void setComponent(int var1, Complex var2);

    public abstract void setComponent(int var1, double var2, double var4);

    @Override
    public Object getSet() {
        throw new RuntimeException("Not implemented: file bug");
    }

    @Override
    public double norm() {
        double answer = this.getRealComponent(0) * this.getRealComponent(0) + this.getImagComponent(0) * this.getImagComponent(0);
        for (int i = 1; i < this.N; ++i) {
            answer += this.getRealComponent(i) * this.getRealComponent(i) + this.getImagComponent(i) * this.getImagComponent(i);
        }
        return Math.sqrt(answer);
    }

    public double infNorm() {
        double infNorm = this.getComponent(0).mod();
        for (int i = 1; i < this.N; ++i) {
            double mod = this.getComponent(i).mod();
            if (!(mod > infNorm)) continue;
            infNorm = mod;
        }
        return infNorm;
    }

    public abstract AbstractComplexVector conjugate();

    public abstract AbstractComplexVector add(AbstractComplexVector var1);

    public abstract AbstractComplexVector subtract(AbstractComplexVector var1);

    public abstract AbstractComplexVector scalarMultiply(Complex var1);

    public abstract AbstractComplexVector scalarMultiply(double var1);

    public abstract AbstractComplexVector scalarDivide(Complex var1);

    public abstract AbstractComplexVector scalarDivide(double var1);

    public AbstractComplexVector normalize() {
        return this.scalarDivide(this.norm());
    }

    public abstract Complex scalarProduct(AbstractComplexVector var1);

    public abstract AbstractComplexVector mapComponents(ComplexMapping var1);
}

