/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.symbolic;

import jsci.maths.Member;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.symbolic.Expression;
import jsci.maths.symbolic.Variable;

public class Constant
extends Expression {
    private final Member value;

    public Constant(Member x) {
        this.value = x;
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public Expression differentiate(Variable x) {
        return new Constant(((AbelianGroup)this.getSet()).zero());
    }

    @Override
    public Expression evaluate() {
        return this;
    }

    @Override
    protected int getPriority() {
        String sv = this.value.toString();
        if (sv.indexOf("+") != -1 || sv.indexOf("-") != -1) {
            return 0;
        }
        if (sv.indexOf("*") != -1) {
            return 10;
        }
        if (sv.indexOf("^") != -1) {
            return 15;
        }
        return 20;
    }

    @Override
    public Object getSet() {
        return this.value.getSet();
    }

    public Member getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        Object op = o instanceof Constant ? ((Constant)o).getValue() : o;
        return this.value.equals(op);
    }
}

