/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.matrices;

import jsci.maths.algebras.Module;
import jsci.maths.algebras.VectorSpace;
import jsci.maths.fields.Field;
import jsci.maths.fields.Ring;
import jsci.maths.groups.AbelianGroup;
import jsci.maths.matrices.Matrix;
import jsci.maths.matrices.MatrixDimensionException;

public class RingMatrix
extends Matrix {
    protected Ring.Member[][] matrix;

    protected RingMatrix(int rows, int cols) {
        super(rows, cols);
    }

    public RingMatrix(Ring.Member[][] array) {
        this(array.length, array[0].length);
        this.matrix = array;
    }

    public boolean equals(Object m) {
        if (m != null && m instanceof RingMatrix && this.numRows == ((RingMatrix)m).rows() && this.numCols == ((RingMatrix)m).columns()) {
            RingMatrix rm = (RingMatrix)m;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    if (this.matrix[i][j].equals(rm.getElement(i, j))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(5 * this.numRows * this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                buf.append(this.matrix[i][j].toString());
                buf.append(' ');
            }
            buf.append('\n');
        }
        return buf.toString();
    }

    public Ring.Member getElement(int i, int j) {
        if (i >= 0 && i < this.numRows && j >= 0 && j < this.numCols) {
            return this.matrix[i][j];
        }
        throw new MatrixDimensionException(RingMatrix.getInvalidElementMsg(i, j));
    }

    public void setElement(int i, int j, Ring.Member r) {
        if (i < 0 || i >= this.numRows || j < 0 || j >= this.numCols) {
            throw new MatrixDimensionException(RingMatrix.getInvalidElementMsg(i, j));
        }
        this.matrix[i][j] = r;
    }

    @Override
    public Object getSet() {
        throw new RuntimeException("Not yet implemented: please file bug report");
    }

    @Override
    public AbelianGroup.Member negate() {
        Ring.Member[][] array = new Ring.Member[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            array[i][0] = (Ring.Member)this.matrix[i][0].negate();
            for (int j = 1; j < this.numCols; ++j) {
                array[i][j] = (Ring.Member)this.matrix[i][j].negate();
            }
        }
        return new RingMatrix(array);
    }

    @Override
    public final AbelianGroup.Member add(AbelianGroup.Member m) {
        if (m instanceof RingMatrix) {
            return this.add((RingMatrix)m);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RingMatrix add(RingMatrix m) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            Ring.Member[][] array = new Ring.Member[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                array[i][0] = (Ring.Member)this.matrix[i][0].add(m.getElement(i, 0));
                for (int j = 1; j < this.numCols; ++j) {
                    array[i][j] = (Ring.Member)this.matrix[i][j].add(m.getElement(i, j));
                }
            }
            return new RingMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public final AbelianGroup.Member subtract(AbelianGroup.Member m) {
        if (m instanceof RingMatrix) {
            return this.subtract((RingMatrix)m);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RingMatrix subtract(RingMatrix m) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            Ring.Member[][] array = new Ring.Member[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                array[i][0] = (Ring.Member)this.matrix[i][0].subtract(m.getElement(i, 0));
                for (int j = 1; j < this.numCols; ++j) {
                    array[i][j] = (Ring.Member)this.matrix[i][j].subtract(m.getElement(i, j));
                }
            }
            return new RingMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public Module.Member scalarMultiply(Ring.Member r) {
        Ring.Member[][] array = new Ring.Member[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            array[i][0] = r.multiply(this.matrix[i][0]);
            for (int j = 1; j < this.numCols; ++j) {
                array[i][j] = r.multiply(this.matrix[i][j]);
            }
        }
        return new RingMatrix(array);
    }

    @Override
    public VectorSpace.Member scalarDivide(Field.Member x) {
        Ring.Member[][] array = new Ring.Member[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            array[i][0] = ((Field.Member)this.matrix[i][0]).divide(x);
            for (int j = 1; j < this.numCols; ++j) {
                array[i][j] = ((Field.Member)this.matrix[i][j]).divide(x);
            }
        }
        return new RingMatrix(array);
    }

    @Override
    public final Ring.Member multiply(Ring.Member m) {
        if (m instanceof RingMatrix) {
            return this.multiply((RingMatrix)m);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RingMatrix multiply(RingMatrix m) {
        if (this.numCols == m.numRows) {
            Ring.Member[][] array = new Ring.Member[this.numRows][m.numCols];
            for (int j = 0; j < this.numRows; ++j) {
                for (int k = 0; k < m.numCols; ++k) {
                    AbelianGroup.Member g = this.matrix[j][0].multiply(m.getElement(0, k));
                    for (int n = 1; n < this.numCols; ++n) {
                        g = g.add(this.matrix[j][n].multiply(m.getElement(n, k)));
                    }
                    array[j][k] = g;
                }
            }
            return new RingMatrix(array);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public RingMatrix directSum(RingMatrix m) {
        int j;
        int i;
        Ring.Member[][] array = new Ring.Member[this.numRows + m.numRows][this.numCols + m.numCols];
        for (i = 0; i < this.numRows; ++i) {
            for (j = 0; j < this.numCols; ++j) {
                array[i][j] = this.matrix[i][j];
            }
        }
        for (i = 0; i < m.numRows; ++i) {
            for (j = 0; j < m.numCols; ++j) {
                array[i + this.numRows][j + this.numCols] = m.getElement(i, j);
            }
        }
        return new RingMatrix(array);
    }

    public RingMatrix tensor(RingMatrix m) {
        Ring.Member[][] array = new Ring.Member[this.numRows * m.numRows][this.numCols * m.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                int k = 0;
                while (k < m.numRows) {
                    for (int l = 0; l < m.numCols; ++l) {
                        array[i * m.numRows + k][j * m.numCols + l] = this.matrix[i][j].multiply(m.getElement(k, l));
                    }
                    ++j;
                }
            }
        }
        return new RingMatrix(array);
    }

    @Override
    public Matrix transpose() {
        Ring.Member[][] array = new Ring.Member[this.numCols][this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            array[0][i] = this.matrix[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                array[j][i] = this.matrix[i][j];
            }
        }
        return new RingMatrix(array);
    }
}

