/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.matrices;

import jsci.maths.DimensionException;
import jsci.maths.ExtraMath;
import jsci.maths.MaximumIterationsExceededException;
import jsci.maths.matrices.AbstractComplexMatrix;
import jsci.maths.matrices.AbstractDoubleMatrix;
import jsci.maths.matrices.AbstractDoubleSquareMatrix;
import jsci.maths.matrices.AbstractIntegerMatrix;
import jsci.maths.matrices.AbstractIntegerSquareMatrix;
import jsci.maths.matrices.ComplexDiagonalMatrix;
import jsci.maths.matrices.DiagonalMatrix;
import jsci.maths.matrices.DoubleDiagonalMatrix;
import jsci.maths.matrices.IntegerSquareMatrix;
import jsci.maths.matrices.IntegerTridiagonalMatrix;
import jsci.maths.matrices.Matrix;
import jsci.maths.matrices.MatrixDimensionException;
import jsci.maths.matrices.TridiagonalMatrix;
import jsci.maths.vectors.AbstractIntegerVector;
import jsci.maths.vectors.IntegerVector;

public class IntegerDiagonalMatrix
extends AbstractIntegerSquareMatrix
implements DiagonalMatrix {
    protected final int[] diag;

    public IntegerDiagonalMatrix(int size) {
        this(new int[size]);
    }

    public IntegerDiagonalMatrix(int[][] array) {
        this(array.length);
        for (int i = 0; i < array.length; ++i) {
            if (array[i].length != array.length) {
                throw new MatrixDimensionException("Array is not square.");
            }
            this.diag[i] = array[i][i];
        }
    }

    public IntegerDiagonalMatrix(int[] array) {
        super(array.length);
        this.diag = array;
    }

    public static IntegerDiagonalMatrix identity(int size) {
        int[] array = new int[size];
        for (int i = 0; i < size; ++i) {
            array[i] = 1;
        }
        return new IntegerDiagonalMatrix(array);
    }

    @Override
    public boolean equals(AbstractIntegerMatrix m, double tol) {
        if (m instanceof DiagonalMatrix) {
            if (this.numRows != m.rows() || this.numCols != m.columns()) {
                return false;
            }
            int sumSqr = 0;
            int delta = this.diag[0] - m.getElement(0, 0);
            sumSqr += delta * delta;
            for (int i = 1; i < this.numRows; ++i) {
                delta = this.diag[i] - m.getElement(i, i);
                sumSqr += delta * delta;
            }
            return (double)sumSqr <= tol * tol;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(5 * this.numRows * this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                buf.append(this.getElement(i, j));
                buf.append(' ');
            }
            buf.append('\n');
        }
        return buf.toString();
    }

    @Override
    public AbstractDoubleMatrix toDoubleMatrix() {
        double[] array = new double[this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            array[i] = this.diag[i];
        }
        return new DoubleDiagonalMatrix(array);
    }

    @Override
    public AbstractComplexMatrix toComplexMatrix() {
        double[] array = new double[this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            array[i] = this.diag[i];
        }
        return new ComplexDiagonalMatrix(array, new double[this.numRows]);
    }

    @Override
    public int getElement(int i, int j) {
        if (i >= 0 && i < this.numRows && j >= 0 && j < this.numCols) {
            if (i == j) {
                return this.diag[i];
            }
            return 0;
        }
        throw new MatrixDimensionException(IntegerDiagonalMatrix.getInvalidElementMsg(i, j));
    }

    @Override
    public void setElement(int i, int j, int x) {
        if (i >= 0 && i < this.numRows && j >= 0 && j < this.numCols) {
            if (i != j) {
                throw new MatrixDimensionException(IntegerDiagonalMatrix.getInvalidElementMsg(i, j));
            }
        } else {
            throw new MatrixDimensionException(IntegerDiagonalMatrix.getInvalidElementMsg(i, j));
        }
        this.diag[i] = x;
    }

    @Override
    public boolean isSymmetric() {
        return true;
    }

    @Override
    public int det() {
        int det = this.diag[0];
        for (int i = 1; i < this.numRows; ++i) {
            det *= this.diag[i];
        }
        return det;
    }

    @Override
    public int trace() {
        int tr = this.diag[0];
        for (int i = 1; i < this.numRows; ++i) {
            tr += this.diag[i];
        }
        return tr;
    }

    @Override
    public int infNorm() {
        int result = Math.abs(this.diag[0]);
        for (int i = 1; i < this.numRows; ++i) {
            int tmpResult = Math.abs(this.diag[i]);
            if (tmpResult <= result) continue;
            result = tmpResult;
        }
        return result;
    }

    @Override
    public double frobeniusNorm() {
        double result = this.diag[0];
        for (int i = 1; i < this.numRows; ++i) {
            result = ExtraMath.hypot(result, this.diag[i]);
        }
        return result;
    }

    public double operatorNorm() throws MaximumIterationsExceededException {
        return this.infNorm();
    }

    @Override
    public AbstractIntegerSquareMatrix add(AbstractIntegerSquareMatrix m) {
        if (m instanceof IntegerDiagonalMatrix) {
            return this.add((IntegerDiagonalMatrix)m);
        }
        if (m instanceof DiagonalMatrix) {
            return this.addDiagonal(m);
        }
        if (m instanceof IntegerTridiagonalMatrix) {
            return this.add((IntegerTridiagonalMatrix)m);
        }
        if (m instanceof TridiagonalMatrix) {
            return this.addTridiagonal(m);
        }
        if (m instanceof IntegerSquareMatrix) {
            return this.add((IntegerSquareMatrix)m);
        }
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            int i;
            int[][] array = new int[this.numRows][this.numCols];
            for (i = 0; i < this.numRows; ++i) {
                array[i][0] = m.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    array[i][j] = m.getElement(i, j);
                }
            }
            for (i = 0; i < this.numRows; ++i) {
                int[] nArray = array[i];
                int n = i;
                nArray[n] = nArray[n] + this.diag[i];
            }
            return new IntegerSquareMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerSquareMatrix add(IntegerSquareMatrix m) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            int i;
            int[][] array = new int[this.numRows][this.numCols];
            for (i = 0; i < this.numRows; ++i) {
                System.arraycopy(m.matrix[i], 0, array[i], 0, this.numRows);
            }
            for (i = 0; i < this.numRows; ++i) {
                int[] nArray = array[i];
                int n = i;
                nArray[n] = nArray[n] + this.diag[i];
            }
            return new IntegerSquareMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerTridiagonalMatrix add(IntegerTridiagonalMatrix m) {
        if (this.numRows == m.numRows) {
            IntegerTridiagonalMatrix ans = new IntegerTridiagonalMatrix(this.numRows);
            System.arraycopy(m.ldiag, 0, ans.ldiag, 0, m.ldiag.length);
            System.arraycopy(m.udiag, 0, ans.udiag, 0, m.udiag.length);
            ans.diag[0] = this.diag[0] + m.diag[0];
            for (int i = 1; i < this.numRows; ++i) {
                ans.diag[i] = this.diag[i] + m.diag[i];
            }
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerTridiagonalMatrix addTridiagonal(AbstractIntegerSquareMatrix m) {
        int mRow = this.numRows;
        if (mRow == m.rows()) {
            IntegerTridiagonalMatrix ans = new IntegerTridiagonalMatrix(mRow);
            ans.diag[0] = this.diag[0] + m.getElement(0, 0);
            ans.udiag[0] = m.getElement(0, 1);
            --mRow;
            for (int i = 1; i < mRow; ++i) {
                ans.ldiag[i] = m.getElement(i, i - 1);
                ans.diag[i] = this.diag[i] + m.getElement(i, i);
                ans.udiag[i] = m.getElement(i, i + 1);
            }
            ans.ldiag[mRow] = m.getElement(mRow, mRow - 1);
            ans.diag[mRow] = this.diag[mRow] + m.getElement(mRow, mRow);
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerDiagonalMatrix add(IntegerDiagonalMatrix m) {
        if (this.numRows == m.numRows) {
            int[] array = new int[this.numRows];
            array[0] = this.diag[0] + m.diag[0];
            for (int i = 1; i < this.numRows; ++i) {
                array[i] = this.diag[i] + m.diag[i];
            }
            return new IntegerDiagonalMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerDiagonalMatrix addDiagonal(AbstractIntegerSquareMatrix m) {
        if (this.numRows == m.numRows) {
            int[] array = new int[this.numRows];
            array[0] = this.diag[0] + m.getElement(0, 0);
            for (int i = 1; i < this.numRows; ++i) {
                array[i] = this.diag[i] + m.getElement(i, i);
            }
            return new IntegerDiagonalMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public AbstractIntegerSquareMatrix subtract(AbstractIntegerSquareMatrix m) {
        if (m instanceof IntegerDiagonalMatrix) {
            return this.subtract((IntegerDiagonalMatrix)m);
        }
        if (m instanceof DiagonalMatrix) {
            return this.subtractDiagonal(m);
        }
        if (m instanceof IntegerTridiagonalMatrix) {
            return this.subtract((IntegerTridiagonalMatrix)m);
        }
        if (m instanceof TridiagonalMatrix) {
            return this.subtractTridiagonal(m);
        }
        if (m instanceof IntegerSquareMatrix) {
            return this.subtract((IntegerSquareMatrix)m);
        }
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            int i;
            int[][] array = new int[this.numRows][this.numCols];
            for (i = 0; i < this.numRows; ++i) {
                array[i][0] = -m.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    array[i][j] = -m.getElement(i, j);
                }
            }
            for (i = 0; i < this.numRows; ++i) {
                int[] nArray = array[i];
                int n = i;
                nArray[n] = nArray[n] + this.diag[i];
            }
            return new IntegerSquareMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerSquareMatrix subtract(IntegerSquareMatrix m) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            int i;
            int[][] array = new int[this.numRows][this.numCols];
            for (i = 0; i < this.numRows; ++i) {
                array[i][0] = -m.matrix[i][0];
                for (int j = 1; j < this.numCols; ++j) {
                    array[i][j] = -m.matrix[i][j];
                }
            }
            for (i = 0; i < this.numRows; ++i) {
                int[] nArray = array[i];
                int n = i;
                nArray[n] = nArray[n] + this.diag[i];
            }
            return new IntegerSquareMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerTridiagonalMatrix subtract(IntegerTridiagonalMatrix m) {
        int mRow = this.numRows;
        if (mRow == m.numRows) {
            IntegerTridiagonalMatrix ans = new IntegerTridiagonalMatrix(mRow);
            ans.diag[0] = this.diag[0] - m.diag[0];
            ans.udiag[0] = -m.udiag[0];
            --mRow;
            for (int i = 1; i < mRow; ++i) {
                ans.ldiag[i] = -m.ldiag[i];
                ans.diag[i] = this.diag[i] - m.diag[i];
                ans.udiag[i] = -m.udiag[i];
            }
            ans.ldiag[mRow] = -m.ldiag[mRow];
            ans.diag[mRow] = this.diag[mRow] - m.diag[mRow];
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerTridiagonalMatrix subtractTridiagonal(AbstractIntegerSquareMatrix m) {
        int mRow = this.numRows;
        if (mRow == m.rows()) {
            IntegerTridiagonalMatrix ans = new IntegerTridiagonalMatrix(mRow);
            ans.diag[0] = this.diag[0] - m.getElement(0, 0);
            ans.udiag[0] = -m.getElement(0, 1);
            --mRow;
            for (int i = 1; i < mRow; ++i) {
                ans.ldiag[i] = -m.getElement(i, i - 1);
                ans.diag[i] = this.diag[i] - m.getElement(i, i);
                ans.udiag[i] = -m.getElement(i, i + 1);
            }
            ans.ldiag[mRow] = -m.getElement(mRow, mRow - 1);
            ans.diag[mRow] = this.diag[mRow] - m.getElement(mRow, mRow);
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerDiagonalMatrix subtract(IntegerDiagonalMatrix m) {
        if (this.numRows == m.numRows) {
            int[] array = new int[this.numRows];
            array[0] = this.diag[0] - m.diag[0];
            for (int i = 1; i < this.numRows; ++i) {
                array[i] = this.diag[i] - m.diag[i];
            }
            return new IntegerDiagonalMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerDiagonalMatrix subtractDiagonal(AbstractIntegerSquareMatrix m) {
        if (this.numRows == m.numRows) {
            int[] array = new int[this.numRows];
            array[0] = this.diag[0] - m.getElement(0, 0);
            for (int i = 1; i < this.numRows; ++i) {
                array[i] = this.diag[i] - m.getElement(i, i);
            }
            return new IntegerDiagonalMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public AbstractIntegerMatrix scalarMultiply(int x) {
        int[] array = new int[this.numRows];
        array[0] = x * this.diag[0];
        for (int i = 1; i < this.numRows; ++i) {
            array[i] = x * this.diag[i];
        }
        return new IntegerDiagonalMatrix(array);
    }

    @Override
    public int scalarProduct(AbstractIntegerSquareMatrix m) {
        if (m instanceof IntegerDiagonalMatrix) {
            return this.scalarProduct((IntegerDiagonalMatrix)m);
        }
        if (m instanceof IntegerTridiagonalMatrix) {
            return this.scalarProduct((IntegerTridiagonalMatrix)m);
        }
        if (m instanceof IntegerSquareMatrix) {
            return this.scalarProduct((IntegerSquareMatrix)m);
        }
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            int ans = this.diag[0] * m.getElement(0, 0);
            for (int i = 1; i < this.numRows; ++i) {
                ans += this.diag[i] * m.getElement(i, i);
            }
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public int scalarProduct(IntegerSquareMatrix m) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            int ans = this.diag[0] * m.matrix[0][0];
            for (int i = 1; i < this.numRows; ++i) {
                ans += this.diag[i] * m.matrix[i][i];
            }
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public int scalarProduct(IntegerTridiagonalMatrix m) {
        if (this.numRows == m.numRows) {
            int ans = this.diag[0] * m.diag[0];
            for (int i = 1; i < this.numRows; ++i) {
                ans += this.diag[i] * m.diag[i];
            }
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public int scalarProduct(IntegerDiagonalMatrix m) {
        if (this.numRows == m.numRows) {
            int ans = this.diag[0] * m.diag[0];
            for (int i = 1; i < this.numRows; ++i) {
                ans += this.diag[i] * m.diag[i];
            }
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public AbstractIntegerVector multiply(AbstractIntegerVector v) {
        if (this.numCols == v.dimension()) {
            int[] array = new int[this.numRows];
            array[0] = this.diag[0] * v.getComponent(0);
            for (int i = 1; i < this.numRows; ++i) {
                array[i] = this.diag[i] * v.getComponent(i);
            }
            return new IntegerVector(array);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    @Override
    public AbstractIntegerSquareMatrix multiply(AbstractIntegerSquareMatrix m) {
        if (m instanceof IntegerDiagonalMatrix) {
            return this.multiply((IntegerDiagonalMatrix)m);
        }
        if (m instanceof DiagonalMatrix) {
            return this.multiplyDiagonal(m);
        }
        if (m instanceof IntegerTridiagonalMatrix) {
            return this.multiply((IntegerTridiagonalMatrix)m);
        }
        if (m instanceof TridiagonalMatrix) {
            return this.multiplyTridiagonal(m);
        }
        if (m instanceof IntegerSquareMatrix) {
            return this.multiply((IntegerSquareMatrix)m);
        }
        if (this.numCols == m.rows()) {
            int mColumns = m.columns();
            int[][] array = new int[this.numRows][mColumns];
            for (int i = 0; i < this.numRows; ++i) {
                array[i][0] = this.diag[0] * m.getElement(i, 0);
                for (int j = 1; j < mColumns; ++j) {
                    array[i][j] = this.diag[i] * m.getElement(i, j);
                }
            }
            return new IntegerSquareMatrix(array);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public IntegerSquareMatrix multiply(IntegerSquareMatrix m) {
        if (this.numCols == m.numRows) {
            int[][] array = new int[this.numRows][m.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                array[i][0] = this.diag[0] * m.matrix[i][0];
                for (int j = 1; j < m.numCols; ++j) {
                    array[i][j] = this.diag[i] * m.matrix[i][j];
                }
            }
            return new IntegerSquareMatrix(array);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public IntegerTridiagonalMatrix multiply(IntegerTridiagonalMatrix m) {
        int mRow = this.numRows;
        if (this.numCols == m.numRows) {
            IntegerTridiagonalMatrix ans = new IntegerTridiagonalMatrix(mRow);
            ans.diag[0] = this.diag[0] * m.diag[0];
            ans.udiag[0] = this.diag[0] * m.udiag[0];
            --mRow;
            for (int i = 1; i < mRow; ++i) {
                ans.ldiag[i] = this.diag[i] * m.ldiag[i];
                ans.diag[i] = this.diag[i] * m.diag[i];
                ans.udiag[i] = this.diag[i] * m.udiag[i];
            }
            ans.ldiag[mRow] = this.diag[mRow] * m.ldiag[mRow];
            ans.diag[mRow] = this.diag[mRow] * m.diag[mRow];
            return ans;
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private IntegerTridiagonalMatrix multiplyTridiagonal(AbstractIntegerSquareMatrix m) {
        int mRow = this.numRows;
        if (this.numCols == m.rows()) {
            IntegerTridiagonalMatrix ans = new IntegerTridiagonalMatrix(mRow);
            ans.diag[0] = this.diag[0] * m.getElement(0, 0);
            ans.udiag[0] = this.diag[0] * m.getElement(0, 1);
            --mRow;
            for (int i = 1; i < mRow; ++i) {
                ans.ldiag[i] = this.diag[i] * m.getElement(i, i - 1);
                ans.diag[i] = this.diag[i] * m.getElement(i, i);
                ans.udiag[i] = this.diag[i] * m.getElement(i, i + 1);
            }
            ans.ldiag[mRow] = this.diag[mRow] * m.getElement(mRow, mRow - 1);
            ans.diag[mRow] = this.diag[mRow] * m.getElement(mRow, mRow);
            return ans;
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public IntegerDiagonalMatrix multiply(IntegerDiagonalMatrix m) {
        if (this.numCols == m.numRows) {
            int[] array = new int[this.numRows];
            array[0] = this.diag[0] * m.diag[0];
            for (int i = 1; i < this.numRows; ++i) {
                array[i] = this.diag[i] * m.diag[i];
            }
            return new IntegerDiagonalMatrix(array);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private IntegerDiagonalMatrix multiplyDiagonal(AbstractIntegerSquareMatrix m) {
        if (this.numCols == m.rows()) {
            int[] array = new int[this.numRows];
            array[0] = this.diag[0] * m.getElement(0, 0);
            for (int i = 1; i < this.numRows; ++i) {
                array[i] = this.diag[i] * m.getElement(i, i);
            }
            return new IntegerDiagonalMatrix(array);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    @Override
    public Matrix transpose() {
        return this;
    }

    @Override
    public AbstractDoubleSquareMatrix inverse() {
        double[] array = new double[this.numRows];
        array[0] = 1.0 / (double)this.diag[0];
        for (int i = 1; i < this.numRows; ++i) {
            array[i] = 1.0 / (double)this.diag[i];
        }
        return new DoubleDiagonalMatrix(array);
    }

    @Override
    public AbstractDoubleSquareMatrix[] luDecompose(int[] pivot) {
        if (this.LU != null) {
            if (pivot != null) {
                System.arraycopy(this.LUpivot, 0, pivot, 0, pivot.length);
            }
            return this.LU;
        }
        if (pivot == null) {
            pivot = new int[this.numRows + 1];
        }
        for (int i = 0; i < this.numRows; ++i) {
            pivot[i] = i;
        }
        pivot[this.numRows] = 1;
        this.LU = new AbstractDoubleSquareMatrix[2];
        this.LU[0] = DoubleDiagonalMatrix.identity(this.numRows);
        this.LU[1] = (AbstractDoubleSquareMatrix)this.toDoubleMatrix();
        this.LUpivot = new int[pivot.length];
        System.arraycopy(pivot, 0, this.LUpivot, 0, pivot.length);
        return this.LU;
    }

    @Override
    public AbstractDoubleSquareMatrix[] luDecompose() {
        return this.luDecompose(null);
    }

    @Override
    public AbstractDoubleSquareMatrix[] choleskyDecompose() {
        AbstractDoubleSquareMatrix[] lu = new AbstractDoubleSquareMatrix[2];
        double[] array = new double[this.numRows];
        array[0] = Math.sqrt(this.diag[0]);
        for (int i = 1; i < this.numRows; ++i) {
            array[i] = Math.sqrt(this.diag[i]);
        }
        lu[0] = new DoubleDiagonalMatrix(array);
        lu[1] = lu[0];
        return lu;
    }

    @Override
    public AbstractDoubleSquareMatrix[] qrDecompose() {
        AbstractDoubleSquareMatrix[] qr = new AbstractDoubleSquareMatrix[]{DoubleDiagonalMatrix.identity(this.numRows), (AbstractDoubleSquareMatrix)this.toDoubleMatrix()};
        return qr;
    }

    @Override
    public AbstractDoubleSquareMatrix[] singularValueDecompose() {
        int N = this.numRows;
        int Nm1 = N - 1;
        double[] arrayU = new double[N];
        double[] arrayS = new double[N];
        double[] arrayV = new double[N];
        for (int i = 0; i < Nm1; ++i) {
            arrayU[i] = -1.0;
            arrayS[i] = Math.abs(this.diag[i]);
            arrayV[i] = (double)this.diag[i] < 0.0 ? 1.0 : -1.0;
        }
        arrayU[Nm1] = 1.0;
        arrayS[Nm1] = Math.abs(this.diag[Nm1]);
        arrayV[Nm1] = (double)this.diag[Nm1] < 0.0 ? -1.0 : 1.0;
        AbstractDoubleSquareMatrix[] svd = new AbstractDoubleSquareMatrix[]{new DoubleDiagonalMatrix(arrayU), new DoubleDiagonalMatrix(arrayS), new DoubleDiagonalMatrix(arrayV)};
        return svd;
    }
}

