/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.matrices;

import jsci.GlobalSettings;
import jsci.maths.DimensionException;
import jsci.maths.Mapping;
import jsci.maths.matrices.AbstractComplexMatrix;
import jsci.maths.matrices.AbstractDoubleMatrix;
import jsci.maths.matrices.AbstractIntegerMatrix;
import jsci.maths.matrices.ComplexMatrix;
import jsci.maths.matrices.DoubleMatrix;
import jsci.maths.matrices.DoubleSparseSquareMatrix;
import jsci.maths.matrices.DoubleSquareMatrix;
import jsci.maths.matrices.IntegerMatrix;
import jsci.maths.matrices.Matrix;
import jsci.maths.matrices.MatrixDimensionException;
import jsci.maths.vectors.AbstractDoubleVector;
import jsci.maths.vectors.DoubleVector;

public final class DoubleSparseMatrix
extends AbstractDoubleMatrix {
    private double[] elements;
    private int[] colPos;
    private int[] rows;

    public DoubleSparseMatrix(int rowCount, int colCount) {
        super(rowCount, colCount);
        this.elements = new double[0];
        this.colPos = new int[0];
        this.rows = new int[this.numRows + 1];
    }

    public DoubleSparseMatrix(double[][] array) {
        super(array.length, array[0].length);
        int j;
        int i;
        this.rows = new int[this.numRows + 1];
        int n = 0;
        for (i = 0; i < this.numRows; ++i) {
            if (array[i].length != array.length) {
                throw new MatrixDimensionException("Array is not square.");
            }
            for (j = 0; j < this.numCols; ++j) {
                if (!(Math.abs(array[i][j]) > GlobalSettings.ZERO_TOL)) continue;
                ++n;
            }
        }
        this.elements = new double[n];
        this.colPos = new int[n];
        n = 0;
        for (i = 0; i < this.numRows; ++i) {
            this.rows[i] = n;
            for (j = 0; j < this.numCols; ++j) {
                if (!(Math.abs(array[i][j]) > GlobalSettings.ZERO_TOL)) continue;
                this.elements[n] = array[i][j];
                this.colPos[n] = j;
                ++n;
            }
        }
        this.rows[this.numRows] = n;
    }

    @Override
    public boolean equals(AbstractDoubleMatrix m, double tol) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            if (m instanceof DoubleSparseMatrix) {
                return this.equals((DoubleSparseMatrix)m);
            }
            double sumSqr = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    double delta = this.getElement(i, j) - m.getElement(i, j);
                    sumSqr += delta * delta;
                }
            }
            return sumSqr <= tol * tol;
        }
        return false;
    }

    public final boolean equals(DoubleSparseMatrix m) {
        return this.equals(m, GlobalSettings.ZERO_TOL);
    }

    public boolean equals(DoubleSparseMatrix m, double tol) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            if (this.colPos.length != m.colPos.length) {
                return false;
            }
            for (int i = 1; i < this.rows.length; ++i) {
                if (this.rows[i] == m.rows[i]) continue;
                return false;
            }
            double sumSqr = 0.0;
            for (int i = 1; i < this.colPos.length; ++i) {
                if (this.colPos[i] != m.colPos[i]) {
                    return false;
                }
                double delta = this.elements[i] - m.elements[i];
                sumSqr += delta * delta;
            }
            return sumSqr <= tol * tol;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(this.numRows * this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                buf.append(this.getElement(i, j));
                buf.append(' ');
            }
            buf.append('\n');
        }
        return buf.toString();
    }

    @Override
    public AbstractIntegerMatrix toIntegerMatrix() {
        int[][] ans = new int[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                ans[i][j] = Math.round((float)this.getElement(i, j));
            }
        }
        return new IntegerMatrix(ans);
    }

    @Override
    public AbstractComplexMatrix toComplexMatrix() {
        double[][] arrayRe = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                arrayRe[i][j] = this.getElement(i, j);
            }
        }
        return new ComplexMatrix(arrayRe, new double[this.numRows][this.numCols]);
    }

    @Override
    public double getElement(int i, int j) {
        if (i >= 0 && i < this.numRows && j >= 0 && j < this.numCols) {
            for (int k = this.rows[i]; k < this.rows[i + 1]; ++k) {
                if (this.colPos[k] != j) continue;
                return this.elements[k];
            }
            return 0.0;
        }
        throw new MatrixDimensionException(DoubleSparseMatrix.getInvalidElementMsg(i, j));
    }

    @Override
    public void setElement(int i, int j, double x) {
        if (i >= 0 && i < this.numRows && j >= 0 && j < this.numCols) {
            int k;
            if (Math.abs(x) <= GlobalSettings.ZERO_TOL) {
                return;
            }
            for (int k2 = this.rows[i]; k2 < this.rows[i + 1]; ++k2) {
                if (this.colPos[k2] != j) continue;
                this.elements[k2] = x;
                return;
            }
            double[] oldMatrix = this.elements;
            int[] oldColPos = this.colPos;
            this.elements = new double[oldMatrix.length + 1];
            this.colPos = new int[oldColPos.length + 1];
            System.arraycopy(oldMatrix, 0, this.elements, 0, this.rows[i]);
            System.arraycopy(oldColPos, 0, this.colPos, 0, this.rows[i]);
            for (k = this.rows[i]; k < this.rows[i + 1] && oldColPos[k] < j; ++k) {
                this.elements[k] = oldMatrix[k];
                this.colPos[k] = oldColPos[k];
            }
            this.elements[k] = x;
            this.colPos[k] = j;
            System.arraycopy(oldMatrix, k, this.elements, k + 1, oldMatrix.length - k);
            System.arraycopy(oldColPos, k, this.colPos, k + 1, oldColPos.length - k);
            k = i + 1;
            while (k < this.rows.length) {
                int n = k++;
                this.rows[n] = this.rows[n] + 1;
            }
        } else {
            throw new MatrixDimensionException(DoubleSparseMatrix.getInvalidElementMsg(i, j));
        }
    }

    @Override
    public double infNorm() {
        double result = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            double tmpResult = 0.0;
            for (int j = this.rows[i]; j < this.rows[i + 1]; ++j) {
                tmpResult += Math.abs(this.elements[j]);
            }
            if (!(tmpResult > result)) continue;
            result = tmpResult;
        }
        return result;
    }

    @Override
    public double frobeniusNorm() {
        double result = 0.0;
        for (int i = 0; i < this.colPos.length; ++i) {
            result += this.elements[i] * this.elements[i];
        }
        return Math.sqrt(result);
    }

    @Override
    public AbstractDoubleMatrix add(AbstractDoubleMatrix m) {
        if (m instanceof DoubleSparseMatrix) {
            return this.add((DoubleSparseMatrix)m);
        }
        if (m instanceof DoubleMatrix) {
            return this.add((DoubleMatrix)m);
        }
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            double[][] array = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                int j;
                for (j = this.rows[i]; j < this.rows[i + 1]; ++j) {
                    array[i][this.colPos[j]] = this.elements[j];
                }
                double[] dArray = array[i];
                dArray[0] = dArray[0] + m.getElement(i, 0);
                for (j = 1; j < this.numCols; ++j) {
                    double[] dArray2 = array[i];
                    int n = j;
                    dArray2[n] = dArray2[n] + m.getElement(i, j);
                }
            }
            return new DoubleMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleMatrix add(DoubleMatrix m) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            double[][] array = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                int j;
                for (j = this.rows[i]; j < this.rows[i + 1]; ++j) {
                    array[i][this.colPos[j]] = this.elements[j];
                }
                double[] dArray = array[i];
                dArray[0] = dArray[0] + m.matrix[i][0];
                for (j = 1; j < this.numCols; ++j) {
                    double[] dArray2 = array[i];
                    int n = j;
                    dArray2[n] = dArray2[n] + m.matrix[i][j];
                }
            }
            return new DoubleMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSparseMatrix add(DoubleSparseMatrix m) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            DoubleSparseMatrix ans = new DoubleSparseMatrix(this.numRows, this.numCols);
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    ans.setElement(i, j, this.getElement(i, j) + m.getElement(i, j));
                }
            }
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public AbstractDoubleMatrix subtract(AbstractDoubleMatrix m) {
        if (m instanceof DoubleSparseMatrix) {
            return this.subtract((DoubleSparseMatrix)m);
        }
        if (m instanceof DoubleMatrix) {
            return this.subtract((DoubleMatrix)m);
        }
        if (this.numRows == m.rows() && this.numCols == m.columns()) {
            double[][] array = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                int j;
                for (j = this.rows[i]; j < this.rows[i + 1]; ++j) {
                    array[i][this.colPos[j]] = this.elements[j];
                }
                double[] dArray = array[i];
                dArray[0] = dArray[0] - m.getElement(i, 0);
                for (j = 1; j < this.numCols; ++j) {
                    double[] dArray2 = array[i];
                    int n = j;
                    dArray2[n] = dArray2[n] - m.getElement(i, j);
                }
            }
            return new DoubleMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleMatrix subtract(DoubleMatrix m) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            double[][] array = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                int j;
                for (j = this.rows[i]; j < this.rows[i + 1]; ++j) {
                    array[i][this.colPos[j]] = this.elements[j];
                }
                double[] dArray = array[i];
                dArray[0] = dArray[0] - m.matrix[i][0];
                for (j = 1; j < this.numCols; ++j) {
                    double[] dArray2 = array[i];
                    int n = j;
                    dArray2[n] = dArray2[n] - m.matrix[i][j];
                }
            }
            return new DoubleMatrix(array);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSparseMatrix subtract(DoubleSparseMatrix m) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            DoubleSparseMatrix ans = new DoubleSparseMatrix(this.numRows, this.numCols);
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    ans.setElement(i, j, this.getElement(i, j) - m.getElement(i, j));
                }
            }
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public AbstractDoubleMatrix scalarMultiply(double x) {
        DoubleSparseMatrix ans = new DoubleSparseMatrix(this.numRows, this.numCols);
        ans.elements = new double[this.elements.length];
        ans.colPos = new int[this.colPos.length];
        System.arraycopy(this.colPos, 0, ans.colPos, 0, this.colPos.length);
        System.arraycopy(this.rows, 0, ans.rows, 0, this.rows.length);
        for (int i = 0; i < this.colPos.length; ++i) {
            ans.elements[i] = x * this.elements[i];
        }
        return ans;
    }

    @Override
    public AbstractDoubleMatrix scalarDivide(double x) {
        DoubleSparseMatrix ans = new DoubleSparseMatrix(this.numRows, this.numCols);
        ans.elements = new double[this.elements.length];
        ans.colPos = new int[this.colPos.length];
        System.arraycopy(this.colPos, 0, ans.colPos, 0, this.colPos.length);
        System.arraycopy(this.rows, 0, ans.rows, 0, this.rows.length);
        for (int i = 0; i < this.colPos.length; ++i) {
            ans.elements[i] = this.elements[i] / x;
        }
        return ans;
    }

    @Override
    public double scalarProduct(AbstractDoubleMatrix m) {
        if (m instanceof DoubleMatrix) {
            return this.scalarProduct((DoubleMatrix)m);
        }
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            double ans = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = this.rows[i]; j < this.rows[i + 1]; ++j) {
                    ans += this.elements[j] * m.getElement(i, this.colPos[j]);
                }
            }
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public double scalarProduct(DoubleMatrix m) {
        if (this.numRows == m.numRows && this.numCols == m.numCols) {
            double ans = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = this.rows[i]; j < this.rows[i + 1]; ++j) {
                    ans += this.elements[j] * m.matrix[i][this.colPos[j]];
                }
            }
            return ans;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    @Override
    public AbstractDoubleVector multiply(AbstractDoubleVector v) {
        if (this.numCols == v.dimension()) {
            double[] array = new double[this.numRows];
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = this.rows[i]; j < this.rows[i + 1]; ++j) {
                    int n = i;
                    array[n] = array[n] + this.elements[j] * v.getComponent(this.colPos[j]);
                }
            }
            return new DoubleVector(array);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    @Override
    public AbstractDoubleMatrix multiply(AbstractDoubleMatrix m) {
        if (m instanceof DoubleSparseMatrix) {
            return this.multiply((DoubleSparseMatrix)m);
        }
        if (m instanceof DoubleMatrix) {
            return this.multiply((DoubleMatrix)m);
        }
        if (this.numCols == m.numRows) {
            double[][] array = new double[this.numRows][m.numCols];
            for (int j = 0; j < this.numRows; ++j) {
                for (int k = 0; k < m.numCols; ++k) {
                    for (int n = this.rows[j]; n < this.rows[j + 1]; ++n) {
                        double[] dArray = array[j];
                        int n2 = k;
                        dArray[n2] = dArray[n2] + this.elements[n] * m.getElement(this.colPos[n], k);
                    }
                }
            }
            if (this.numRows == m.numCols) {
                return new DoubleSquareMatrix(array);
            }
            return new DoubleMatrix(array);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public AbstractDoubleMatrix multiply(DoubleMatrix m) {
        if (this.numCols == m.numRows) {
            double[][] array = new double[this.numRows][m.numCols];
            for (int j = 0; j < this.numRows; ++j) {
                for (int k = 0; k < m.numCols; ++k) {
                    for (int n = this.rows[j]; n < this.rows[j + 1]; ++n) {
                        double[] dArray = array[j];
                        int n2 = k;
                        dArray[n2] = dArray[n2] + this.elements[n] * m.matrix[this.colPos[n]][k];
                    }
                }
            }
            if (this.numRows == m.numCols) {
                return new DoubleSquareMatrix(array);
            }
            return new DoubleMatrix(array);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public AbstractDoubleMatrix multiply(DoubleSparseMatrix m) {
        if (this.numCols == m.numRows) {
            AbstractDoubleMatrix ans = this.numRows == m.numCols ? new DoubleSparseSquareMatrix(this.numRows) : new DoubleSparseMatrix(this.numRows, m.numCols);
            for (int j = 0; j < ans.numRows; ++j) {
                for (int k = 0; k < ans.numCols; ++k) {
                    double tmp = 0.0;
                    for (int n = this.rows[j]; n < this.rows[j + 1]; ++n) {
                        tmp += this.elements[n] * m.getElement(this.colPos[n], k);
                    }
                    ans.setElement(j, k, tmp);
                }
            }
            return ans;
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    @Override
    public Matrix transpose() {
        DoubleSparseMatrix ans = new DoubleSparseMatrix(this.numCols, this.numRows);
        for (int i = 0; i < this.numRows; ++i) {
            ans.setElement(0, i, this.getElement(i, 0));
            for (int j = 1; j < this.numCols; ++j) {
                ans.setElement(j, i, this.getElement(i, j));
            }
        }
        return ans;
    }

    @Override
    public AbstractDoubleMatrix mapElements(Mapping f) {
        DoubleSparseMatrix ans = new DoubleSparseMatrix(this.numRows, this.numCols);
        ans.elements = new double[this.elements.length];
        ans.colPos = new int[this.colPos.length];
        System.arraycopy(this.colPos, 0, ans.colPos, 0, this.colPos.length);
        System.arraycopy(this.rows, 0, ans.rows, 0, this.rows.length);
        for (int i = 0; i < this.colPos.length; ++i) {
            ans.elements[i] = f.map(this.elements[i]);
        }
        return ans;
    }
}

