/*
 * Decompiled with CFR 0.152.
 */
package jsci.maths.fields;

import jsci.maths.MathDouble;
import jsci.maths.fields.Field;
import jsci.maths.fields.Ring;
import jsci.maths.groups.AbelianGroup;

public final class RealField
implements Field {
    public static final MathDouble ZERO = new MathDouble(0.0);
    public static final MathDouble ONE = new MathDouble(1.0);
    public static final MathDouble PI = new MathDouble(Math.PI);
    public static final MathDouble E = new MathDouble(Math.E);
    public static final MathDouble GAMMA = new MathDouble(0.5772156649015329);
    public static final MathDouble INFINITY = new MathDouble(Double.POSITIVE_INFINITY);
    public static final MathDouble NaN = new MathDouble(Double.NaN);
    private static final RealField _instance = new RealField();

    private RealField() {
    }

    public static final RealField getInstance() {
        return _instance;
    }

    @Override
    public AbelianGroup.Member zero() {
        return ZERO;
    }

    @Override
    public boolean isZero(AbelianGroup.Member g) {
        return ZERO.equals(g);
    }

    @Override
    public boolean isNegative(AbelianGroup.Member a, AbelianGroup.Member b) {
        return ZERO.equals(a.add(b));
    }

    @Override
    public Ring.Member one() {
        return ONE;
    }

    @Override
    public boolean isOne(Ring.Member r) {
        return ONE.equals(r);
    }

    @Override
    public boolean isInverse(Field.Member a, Field.Member b) {
        return ONE.equals(a.multiply(b));
    }
}

